/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for ExternalDataConfiguration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalDataConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * Try to detect schema and format options automatically. Any option specified explicitly will be
   * honored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autodetect;

  /**
   * Optional. Additional properties to set if sourceFormat is set to AVRO.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AvroOptions avroOptions;

  /**
   * Optional. Additional options if sourceFormat is set to BIGTABLE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BigtableOptions bigtableOptions;

  /**
   * Optional. The compression type of the data source. Possible values include GZIP and NONE. The
   * default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud
   * Datastore backups, Avro, ORC and Parquet formats. An empty string is an invalid value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compression;

  /**
   * Optional. The connection specifying the credentials to be used to read external storage, such
   * as Azure Blob, Cloud Storage, or S3. The connection_id can have the form
   * `{project_id}.{location_id};{connection_id}` or
   * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connectionId;

  /**
   * Optional. Additional properties to set if sourceFormat is set to CSV.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CsvOptions csvOptions;

  /**
   * Defines the list of possible SQL data types to which the source decimal values are converted.
   * This list and the precision and the scale parameters of the decimal field determine the target
   * type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the
   * specified list and if it supports the precision and the scale. STRING supports all precision
   * and scale values. If none of the listed types supports the precision and the scale, the type
   * supporting the widest range in the specified list is picked, and if a value exceeds the
   * supported range when reading the data, an error will be thrown. Example: Suppose the value of
   * this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: * (38,9) -> NUMERIC; * (39,9)
   * -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); * (38,10) -> BIGNUMERIC (NUMERIC cannot
   * hold 10 fractional digits); * (76,38) -> BIGNUMERIC; * (77,38) -> BIGNUMERIC (error if value
   * exeeds supported range). This field cannot contain duplicate types. The order of the types in
   * this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC",
   * "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC",
   * "STRING"] for ORC and ["NUMERIC"] for the other file formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> decimalTargetTypes;

  /**
   * Optional. Specifies how source URIs are interpreted for constructing the file set to load. By
   * default source URIs are expanded against the underlying storage. Other options include
   * specifying manifest files. Only applicable to object storage systems.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileSetSpecType;

  /**
   * Optional. Additional options if sourceFormat is set to GOOGLE_SHEETS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleSheetsOptions googleSheetsOptions;

  /**
   * Optional. When set, configures hive partitioning support. Not all storage formats support hive
   * partitioning -- requesting hive partitioning on an unsupported format will lead to an error, as
   * will providing an invalid specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HivePartitioningOptions hivePartitioningOptions;

  /**
   * Optional. Indicates if BigQuery should allow extra values that are not represented in the table
   * schema. If true, the extra values are ignored. If false, records with extra columns are treated
   * as bad records, and if there are too many bad records, an invalid error is returned in the job
   * result. The default value is false. The sourceFormat property determines what BigQuery treats
   * as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
   * Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is
   * ignored. Avro: This setting is ignored. ORC: This setting is ignored. Parquet: This setting is
   * ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreUnknownValues;

  /**
   * Optional. Load option to be used together with source_format newline-delimited JSON to indicate
   * that a variant of JSON is being loaded. To load newline-delimited GeoJSON, specify GEOJSON (and
   * source_format must be set to NEWLINE_DELIMITED_JSON).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jsonExtension;

  /**
   * Optional. Additional properties to set if sourceFormat is set to JSON.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JsonOptions jsonOptions;

  /**
   * Optional. The maximum number of bad records that BigQuery can ignore when reading data. If the
   * number of bad records exceeds this value, an invalid error is returned in the job result. The
   * default value is 0, which requires that all records are valid. This setting is ignored for
   * Google Cloud Bigtable, Google Cloud Datastore backups, Avro, ORC and Parquet formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxBadRecords;

  /**
   * Optional. Metadata Cache Mode for the table. Set this to enable caching of metadata from
   * external data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadataCacheMode;

  /**
   * Optional. ObjectMetadata is used to create Object Tables. Object Tables contain a listing of
   * objects (with their metadata) found at the source_uris. If ObjectMetadata is set, source_format
   * should be omitted. Currently SIMPLE is the only supported Object Metadata type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectMetadata;

  /**
   * Optional. Additional properties to set if sourceFormat is set to PARQUET.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParquetOptions parquetOptions;

  /**
   * Optional. When creating an external table, the user can provide a reference file with the table
   * schema. This is enabled for the following formats: AVRO, PARQUET, ORC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String referenceFileSchemaUri;

  /**
   * Optional. The schema for the data. Schema is required for CSV and JSON formats if autodetect is
   * not on. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, Avro, ORC and
   * Parquet formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableSchema schema;

  /**
   * [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify
   * "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files,
   * specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". For Apache
   * Iceberg tables, specify "ICEBERG". For ORC files, specify "ORC". For Parquet files, specify
   * "PARQUET". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceFormat;

  /**
   * [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud
   * Storage URIs: Each URI can contain one '*' wildcard character and it must come after the
   * 'bucket' name. Size limits related to load jobs apply to external data sources. For Google
   * Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid
   * HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one
   * URI can be specified. Also, the '*' wildcard character is not allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sourceUris;

  /**
   * Try to detect schema and format options automatically. Any option specified explicitly will be
   * honored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutodetect() {
    return autodetect;
  }

  /**
   * Try to detect schema and format options automatically. Any option specified explicitly will be
   * honored.
   * @param autodetect autodetect or {@code null} for none
   */
  public ExternalDataConfiguration setAutodetect(java.lang.Boolean autodetect) {
    this.autodetect = autodetect;
    return this;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to AVRO.
   * @return value or {@code null} for none
   */
  public AvroOptions getAvroOptions() {
    return avroOptions;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to AVRO.
   * @param avroOptions avroOptions or {@code null} for none
   */
  public ExternalDataConfiguration setAvroOptions(AvroOptions avroOptions) {
    this.avroOptions = avroOptions;
    return this;
  }

  /**
   * Optional. Additional options if sourceFormat is set to BIGTABLE.
   * @return value or {@code null} for none
   */
  public BigtableOptions getBigtableOptions() {
    return bigtableOptions;
  }

  /**
   * Optional. Additional options if sourceFormat is set to BIGTABLE.
   * @param bigtableOptions bigtableOptions or {@code null} for none
   */
  public ExternalDataConfiguration setBigtableOptions(BigtableOptions bigtableOptions) {
    this.bigtableOptions = bigtableOptions;
    return this;
  }

  /**
   * Optional. The compression type of the data source. Possible values include GZIP and NONE. The
   * default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud
   * Datastore backups, Avro, ORC and Parquet formats. An empty string is an invalid value.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompression() {
    return compression;
  }

  /**
   * Optional. The compression type of the data source. Possible values include GZIP and NONE. The
   * default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud
   * Datastore backups, Avro, ORC and Parquet formats. An empty string is an invalid value.
   * @param compression compression or {@code null} for none
   */
  public ExternalDataConfiguration setCompression(java.lang.String compression) {
    this.compression = compression;
    return this;
  }

  /**
   * Optional. The connection specifying the credentials to be used to read external storage, such
   * as Azure Blob, Cloud Storage, or S3. The connection_id can have the form
   * `{project_id}.{location_id};{connection_id}` or
   * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getConnectionId() {
    return connectionId;
  }

  /**
   * Optional. The connection specifying the credentials to be used to read external storage, such
   * as Azure Blob, Cloud Storage, or S3. The connection_id can have the form
   * `{project_id}.{location_id};{connection_id}` or
   * `projects/{project_id}/locations/{location_id}/connections/{connection_id}`.
   * @param connectionId connectionId or {@code null} for none
   */
  public ExternalDataConfiguration setConnectionId(java.lang.String connectionId) {
    this.connectionId = connectionId;
    return this;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to CSV.
   * @return value or {@code null} for none
   */
  public CsvOptions getCsvOptions() {
    return csvOptions;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to CSV.
   * @param csvOptions csvOptions or {@code null} for none
   */
  public ExternalDataConfiguration setCsvOptions(CsvOptions csvOptions) {
    this.csvOptions = csvOptions;
    return this;
  }

  /**
   * Defines the list of possible SQL data types to which the source decimal values are converted.
   * This list and the precision and the scale parameters of the decimal field determine the target
   * type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the
   * specified list and if it supports the precision and the scale. STRING supports all precision
   * and scale values. If none of the listed types supports the precision and the scale, the type
   * supporting the widest range in the specified list is picked, and if a value exceeds the
   * supported range when reading the data, an error will be thrown. Example: Suppose the value of
   * this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: * (38,9) -> NUMERIC; * (39,9)
   * -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); * (38,10) -> BIGNUMERIC (NUMERIC cannot
   * hold 10 fractional digits); * (76,38) -> BIGNUMERIC; * (77,38) -> BIGNUMERIC (error if value
   * exeeds supported range). This field cannot contain duplicate types. The order of the types in
   * this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC",
   * "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC",
   * "STRING"] for ORC and ["NUMERIC"] for the other file formats.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDecimalTargetTypes() {
    return decimalTargetTypes;
  }

  /**
   * Defines the list of possible SQL data types to which the source decimal values are converted.
   * This list and the precision and the scale parameters of the decimal field determine the target
   * type. In the order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the
   * specified list and if it supports the precision and the scale. STRING supports all precision
   * and scale values. If none of the listed types supports the precision and the scale, the type
   * supporting the widest range in the specified list is picked, and if a value exceeds the
   * supported range when reading the data, an error will be thrown. Example: Suppose the value of
   * this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: * (38,9) -> NUMERIC; * (39,9)
   * -> BIGNUMERIC (NUMERIC cannot hold 30 integer digits); * (38,10) -> BIGNUMERIC (NUMERIC cannot
   * hold 10 fractional digits); * (76,38) -> BIGNUMERIC; * (77,38) -> BIGNUMERIC (error if value
   * exeeds supported range). This field cannot contain duplicate types. The order of the types in
   * this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"] is the same as ["NUMERIC",
   * "BIGNUMERIC"] and NUMERIC always takes precedence over BIGNUMERIC. Defaults to ["NUMERIC",
   * "STRING"] for ORC and ["NUMERIC"] for the other file formats.
   * @param decimalTargetTypes decimalTargetTypes or {@code null} for none
   */
  public ExternalDataConfiguration setDecimalTargetTypes(java.util.List<java.lang.String> decimalTargetTypes) {
    this.decimalTargetTypes = decimalTargetTypes;
    return this;
  }

  /**
   * Optional. Specifies how source URIs are interpreted for constructing the file set to load. By
   * default source URIs are expanded against the underlying storage. Other options include
   * specifying manifest files. Only applicable to object storage systems.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileSetSpecType() {
    return fileSetSpecType;
  }

  /**
   * Optional. Specifies how source URIs are interpreted for constructing the file set to load. By
   * default source URIs are expanded against the underlying storage. Other options include
   * specifying manifest files. Only applicable to object storage systems.
   * @param fileSetSpecType fileSetSpecType or {@code null} for none
   */
  public ExternalDataConfiguration setFileSetSpecType(java.lang.String fileSetSpecType) {
    this.fileSetSpecType = fileSetSpecType;
    return this;
  }

  /**
   * Optional. Additional options if sourceFormat is set to GOOGLE_SHEETS.
   * @return value or {@code null} for none
   */
  public GoogleSheetsOptions getGoogleSheetsOptions() {
    return googleSheetsOptions;
  }

  /**
   * Optional. Additional options if sourceFormat is set to GOOGLE_SHEETS.
   * @param googleSheetsOptions googleSheetsOptions or {@code null} for none
   */
  public ExternalDataConfiguration setGoogleSheetsOptions(GoogleSheetsOptions googleSheetsOptions) {
    this.googleSheetsOptions = googleSheetsOptions;
    return this;
  }

  /**
   * Optional. When set, configures hive partitioning support. Not all storage formats support hive
   * partitioning -- requesting hive partitioning on an unsupported format will lead to an error, as
   * will providing an invalid specification.
   * @return value or {@code null} for none
   */
  public HivePartitioningOptions getHivePartitioningOptions() {
    return hivePartitioningOptions;
  }

  /**
   * Optional. When set, configures hive partitioning support. Not all storage formats support hive
   * partitioning -- requesting hive partitioning on an unsupported format will lead to an error, as
   * will providing an invalid specification.
   * @param hivePartitioningOptions hivePartitioningOptions or {@code null} for none
   */
  public ExternalDataConfiguration setHivePartitioningOptions(HivePartitioningOptions hivePartitioningOptions) {
    this.hivePartitioningOptions = hivePartitioningOptions;
    return this;
  }

  /**
   * Optional. Indicates if BigQuery should allow extra values that are not represented in the table
   * schema. If true, the extra values are ignored. If false, records with extra columns are treated
   * as bad records, and if there are too many bad records, an invalid error is returned in the job
   * result. The default value is false. The sourceFormat property determines what BigQuery treats
   * as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
   * Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is
   * ignored. Avro: This setting is ignored. ORC: This setting is ignored. Parquet: This setting is
   * ignored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreUnknownValues() {
    return ignoreUnknownValues;
  }

  /**
   * Optional. Indicates if BigQuery should allow extra values that are not represented in the table
   * schema. If true, the extra values are ignored. If false, records with extra columns are treated
   * as bad records, and if there are too many bad records, an invalid error is returned in the job
   * result. The default value is false. The sourceFormat property determines what BigQuery treats
   * as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
   * Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This setting is
   * ignored. Avro: This setting is ignored. ORC: This setting is ignored. Parquet: This setting is
   * ignored.
   * @param ignoreUnknownValues ignoreUnknownValues or {@code null} for none
   */
  public ExternalDataConfiguration setIgnoreUnknownValues(java.lang.Boolean ignoreUnknownValues) {
    this.ignoreUnknownValues = ignoreUnknownValues;
    return this;
  }

  /**
   * Optional. Load option to be used together with source_format newline-delimited JSON to indicate
   * that a variant of JSON is being loaded. To load newline-delimited GeoJSON, specify GEOJSON (and
   * source_format must be set to NEWLINE_DELIMITED_JSON).
   * @return value or {@code null} for none
   */
  public java.lang.String getJsonExtension() {
    return jsonExtension;
  }

  /**
   * Optional. Load option to be used together with source_format newline-delimited JSON to indicate
   * that a variant of JSON is being loaded. To load newline-delimited GeoJSON, specify GEOJSON (and
   * source_format must be set to NEWLINE_DELIMITED_JSON).
   * @param jsonExtension jsonExtension or {@code null} for none
   */
  public ExternalDataConfiguration setJsonExtension(java.lang.String jsonExtension) {
    this.jsonExtension = jsonExtension;
    return this;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to JSON.
   * @return value or {@code null} for none
   */
  public JsonOptions getJsonOptions() {
    return jsonOptions;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to JSON.
   * @param jsonOptions jsonOptions or {@code null} for none
   */
  public ExternalDataConfiguration setJsonOptions(JsonOptions jsonOptions) {
    this.jsonOptions = jsonOptions;
    return this;
  }

  /**
   * Optional. The maximum number of bad records that BigQuery can ignore when reading data. If the
   * number of bad records exceeds this value, an invalid error is returned in the job result. The
   * default value is 0, which requires that all records are valid. This setting is ignored for
   * Google Cloud Bigtable, Google Cloud Datastore backups, Avro, ORC and Parquet formats.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxBadRecords() {
    return maxBadRecords;
  }

  /**
   * Optional. The maximum number of bad records that BigQuery can ignore when reading data. If the
   * number of bad records exceeds this value, an invalid error is returned in the job result. The
   * default value is 0, which requires that all records are valid. This setting is ignored for
   * Google Cloud Bigtable, Google Cloud Datastore backups, Avro, ORC and Parquet formats.
   * @param maxBadRecords maxBadRecords or {@code null} for none
   */
  public ExternalDataConfiguration setMaxBadRecords(java.lang.Integer maxBadRecords) {
    this.maxBadRecords = maxBadRecords;
    return this;
  }

  /**
   * Optional. Metadata Cache Mode for the table. Set this to enable caching of metadata from
   * external data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadataCacheMode() {
    return metadataCacheMode;
  }

  /**
   * Optional. Metadata Cache Mode for the table. Set this to enable caching of metadata from
   * external data source.
   * @param metadataCacheMode metadataCacheMode or {@code null} for none
   */
  public ExternalDataConfiguration setMetadataCacheMode(java.lang.String metadataCacheMode) {
    this.metadataCacheMode = metadataCacheMode;
    return this;
  }

  /**
   * Optional. ObjectMetadata is used to create Object Tables. Object Tables contain a listing of
   * objects (with their metadata) found at the source_uris. If ObjectMetadata is set, source_format
   * should be omitted. Currently SIMPLE is the only supported Object Metadata type.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectMetadata() {
    return objectMetadata;
  }

  /**
   * Optional. ObjectMetadata is used to create Object Tables. Object Tables contain a listing of
   * objects (with their metadata) found at the source_uris. If ObjectMetadata is set, source_format
   * should be omitted. Currently SIMPLE is the only supported Object Metadata type.
   * @param objectMetadata objectMetadata or {@code null} for none
   */
  public ExternalDataConfiguration setObjectMetadata(java.lang.String objectMetadata) {
    this.objectMetadata = objectMetadata;
    return this;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to PARQUET.
   * @return value or {@code null} for none
   */
  public ParquetOptions getParquetOptions() {
    return parquetOptions;
  }

  /**
   * Optional. Additional properties to set if sourceFormat is set to PARQUET.
   * @param parquetOptions parquetOptions or {@code null} for none
   */
  public ExternalDataConfiguration setParquetOptions(ParquetOptions parquetOptions) {
    this.parquetOptions = parquetOptions;
    return this;
  }

  /**
   * Optional. When creating an external table, the user can provide a reference file with the table
   * schema. This is enabled for the following formats: AVRO, PARQUET, ORC.
   * @return value or {@code null} for none
   */
  public java.lang.String getReferenceFileSchemaUri() {
    return referenceFileSchemaUri;
  }

  /**
   * Optional. When creating an external table, the user can provide a reference file with the table
   * schema. This is enabled for the following formats: AVRO, PARQUET, ORC.
   * @param referenceFileSchemaUri referenceFileSchemaUri or {@code null} for none
   */
  public ExternalDataConfiguration setReferenceFileSchemaUri(java.lang.String referenceFileSchemaUri) {
    this.referenceFileSchemaUri = referenceFileSchemaUri;
    return this;
  }

  /**
   * Optional. The schema for the data. Schema is required for CSV and JSON formats if autodetect is
   * not on. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, Avro, ORC and
   * Parquet formats.
   * @return value or {@code null} for none
   */
  public TableSchema getSchema() {
    return schema;
  }

  /**
   * Optional. The schema for the data. Schema is required for CSV and JSON formats if autodetect is
   * not on. Schema is disallowed for Google Cloud Bigtable, Cloud Datastore backups, Avro, ORC and
   * Parquet formats.
   * @param schema schema or {@code null} for none
   */
  public ExternalDataConfiguration setSchema(TableSchema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify
   * "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files,
   * specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". For Apache
   * Iceberg tables, specify "ICEBERG". For ORC files, specify "ORC". For Parquet files, specify
   * "PARQUET". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceFormat() {
    return sourceFormat;
  }

  /**
   * [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify
   * "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files,
   * specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". For Apache
   * Iceberg tables, specify "ICEBERG". For ORC files, specify "ORC". For Parquet files, specify
   * "PARQUET". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
   * @param sourceFormat sourceFormat or {@code null} for none
   */
  public ExternalDataConfiguration setSourceFormat(java.lang.String sourceFormat) {
    this.sourceFormat = sourceFormat;
    return this;
  }

  /**
   * [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud
   * Storage URIs: Each URI can contain one '*' wildcard character and it must come after the
   * 'bucket' name. Size limits related to load jobs apply to external data sources. For Google
   * Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid
   * HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one
   * URI can be specified. Also, the '*' wildcard character is not allowed.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSourceUris() {
    return sourceUris;
  }

  /**
   * [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud
   * Storage URIs: Each URI can contain one '*' wildcard character and it must come after the
   * 'bucket' name. Size limits related to load jobs apply to external data sources. For Google
   * Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid
   * HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one
   * URI can be specified. Also, the '*' wildcard character is not allowed.
   * @param sourceUris sourceUris or {@code null} for none
   */
  public ExternalDataConfiguration setSourceUris(java.util.List<java.lang.String> sourceUris) {
    this.sourceUris = sourceUris;
    return this;
  }

  @Override
  public ExternalDataConfiguration set(String fieldName, Object value) {
    return (ExternalDataConfiguration) super.set(fieldName, value);
  }

  @Override
  public ExternalDataConfiguration clone() {
    return (ExternalDataConfiguration) super.clone();
  }

}
