/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Describes the format of the jobs.query request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Connection properties which can modify the query behavior.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ConnectionProperty> connectionProperties;

  static {
    // hack to force ProGuard to consider ConnectionProperty used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ConnectionProperty.class);
  }

  /**
   * [Optional] Specifies whether the query should be executed as a continuous query. The default
   * value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean continuous;

  /**
   * Optional. If true, creates a new session using a randomly generated session_id. If false, runs
   * query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-
   * session mode. The session location will be set to QueryRequest.location if it is present,
   * otherwise it's set to the default location based on existing routing logic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean createSession;

  /**
   * Optional. Specifies the default datasetId and projectId to assume for any unqualified table
   * names in the query. If not set, all table names in the query string must be qualified in the
   * format 'datasetId.tableId'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatasetReference defaultDataset;

  /**
   * Optional. Custom encryption configuration (e.g., Cloud KMS keys)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EncryptionConfiguration destinationEncryptionConfiguration;

  /**
   * Optional. If set to true, BigQuery doesn't run the job. Instead, if the query is valid,
   * BigQuery returns statistics about the job such as how many bytes would be processed. If the
   * query is invalid, an error returns. The default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dryRun;

  /**
   * Optional. Output format adjustments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataFormatOptions formatOptions;

  /**
   * Optional. If not set, jobs are always required. If set, the query request will follow the
   * behavior described JobCreationMode. [Preview](https://cloud.google.com/products/#product-
   * launch-stages)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobCreationMode;

  /**
   * Optional. Job timeout in milliseconds. If this time limit is exceeded, BigQuery will attempt to
   * stop a longer job, but may not always succeed in canceling it before the job completes. For
   * example, a job that takes more than 60 seconds to complete has a better chance of being stopped
   * than a job that takes 10 seconds to complete. This timeout applies to the query even if a job
   * does not need to be created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long jobTimeoutMs;

  /**
   * The resource type of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Optional. The labels associated with this query. Labels can be used to organize and group query
   * jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase
   * letters, numeric characters, underscores and dashes. International characters are allowed.
   * Label keys must start with a letter and each label in the list must have a different key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The geographic location where the job should run. For more information, see how to [specify
   * locations](https://cloud.google.com/bigquery/docs/locations#specify_locations).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Optional. The maximum number of rows of data to return per page of results. Setting this flag
   * to a small value such as 1000 and then paging through results might improve reliability when
   * the query result set is large. In addition to this limit, responses are also limited to 10 MB.
   * By default, there is no maximum row count, and only the byte limit applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long maxResults;

  /**
   * Optional. Limits the bytes billed for this query. Queries with bytes billed above this limit
   * will fail (without incurring a charge). If unspecified, the project default is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maximumBytesBilled;

  /**
   * GoogleSQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use
   * named (@myparam) query parameters in this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parameterMode;

  /**
   * This property is deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean preserveNulls;

  /**
   * Required. A query string to execute, using Google Standard SQL or legacy SQL syntax. Example:
   * "SELECT COUNT(f1) FROM myProjectId.myDatasetId.myTableId".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * Query parameters for GoogleSQL queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<QueryParameter> queryParameters;

  static {
    // hack to force ProGuard to consider QueryParameter used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(QueryParameter.class);
  }

  /**
   * Optional. A unique user provided identifier to ensure idempotent behavior for queries. Note
   * that this is different from the job_id. It has the following properties: 1. It is case-
   * sensitive, limited to up to 36 ASCII characters. A UUID is recommended. 2. Read only queries
   * can ignore this token since they are nullipotent by definition. 3. For the purposes of
   * idempotency ensured by the request_id, a request is considered duplicate of another only if
   * they have the same request_id and are actually duplicates. When determining whether a request
   * is a duplicate of another request, all parameters in the request that may affect the result are
   * considered. For example, query, connection_properties, query_parameters, use_legacy_sql are
   * parameters that affect the result and are considered when determining whether a request is a
   * duplicate, but properties like timeout_ms don't affect the result and are thus not considered.
   * Dry run query requests are never considered duplicate of another request. 4. When a duplicate
   * mutating query request is detected, it returns: a. the results of the mutation if it completes
   * successfully within the timeout. b. the running operation if it is still in progress at the end
   * of the timeout. 5. Its lifetime is limited to 15 minutes. In other words, if two requests are
   * sent with the same request_id, but more than 15 minutes apart, idempotency is not guaranteed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * Optional. Optional: Specifies the maximum amount of time, in milliseconds, that the client is
   * willing to wait for the query to complete. By default, this limit is 10 seconds (10,000
   * milliseconds). If the query is complete, the jobComplete field in the response is true. If the
   * query has not yet completed, jobComplete is false. You can request a longer timeout period in
   * the timeoutMs field. However, the call is not guaranteed to wait for the specified timeout; it
   * typically returns after around 200 seconds (200,000 milliseconds), even if the query is not
   * complete. If jobComplete is false, you can continue to wait for the query to complete by
   * calling the getQueryResults method until the jobComplete field in the getQueryResults response
   * is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long timeoutMs;

  /**
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is
   * true. If set to false, the query will use BigQuery's GoogleSQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value
   * of flattenResults is ignored; query will be run as if flattenResults is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useLegacySql;

  /**
   * Optional. Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. The default value is
   * true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useQueryCache;

  /**
   * Optional. This is only supported for SELECT query. If set, the query is allowed to write
   * results incrementally to the temporary result table. This may incur a performance penalty. This
   * option cannot be used with Legacy SQL. This feature is not yet available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writeIncrementalResults;

  /**
   * Optional. Connection properties which can modify the query behavior.
   * @return value or {@code null} for none
   */
  public java.util.List<ConnectionProperty> getConnectionProperties() {
    return connectionProperties;
  }

  /**
   * Optional. Connection properties which can modify the query behavior.
   * @param connectionProperties connectionProperties or {@code null} for none
   */
  public QueryRequest setConnectionProperties(java.util.List<ConnectionProperty> connectionProperties) {
    this.connectionProperties = connectionProperties;
    return this;
  }

  /**
   * [Optional] Specifies whether the query should be executed as a continuous query. The default
   * value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getContinuous() {
    return continuous;
  }

  /**
   * [Optional] Specifies whether the query should be executed as a continuous query. The default
   * value is false.
   * @param continuous continuous or {@code null} for none
   */
  public QueryRequest setContinuous(java.lang.Boolean continuous) {
    this.continuous = continuous;
    return this;
  }

  /**
   * Optional. If true, creates a new session using a randomly generated session_id. If false, runs
   * query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-
   * session mode. The session location will be set to QueryRequest.location if it is present,
   * otherwise it's set to the default location based on existing routing logic.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCreateSession() {
    return createSession;
  }

  /**
   * Optional. If true, creates a new session using a randomly generated session_id. If false, runs
   * query with an existing session_id passed in ConnectionProperty, otherwise runs query in non-
   * session mode. The session location will be set to QueryRequest.location if it is present,
   * otherwise it's set to the default location based on existing routing logic.
   * @param createSession createSession or {@code null} for none
   */
  public QueryRequest setCreateSession(java.lang.Boolean createSession) {
    this.createSession = createSession;
    return this;
  }

  /**
   * Optional. Specifies the default datasetId and projectId to assume for any unqualified table
   * names in the query. If not set, all table names in the query string must be qualified in the
   * format 'datasetId.tableId'.
   * @return value or {@code null} for none
   */
  public DatasetReference getDefaultDataset() {
    return defaultDataset;
  }

  /**
   * Optional. Specifies the default datasetId and projectId to assume for any unqualified table
   * names in the query. If not set, all table names in the query string must be qualified in the
   * format 'datasetId.tableId'.
   * @param defaultDataset defaultDataset or {@code null} for none
   */
  public QueryRequest setDefaultDataset(DatasetReference defaultDataset) {
    this.defaultDataset = defaultDataset;
    return this;
  }

  /**
   * Optional. Custom encryption configuration (e.g., Cloud KMS keys)
   * @return value or {@code null} for none
   */
  public EncryptionConfiguration getDestinationEncryptionConfiguration() {
    return destinationEncryptionConfiguration;
  }

  /**
   * Optional. Custom encryption configuration (e.g., Cloud KMS keys)
   * @param destinationEncryptionConfiguration destinationEncryptionConfiguration or {@code null} for none
   */
  public QueryRequest setDestinationEncryptionConfiguration(EncryptionConfiguration destinationEncryptionConfiguration) {
    this.destinationEncryptionConfiguration = destinationEncryptionConfiguration;
    return this;
  }

  /**
   * Optional. If set to true, BigQuery doesn't run the job. Instead, if the query is valid,
   * BigQuery returns statistics about the job such as how many bytes would be processed. If the
   * query is invalid, an error returns. The default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDryRun() {
    return dryRun;
  }

  /**
   * Optional. If set to true, BigQuery doesn't run the job. Instead, if the query is valid,
   * BigQuery returns statistics about the job such as how many bytes would be processed. If the
   * query is invalid, an error returns. The default value is false.
   * @param dryRun dryRun or {@code null} for none
   */
  public QueryRequest setDryRun(java.lang.Boolean dryRun) {
    this.dryRun = dryRun;
    return this;
  }

  /**
   * Optional. Output format adjustments.
   * @return value or {@code null} for none
   */
  public DataFormatOptions getFormatOptions() {
    return formatOptions;
  }

  /**
   * Optional. Output format adjustments.
   * @param formatOptions formatOptions or {@code null} for none
   */
  public QueryRequest setFormatOptions(DataFormatOptions formatOptions) {
    this.formatOptions = formatOptions;
    return this;
  }

  /**
   * Optional. If not set, jobs are always required. If set, the query request will follow the
   * behavior described JobCreationMode. [Preview](https://cloud.google.com/products/#product-
   * launch-stages)
   * @return value or {@code null} for none
   */
  public java.lang.String getJobCreationMode() {
    return jobCreationMode;
  }

  /**
   * Optional. If not set, jobs are always required. If set, the query request will follow the
   * behavior described JobCreationMode. [Preview](https://cloud.google.com/products/#product-
   * launch-stages)
   * @param jobCreationMode jobCreationMode or {@code null} for none
   */
  public QueryRequest setJobCreationMode(java.lang.String jobCreationMode) {
    this.jobCreationMode = jobCreationMode;
    return this;
  }

  /**
   * Optional. Job timeout in milliseconds. If this time limit is exceeded, BigQuery will attempt to
   * stop a longer job, but may not always succeed in canceling it before the job completes. For
   * example, a job that takes more than 60 seconds to complete has a better chance of being stopped
   * than a job that takes 10 seconds to complete. This timeout applies to the query even if a job
   * does not need to be created.
   * @return value or {@code null} for none
   */
  public java.lang.Long getJobTimeoutMs() {
    return jobTimeoutMs;
  }

  /**
   * Optional. Job timeout in milliseconds. If this time limit is exceeded, BigQuery will attempt to
   * stop a longer job, but may not always succeed in canceling it before the job completes. For
   * example, a job that takes more than 60 seconds to complete has a better chance of being stopped
   * than a job that takes 10 seconds to complete. This timeout applies to the query even if a job
   * does not need to be created.
   * @param jobTimeoutMs jobTimeoutMs or {@code null} for none
   */
  public QueryRequest setJobTimeoutMs(java.lang.Long jobTimeoutMs) {
    this.jobTimeoutMs = jobTimeoutMs;
    return this;
  }

  /**
   * The resource type of the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The resource type of the request.
   * @param kind kind or {@code null} for none
   */
  public QueryRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Optional. The labels associated with this query. Labels can be used to organize and group query
   * jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase
   * letters, numeric characters, underscores and dashes. International characters are allowed.
   * Label keys must start with a letter and each label in the list must have a different key.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. The labels associated with this query. Labels can be used to organize and group query
   * jobs. Label keys and values can be no longer than 63 characters, can only contain lowercase
   * letters, numeric characters, underscores and dashes. International characters are allowed.
   * Label keys must start with a letter and each label in the list must have a different key.
   * @param labels labels or {@code null} for none
   */
  public QueryRequest setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The geographic location where the job should run. For more information, see how to [specify
   * locations](https://cloud.google.com/bigquery/docs/locations#specify_locations).
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The geographic location where the job should run. For more information, see how to [specify
   * locations](https://cloud.google.com/bigquery/docs/locations#specify_locations).
   * @param location location or {@code null} for none
   */
  public QueryRequest setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Optional. The maximum number of rows of data to return per page of results. Setting this flag
   * to a small value such as 1000 and then paging through results might improve reliability when
   * the query result set is large. In addition to this limit, responses are also limited to 10 MB.
   * By default, there is no maximum row count, and only the byte limit applies.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxResults() {
    return maxResults;
  }

  /**
   * Optional. The maximum number of rows of data to return per page of results. Setting this flag
   * to a small value such as 1000 and then paging through results might improve reliability when
   * the query result set is large. In addition to this limit, responses are also limited to 10 MB.
   * By default, there is no maximum row count, and only the byte limit applies.
   * @param maxResults maxResults or {@code null} for none
   */
  public QueryRequest setMaxResults(java.lang.Long maxResults) {
    this.maxResults = maxResults;
    return this;
  }

  /**
   * Optional. Limits the bytes billed for this query. Queries with bytes billed above this limit
   * will fail (without incurring a charge). If unspecified, the project default is used.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaximumBytesBilled() {
    return maximumBytesBilled;
  }

  /**
   * Optional. Limits the bytes billed for this query. Queries with bytes billed above this limit
   * will fail (without incurring a charge). If unspecified, the project default is used.
   * @param maximumBytesBilled maximumBytesBilled or {@code null} for none
   */
  public QueryRequest setMaximumBytesBilled(java.lang.Long maximumBytesBilled) {
    this.maximumBytesBilled = maximumBytesBilled;
    return this;
  }

  /**
   * GoogleSQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use
   * named (@myparam) query parameters in this query.
   * @return value or {@code null} for none
   */
  public java.lang.String getParameterMode() {
    return parameterMode;
  }

  /**
   * GoogleSQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use
   * named (@myparam) query parameters in this query.
   * @param parameterMode parameterMode or {@code null} for none
   */
  public QueryRequest setParameterMode(java.lang.String parameterMode) {
    this.parameterMode = parameterMode;
    return this;
  }

  /**
   * This property is deprecated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPreserveNulls() {
    return preserveNulls;
  }

  /**
   * This property is deprecated.
   * @param preserveNulls preserveNulls or {@code null} for none
   */
  public QueryRequest setPreserveNulls(java.lang.Boolean preserveNulls) {
    this.preserveNulls = preserveNulls;
    return this;
  }

  /**
   * Required. A query string to execute, using Google Standard SQL or legacy SQL syntax. Example:
   * "SELECT COUNT(f1) FROM myProjectId.myDatasetId.myTableId".
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * Required. A query string to execute, using Google Standard SQL or legacy SQL syntax. Example:
   * "SELECT COUNT(f1) FROM myProjectId.myDatasetId.myTableId".
   * @param query query or {@code null} for none
   */
  public QueryRequest setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * Query parameters for GoogleSQL queries.
   * @return value or {@code null} for none
   */
  public java.util.List<QueryParameter> getQueryParameters() {
    return queryParameters;
  }

  /**
   * Query parameters for GoogleSQL queries.
   * @param queryParameters queryParameters or {@code null} for none
   */
  public QueryRequest setQueryParameters(java.util.List<QueryParameter> queryParameters) {
    this.queryParameters = queryParameters;
    return this;
  }

  /**
   * Optional. A unique user provided identifier to ensure idempotent behavior for queries. Note
   * that this is different from the job_id. It has the following properties: 1. It is case-
   * sensitive, limited to up to 36 ASCII characters. A UUID is recommended. 2. Read only queries
   * can ignore this token since they are nullipotent by definition. 3. For the purposes of
   * idempotency ensured by the request_id, a request is considered duplicate of another only if
   * they have the same request_id and are actually duplicates. When determining whether a request
   * is a duplicate of another request, all parameters in the request that may affect the result are
   * considered. For example, query, connection_properties, query_parameters, use_legacy_sql are
   * parameters that affect the result and are considered when determining whether a request is a
   * duplicate, but properties like timeout_ms don't affect the result and are thus not considered.
   * Dry run query requests are never considered duplicate of another request. 4. When a duplicate
   * mutating query request is detected, it returns: a. the results of the mutation if it completes
   * successfully within the timeout. b. the running operation if it is still in progress at the end
   * of the timeout. 5. Its lifetime is limited to 15 minutes. In other words, if two requests are
   * sent with the same request_id, but more than 15 minutes apart, idempotency is not guaranteed.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * Optional. A unique user provided identifier to ensure idempotent behavior for queries. Note
   * that this is different from the job_id. It has the following properties: 1. It is case-
   * sensitive, limited to up to 36 ASCII characters. A UUID is recommended. 2. Read only queries
   * can ignore this token since they are nullipotent by definition. 3. For the purposes of
   * idempotency ensured by the request_id, a request is considered duplicate of another only if
   * they have the same request_id and are actually duplicates. When determining whether a request
   * is a duplicate of another request, all parameters in the request that may affect the result are
   * considered. For example, query, connection_properties, query_parameters, use_legacy_sql are
   * parameters that affect the result and are considered when determining whether a request is a
   * duplicate, but properties like timeout_ms don't affect the result and are thus not considered.
   * Dry run query requests are never considered duplicate of another request. 4. When a duplicate
   * mutating query request is detected, it returns: a. the results of the mutation if it completes
   * successfully within the timeout. b. the running operation if it is still in progress at the end
   * of the timeout. 5. Its lifetime is limited to 15 minutes. In other words, if two requests are
   * sent with the same request_id, but more than 15 minutes apart, idempotency is not guaranteed.
   * @param requestId requestId or {@code null} for none
   */
  public QueryRequest setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * Optional. Optional: Specifies the maximum amount of time, in milliseconds, that the client is
   * willing to wait for the query to complete. By default, this limit is 10 seconds (10,000
   * milliseconds). If the query is complete, the jobComplete field in the response is true. If the
   * query has not yet completed, jobComplete is false. You can request a longer timeout period in
   * the timeoutMs field. However, the call is not guaranteed to wait for the specified timeout; it
   * typically returns after around 200 seconds (200,000 milliseconds), even if the query is not
   * complete. If jobComplete is false, you can continue to wait for the query to complete by
   * calling the getQueryResults method until the jobComplete field in the getQueryResults response
   * is true.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimeoutMs() {
    return timeoutMs;
  }

  /**
   * Optional. Optional: Specifies the maximum amount of time, in milliseconds, that the client is
   * willing to wait for the query to complete. By default, this limit is 10 seconds (10,000
   * milliseconds). If the query is complete, the jobComplete field in the response is true. If the
   * query has not yet completed, jobComplete is false. You can request a longer timeout period in
   * the timeoutMs field. However, the call is not guaranteed to wait for the specified timeout; it
   * typically returns after around 200 seconds (200,000 milliseconds), even if the query is not
   * complete. If jobComplete is false, you can continue to wait for the query to complete by
   * calling the getQueryResults method until the jobComplete field in the getQueryResults response
   * is true.
   * @param timeoutMs timeoutMs or {@code null} for none
   */
  public QueryRequest setTimeoutMs(java.lang.Long timeoutMs) {
    this.timeoutMs = timeoutMs;
    return this;
  }

  /**
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is
   * true. If set to false, the query will use BigQuery's GoogleSQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value
   * of flattenResults is ignored; query will be run as if flattenResults is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseLegacySql() {
    return useLegacySql;
  }

  /**
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is
   * true. If set to false, the query will use BigQuery's GoogleSQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value
   * of flattenResults is ignored; query will be run as if flattenResults is false.
   * @param useLegacySql useLegacySql or {@code null} for none
   */
  public QueryRequest setUseLegacySql(java.lang.Boolean useLegacySql) {
    this.useLegacySql = useLegacySql;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
 If set to false, the query will use BigQuery's GoogleSQL: https://cloud.google.com/bigquery/sql-
 reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be
 run as if flattenResults is false.
   * </p>
   */
  public boolean isUseLegacySql() {
    if (useLegacySql == null || useLegacySql == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return useLegacySql;
  }

  /**
   * Optional. Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. The default value is
   * true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseQueryCache() {
    return useQueryCache;
  }

  /**
   * Optional. Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. The default value is
   * true.
   * @param useQueryCache useQueryCache or {@code null} for none
   */
  public QueryRequest setUseQueryCache(java.lang.Boolean useQueryCache) {
    this.useQueryCache = useQueryCache;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Optional. Whether to look for the result in the query cache. The query cache is a best-effort cache
 that will be flushed whenever tables in the query are modified. The default value is true.
   * </p>
   */
  public boolean isUseQueryCache() {
    if (useQueryCache == null || useQueryCache == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return useQueryCache;
  }

  /**
   * Optional. This is only supported for SELECT query. If set, the query is allowed to write
   * results incrementally to the temporary result table. This may incur a performance penalty. This
   * option cannot be used with Legacy SQL. This feature is not yet available.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWriteIncrementalResults() {
    return writeIncrementalResults;
  }

  /**
   * Optional. This is only supported for SELECT query. If set, the query is allowed to write
   * results incrementally to the temporary result table. This may incur a performance penalty. This
   * option cannot be used with Legacy SQL. This feature is not yet available.
   * @param writeIncrementalResults writeIncrementalResults or {@code null} for none
   */
  public QueryRequest setWriteIncrementalResults(java.lang.Boolean writeIncrementalResults) {
    this.writeIncrementalResults = writeIncrementalResults;
    return this;
  }

  @Override
  public QueryRequest set(String fieldName, Object value) {
    return (QueryRequest) super.set(fieldName, value);
  }

  @Override
  public QueryRequest clone() {
    return (QueryRequest) super.clone();
  }

}
