/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * If the stored column was not used, explain why.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StoredColumnsUnusedReason extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the high-level reason for the unused scenario, each reason must have a code
   * associated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String code;

  /**
   * Specifies the detailed description for the scenario.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * Specifies which columns were not covered by the stored columns for the specified code up to 20
   * columns. This is populated when the code is STORED_COLUMNS_COVER_INSUFFICIENT and
   * BASE_TABLE_HAS_CLS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> uncoveredColumns;

  /**
   * Specifies the high-level reason for the unused scenario, each reason must have a code
   * associated.
   * @return value or {@code null} for none
   */
  public java.lang.String getCode() {
    return code;
  }

  /**
   * Specifies the high-level reason for the unused scenario, each reason must have a code
   * associated.
   * @param code code or {@code null} for none
   */
  public StoredColumnsUnusedReason setCode(java.lang.String code) {
    this.code = code;
    return this;
  }

  /**
   * Specifies the detailed description for the scenario.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * Specifies the detailed description for the scenario.
   * @param message message or {@code null} for none
   */
  public StoredColumnsUnusedReason setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  /**
   * Specifies which columns were not covered by the stored columns for the specified code up to 20
   * columns. This is populated when the code is STORED_COLUMNS_COVER_INSUFFICIENT and
   * BASE_TABLE_HAS_CLS.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUncoveredColumns() {
    return uncoveredColumns;
  }

  /**
   * Specifies which columns were not covered by the stored columns for the specified code up to 20
   * columns. This is populated when the code is STORED_COLUMNS_COVER_INSUFFICIENT and
   * BASE_TABLE_HAS_CLS.
   * @param uncoveredColumns uncoveredColumns or {@code null} for none
   */
  public StoredColumnsUnusedReason setUncoveredColumns(java.util.List<java.lang.String> uncoveredColumns) {
    this.uncoveredColumns = uncoveredColumns;
    return this;
  }

  @Override
  public StoredColumnsUnusedReason set(String fieldName, Object value) {
    return (StoredColumnsUnusedReason) super.set(fieldName, value);
  }

  @Override
  public StoredColumnsUnusedReason clone() {
    return (StoredColumnsUnusedReason) super.clone();
  }

}
