/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * A view can be represented in multiple ways. Each representation has its own dialect. This message
 * stores the metadata required for these representations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ForeignViewDefinition extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Represents the dialect of the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dialect;

  /**
   * Required. The query that defines the view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * Optional. Represents the dialect of the query.
   * @return value or {@code null} for none
   */
  public java.lang.String getDialect() {
    return dialect;
  }

  /**
   * Optional. Represents the dialect of the query.
   * @param dialect dialect or {@code null} for none
   */
  public ForeignViewDefinition setDialect(java.lang.String dialect) {
    this.dialect = dialect;
    return this;
  }

  /**
   * Required. The query that defines the view.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * Required. The query that defines the view.
   * @param query query or {@code null} for none
   */
  public ForeignViewDefinition setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  @Override
  public ForeignViewDefinition set(String fieldName, Object value) {
    return (ForeignViewDefinition) super.set(fieldName, value);
  }

  @Override
  public ForeignViewDefinition clone() {
    return (ForeignViewDefinition) super.clone();
  }

}
