/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-04 15:59:39 UTC)
 * on 2016-05-18 at 03:01:01 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for ViewDefinition.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ViewDefinition extends com.google.api.client.json.GenericJson {

  /**
   * [Required] A query that BigQuery executes when the view is referenced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * [Experimental] Describes user-defined function resources used in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserDefinedFunctionResource> userDefinedFunctionResources;

  static {
    // hack to force ProGuard to consider UserDefinedFunctionResource used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(UserDefinedFunctionResource.class);
  }

  /**
   * [Required] A query that BigQuery executes when the view is referenced.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * [Required] A query that BigQuery executes when the view is referenced.
   * @param query query or {@code null} for none
   */
  public ViewDefinition setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * [Experimental] Describes user-defined function resources used in the query.
   * @return value or {@code null} for none
   */
  public java.util.List<UserDefinedFunctionResource> getUserDefinedFunctionResources() {
    return userDefinedFunctionResources;
  }

  /**
   * [Experimental] Describes user-defined function resources used in the query.
   * @param userDefinedFunctionResources userDefinedFunctionResources or {@code null} for none
   */
  public ViewDefinition setUserDefinedFunctionResources(java.util.List<UserDefinedFunctionResource> userDefinedFunctionResources) {
    this.userDefinedFunctionResources = userDefinedFunctionResources;
    return this;
  }

  @Override
  public ViewDefinition set(String fieldName, Object value) {
    return (ViewDefinition) super.set(fieldName, value);
  }

  @Override
  public ViewDefinition clone() {
    return (ViewDefinition) super.clone();
  }

}
