/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-04 15:59:39 UTC)
 * on 2016-05-18 at 04:28:47 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery;

/**
 * Available OAuth 2.0 scopes for use with the BigQuery API.
 *
 * @since 1.4
 */
public class BigqueryScopes {

  /** View and manage your data in Google BigQuery. */
  public static final String BIGQUERY = "https://www.googleapis.com/auth/bigquery";

  /** Insert data into Google BigQuery. */
  public static final String BIGQUERY_INSERTDATA = "https://www.googleapis.com/auth/bigquery.insertdata";

  /** View and manage your data across Google Cloud Platform services. */
  public static final String CLOUD_PLATFORM = "https://www.googleapis.com/auth/cloud-platform";

  /** View your data across Google Cloud Platform services. */
  public static final String CLOUD_PLATFORM_READ_ONLY = "https://www.googleapis.com/auth/cloud-platform.read-only";

  /** Manage your data and permissions in Google Cloud Storage. */
  public static final String DEVSTORAGE_FULL_CONTROL = "https://www.googleapis.com/auth/devstorage.full_control";

  /** View your data in Google Cloud Storage. */
  public static final String DEVSTORAGE_READ_ONLY = "https://www.googleapis.com/auth/devstorage.read_only";

  /** Manage your data in Google Cloud Storage. */
  public static final String DEVSTORAGE_READ_WRITE = "https://www.googleapis.com/auth/devstorage.read_write";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(BIGQUERY);
    set.add(BIGQUERY_INSERTDATA);
    set.add(CLOUD_PLATFORM);
    set.add(CLOUD_PLATFORM_READ_ONLY);
    set.add(DEVSTORAGE_FULL_CONTROL);
    set.add(DEVSTORAGE_READ_ONLY);
    set.add(DEVSTORAGE_READ_WRITE);
    return java.util.Collections.unmodifiableSet(set);
  }

  private BigqueryScopes() {
  }
}
