/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-19 20:48:09 UTC)
 * on 2016-06-01 at 01:49:01 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableReference.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableReference extends com.google.api.client.json.GenericJson {

  /**
   * [Required] The ID of the dataset containing this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasetId;

  /**
   * [Required] The ID of the project containing this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_). The maximum length is 1,024 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableId;

  /**
   * [Required] The ID of the dataset containing this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasetId() {
    return datasetId;
  }

  /**
   * [Required] The ID of the dataset containing this table.
   * @param datasetId datasetId or {@code null} for none
   */
  public TableReference setDatasetId(java.lang.String datasetId) {
    this.datasetId = datasetId;
    return this;
  }

  /**
   * [Required] The ID of the project containing this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * [Required] The ID of the project containing this table.
   * @param projectId projectId or {@code null} for none
   */
  public TableReference setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_). The maximum length is 1,024 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getTableId() {
    return tableId;
  }

  /**
   * [Required] The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_). The maximum length is 1,024 characters.
   * @param tableId tableId or {@code null} for none
   */
  public TableReference setTableId(java.lang.String tableId) {
    this.tableId = tableId;
    return this;
  }

  @Override
  public TableReference set(String fieldName, Object value) {
    return (TableReference) super.set(fieldName, value);
  }

  @Override
  public TableReference clone() {
    return (TableReference) super.clone();
  }

}
