/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-14 at 20:44:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableDataInsertAllRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableDataInsertAllRequest extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] Accept rows that contain values that do not match the schema. The unknown values are
   * ignored. Default is false, which treats unknown values as errors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreUnknownValues;

  /**
   * The resource type of the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The rows to insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Rows> rows;

  static {
    // hack to force ProGuard to consider Rows used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Rows.class);
  }

  /**
   * [Optional] Insert all valid rows of a request, even if invalid rows exist. The default value is
   * false, which causes the entire request to fail if any invalid rows exist.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean skipInvalidRows;

  /**
   * [Experimental] If specified, treats the destination table as a base template, and inserts the
   * rows into an instance table named "{destination}{templateSuffix}". BigQuery will manage
   * creation of the instance table, using the schema of the base template table. See
   * https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables for
   * considerations when working with templates tables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String templateSuffix;

  /**
   * [Optional] Accept rows that contain values that do not match the schema. The unknown values are
   * ignored. Default is false, which treats unknown values as errors.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreUnknownValues() {
    return ignoreUnknownValues;
  }

  /**
   * [Optional] Accept rows that contain values that do not match the schema. The unknown values are
   * ignored. Default is false, which treats unknown values as errors.
   * @param ignoreUnknownValues ignoreUnknownValues or {@code null} for none
   */
  public TableDataInsertAllRequest setIgnoreUnknownValues(java.lang.Boolean ignoreUnknownValues) {
    this.ignoreUnknownValues = ignoreUnknownValues;
    return this;
  }

  /**
   * The resource type of the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The resource type of the response.
   * @param kind kind or {@code null} for none
   */
  public TableDataInsertAllRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The rows to insert.
   * @return value or {@code null} for none
   */
  public java.util.List<Rows> getRows() {
    return rows;
  }

  /**
   * The rows to insert.
   * @param rows rows or {@code null} for none
   */
  public TableDataInsertAllRequest setRows(java.util.List<Rows> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * [Optional] Insert all valid rows of a request, even if invalid rows exist. The default value is
   * false, which causes the entire request to fail if any invalid rows exist.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSkipInvalidRows() {
    return skipInvalidRows;
  }

  /**
   * [Optional] Insert all valid rows of a request, even if invalid rows exist. The default value is
   * false, which causes the entire request to fail if any invalid rows exist.
   * @param skipInvalidRows skipInvalidRows or {@code null} for none
   */
  public TableDataInsertAllRequest setSkipInvalidRows(java.lang.Boolean skipInvalidRows) {
    this.skipInvalidRows = skipInvalidRows;
    return this;
  }

  /**
   * [Experimental] If specified, treats the destination table as a base template, and inserts the
   * rows into an instance table named "{destination}{templateSuffix}". BigQuery will manage
   * creation of the instance table, using the schema of the base template table. See
   * https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables for
   * considerations when working with templates tables.
   * @return value or {@code null} for none
   */
  public java.lang.String getTemplateSuffix() {
    return templateSuffix;
  }

  /**
   * [Experimental] If specified, treats the destination table as a base template, and inserts the
   * rows into an instance table named "{destination}{templateSuffix}". BigQuery will manage
   * creation of the instance table, using the schema of the base template table. See
   * https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables for
   * considerations when working with templates tables.
   * @param templateSuffix templateSuffix or {@code null} for none
   */
  public TableDataInsertAllRequest setTemplateSuffix(java.lang.String templateSuffix) {
    this.templateSuffix = templateSuffix;
    return this;
  }

  @Override
  public TableDataInsertAllRequest set(String fieldName, Object value) {
    return (TableDataInsertAllRequest) super.set(fieldName, value);
  }

  @Override
  public TableDataInsertAllRequest clone() {
    return (TableDataInsertAllRequest) super.clone();
  }

  /**
   * Model definition for TableDataInsertAllRequestRows.
   */
  public static final class Rows extends com.google.api.client.json.GenericJson {

    /**
     * [Optional] A unique ID for each row. BigQuery uses this property to detect duplicate insertion
     * requests on a best-effort basis.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String insertId;

    /**
     * [Required] A JSON object that contains a row of data. The object's properties and values must
     * match the destination table's schema.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, java.lang.Object> json;

    /**
     * [Optional] A unique ID for each row. BigQuery uses this property to detect duplicate insertion
     * requests on a best-effort basis.
     * @return value or {@code null} for none
     */
    public java.lang.String getInsertId() {
      return insertId;
    }

    /**
     * [Optional] A unique ID for each row. BigQuery uses this property to detect duplicate insertion
     * requests on a best-effort basis.
     * @param insertId insertId or {@code null} for none
     */
    public Rows setInsertId(java.lang.String insertId) {
      this.insertId = insertId;
      return this;
    }

    /**
     * [Required] A JSON object that contains a row of data. The object's properties and values must
     * match the destination table's schema.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.Object> getJson() {
      return json;
    }

    /**
     * [Required] A JSON object that contains a row of data. The object's properties and values must
     * match the destination table's schema.
     * @param json json or {@code null} for none
     */
    public Rows setJson(java.util.Map<String, java.lang.Object> json) {
      this.json = json;
      return this;
    }

    @Override
    public Rows set(String fieldName, Object value) {
      return (Rows) super.set(fieldName, value);
    }

    @Override
    public Rows clone() {
      return (Rows) super.clone();
    }

  }

}
