/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-23 at 05:12:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for JobConfigurationQuery.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobConfigurationQuery extends com.google.api.client.json.GenericJson {

  /**
   * If true, allows the query to produce arbitrarily large result tables at a slight cost in
   * performance. Requires destinationTable to be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowLargeResults;

  /**
   * [Optional] Specifies whether the job is allowed to create new tables. The following values are
   * supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
   * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in
   * the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions
   * occur as one atomic update upon job completion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String createDisposition;

  /**
   * [Optional] Specifies the default dataset to use for unqualified table names in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatasetReference defaultDataset;

  /**
   * [Optional] Describes the table where the query results should be stored. If not present, a new
   * table will be created to store the results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference destinationTable;

  /**
   * [Optional] Flattens all nested and repeated fields in the query results. The default value is
   * true. allowLargeResults must be true if this is set to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean flattenResults;

  /**
   * [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this
   * tier will fail (without incurring a charge). If unspecified, this will be set to your project
   * default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maximumBillingTier;

  /**
   * [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond
   * this limit will fail (without incurring a charge). If unspecified, this will be set to your
   * project default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maximumBytesBilled;

  /**
   * [Experimental] Standard SQL only. Whether to use positional (?) or named (@myparam) query
   * parameters in this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parameterMode;

  /**
   * [Deprecated] This property is deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean preserveNulls;

  /**
   * [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH.
   * The default value is INTERACTIVE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priority;

  /**
   * [Required] BigQuery SQL query to execute.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * [Experimental] Query parameters for Standard SQL queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<QueryParameter> queryParameters;

  /**
   * [Experimental] Allows the schema of the desitination table to be updated as a side effect of
   * the query job. Schema update options are supported in two cases: when writeDisposition is
   * WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition
   * of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always
   * overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION:
   * allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required
   * field in the original schema to nullable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> schemaUpdateOptions;

  /**
   * [Optional] If querying an external data source outside of BigQuery, describes the data format,
   * location and other properties of the data source. By defining these properties, the data source
   * can then be queried as if it were a standard BigQuery table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ExternalDataConfiguration> tableDefinitions;

  static {
    // hack to force ProGuard to consider ExternalDataConfiguration used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ExternalDataConfiguration.class);
  }

  /**
   * [Experimental] Specifies whether to use BigQuery's legacy SQL dialect for this query. The
   * default value is true. If set to false, the query will use BigQuery's standard SQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the values
   * of allowLargeResults and flattenResults are ignored; query will be run as if allowLargeResults
   * is true and flattenResults is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useLegacySql;

  /**
   * [Optional] Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. Moreover, the query cache
   * is only available when a query does not have a destination table specified. The default value
   * is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useQueryCache;

  /**
   * [Experimental] Describes user-defined function resources used in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserDefinedFunctionResource> userDefinedFunctionResources;

  /**
   * [Optional] Specifies the action that occurs if the destination table already exists. The
   * following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery
   * overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data
   * to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error
   * is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only
   * occurs if BigQuery is able to complete the job successfully. Creation, truncation and append
   * actions occur as one atomic update upon job completion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String writeDisposition;

  /**
   * If true, allows the query to produce arbitrarily large result tables at a slight cost in
   * performance. Requires destinationTable to be set.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowLargeResults() {
    return allowLargeResults;
  }

  /**
   * If true, allows the query to produce arbitrarily large result tables at a slight cost in
   * performance. Requires destinationTable to be set.
   * @param allowLargeResults allowLargeResults or {@code null} for none
   */
  public JobConfigurationQuery setAllowLargeResults(java.lang.Boolean allowLargeResults) {
    this.allowLargeResults = allowLargeResults;
    return this;
  }

  /**
   * [Optional] Specifies whether the job is allowed to create new tables. The following values are
   * supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
   * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in
   * the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions
   * occur as one atomic update upon job completion.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreateDisposition() {
    return createDisposition;
  }

  /**
   * [Optional] Specifies whether the job is allowed to create new tables. The following values are
   * supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
   * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in
   * the job result. The default value is CREATE_IF_NEEDED. Creation, truncation and append actions
   * occur as one atomic update upon job completion.
   * @param createDisposition createDisposition or {@code null} for none
   */
  public JobConfigurationQuery setCreateDisposition(java.lang.String createDisposition) {
    this.createDisposition = createDisposition;
    return this;
  }

  /**
   * [Optional] Specifies the default dataset to use for unqualified table names in the query.
   * @return value or {@code null} for none
   */
  public DatasetReference getDefaultDataset() {
    return defaultDataset;
  }

  /**
   * [Optional] Specifies the default dataset to use for unqualified table names in the query.
   * @param defaultDataset defaultDataset or {@code null} for none
   */
  public JobConfigurationQuery setDefaultDataset(DatasetReference defaultDataset) {
    this.defaultDataset = defaultDataset;
    return this;
  }

  /**
   * [Optional] Describes the table where the query results should be stored. If not present, a new
   * table will be created to store the results.
   * @return value or {@code null} for none
   */
  public TableReference getDestinationTable() {
    return destinationTable;
  }

  /**
   * [Optional] Describes the table where the query results should be stored. If not present, a new
   * table will be created to store the results.
   * @param destinationTable destinationTable or {@code null} for none
   */
  public JobConfigurationQuery setDestinationTable(TableReference destinationTable) {
    this.destinationTable = destinationTable;
    return this;
  }

  /**
   * [Optional] Flattens all nested and repeated fields in the query results. The default value is
   * true. allowLargeResults must be true if this is set to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFlattenResults() {
    return flattenResults;
  }

  /**
   * [Optional] Flattens all nested and repeated fields in the query results. The default value is
   * true. allowLargeResults must be true if this is set to false.
   * @param flattenResults flattenResults or {@code null} for none
   */
  public JobConfigurationQuery setFlattenResults(java.lang.Boolean flattenResults) {
    this.flattenResults = flattenResults;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   *[ Optional] Flattens all nested and repeated fields in the query results. The default value is true.
[ allowLargeResults must be true if this is set to false.
   * </p>
   */
  public boolean isFlattenResults() {
    if (flattenResults == null || flattenResults == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return flattenResults;
  }

  /**
   * [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this
   * tier will fail (without incurring a charge). If unspecified, this will be set to your project
   * default.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaximumBillingTier() {
    return maximumBillingTier;
  }

  /**
   * [Optional] Limits the billing tier for this job. Queries that have resource usage beyond this
   * tier will fail (without incurring a charge). If unspecified, this will be set to your project
   * default.
   * @param maximumBillingTier maximumBillingTier or {@code null} for none
   */
  public JobConfigurationQuery setMaximumBillingTier(java.lang.Integer maximumBillingTier) {
    this.maximumBillingTier = maximumBillingTier;
    return this;
  }

  /**
   * [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond
   * this limit will fail (without incurring a charge). If unspecified, this will be set to your
   * project default.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaximumBytesBilled() {
    return maximumBytesBilled;
  }

  /**
   * [Optional] Limits the bytes billed for this job. Queries that will have bytes billed beyond
   * this limit will fail (without incurring a charge). If unspecified, this will be set to your
   * project default.
   * @param maximumBytesBilled maximumBytesBilled or {@code null} for none
   */
  public JobConfigurationQuery setMaximumBytesBilled(java.lang.Long maximumBytesBilled) {
    this.maximumBytesBilled = maximumBytesBilled;
    return this;
  }

  /**
   * [Experimental] Standard SQL only. Whether to use positional (?) or named (@myparam) query
   * parameters in this query.
   * @return value or {@code null} for none
   */
  public java.lang.String getParameterMode() {
    return parameterMode;
  }

  /**
   * [Experimental] Standard SQL only. Whether to use positional (?) or named (@myparam) query
   * parameters in this query.
   * @param parameterMode parameterMode or {@code null} for none
   */
  public JobConfigurationQuery setParameterMode(java.lang.String parameterMode) {
    this.parameterMode = parameterMode;
    return this;
  }

  /**
   * [Deprecated] This property is deprecated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPreserveNulls() {
    return preserveNulls;
  }

  /**
   * [Deprecated] This property is deprecated.
   * @param preserveNulls preserveNulls or {@code null} for none
   */
  public JobConfigurationQuery setPreserveNulls(java.lang.Boolean preserveNulls) {
    this.preserveNulls = preserveNulls;
    return this;
  }

  /**
   * [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH.
   * The default value is INTERACTIVE.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriority() {
    return priority;
  }

  /**
   * [Optional] Specifies a priority for the query. Possible values include INTERACTIVE and BATCH.
   * The default value is INTERACTIVE.
   * @param priority priority or {@code null} for none
   */
  public JobConfigurationQuery setPriority(java.lang.String priority) {
    this.priority = priority;
    return this;
  }

  /**
   * [Required] BigQuery SQL query to execute.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * [Required] BigQuery SQL query to execute.
   * @param query query or {@code null} for none
   */
  public JobConfigurationQuery setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * [Experimental] Query parameters for Standard SQL queries.
   * @return value or {@code null} for none
   */
  public java.util.List<QueryParameter> getQueryParameters() {
    return queryParameters;
  }

  /**
   * [Experimental] Query parameters for Standard SQL queries.
   * @param queryParameters queryParameters or {@code null} for none
   */
  public JobConfigurationQuery setQueryParameters(java.util.List<QueryParameter> queryParameters) {
    this.queryParameters = queryParameters;
    return this;
  }

  /**
   * [Experimental] Allows the schema of the desitination table to be updated as a side effect of
   * the query job. Schema update options are supported in two cases: when writeDisposition is
   * WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition
   * of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always
   * overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION:
   * allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required
   * field in the original schema to nullable.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSchemaUpdateOptions() {
    return schemaUpdateOptions;
  }

  /**
   * [Experimental] Allows the schema of the desitination table to be updated as a side effect of
   * the query job. Schema update options are supported in two cases: when writeDisposition is
   * WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition
   * of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always
   * overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION:
   * allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required
   * field in the original schema to nullable.
   * @param schemaUpdateOptions schemaUpdateOptions or {@code null} for none
   */
  public JobConfigurationQuery setSchemaUpdateOptions(java.util.List<java.lang.String> schemaUpdateOptions) {
    this.schemaUpdateOptions = schemaUpdateOptions;
    return this;
  }

  /**
   * [Optional] If querying an external data source outside of BigQuery, describes the data format,
   * location and other properties of the data source. By defining these properties, the data source
   * can then be queried as if it were a standard BigQuery table.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ExternalDataConfiguration> getTableDefinitions() {
    return tableDefinitions;
  }

  /**
   * [Optional] If querying an external data source outside of BigQuery, describes the data format,
   * location and other properties of the data source. By defining these properties, the data source
   * can then be queried as if it were a standard BigQuery table.
   * @param tableDefinitions tableDefinitions or {@code null} for none
   */
  public JobConfigurationQuery setTableDefinitions(java.util.Map<String, ExternalDataConfiguration> tableDefinitions) {
    this.tableDefinitions = tableDefinitions;
    return this;
  }

  /**
   * [Experimental] Specifies whether to use BigQuery's legacy SQL dialect for this query. The
   * default value is true. If set to false, the query will use BigQuery's standard SQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the values
   * of allowLargeResults and flattenResults are ignored; query will be run as if allowLargeResults
   * is true and flattenResults is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseLegacySql() {
    return useLegacySql;
  }

  /**
   * [Experimental] Specifies whether to use BigQuery's legacy SQL dialect for this query. The
   * default value is true. If set to false, the query will use BigQuery's standard SQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the values
   * of allowLargeResults and flattenResults are ignored; query will be run as if allowLargeResults
   * is true and flattenResults is false.
   * @param useLegacySql useLegacySql or {@code null} for none
   */
  public JobConfigurationQuery setUseLegacySql(java.lang.Boolean useLegacySql) {
    this.useLegacySql = useLegacySql;
    return this;
  }

  /**
   * [Optional] Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. Moreover, the query cache
   * is only available when a query does not have a destination table specified. The default value
   * is true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseQueryCache() {
    return useQueryCache;
  }

  /**
   * [Optional] Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. Moreover, the query cache
   * is only available when a query does not have a destination table specified. The default value
   * is true.
   * @param useQueryCache useQueryCache or {@code null} for none
   */
  public JobConfigurationQuery setUseQueryCache(java.lang.Boolean useQueryCache) {
    this.useQueryCache = useQueryCache;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   *[ Optional] Whether to look for the result in the query cache. The query cache is a best-effort
[ cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is
[ only available when a query does not have a destination table specified. The default value is
[ true.
   * </p>
   */
  public boolean isUseQueryCache() {
    if (useQueryCache == null || useQueryCache == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return useQueryCache;
  }

  /**
   * [Experimental] Describes user-defined function resources used in the query.
   * @return value or {@code null} for none
   */
  public java.util.List<UserDefinedFunctionResource> getUserDefinedFunctionResources() {
    return userDefinedFunctionResources;
  }

  /**
   * [Experimental] Describes user-defined function resources used in the query.
   * @param userDefinedFunctionResources userDefinedFunctionResources or {@code null} for none
   */
  public JobConfigurationQuery setUserDefinedFunctionResources(java.util.List<UserDefinedFunctionResource> userDefinedFunctionResources) {
    this.userDefinedFunctionResources = userDefinedFunctionResources;
    return this;
  }

  /**
   * [Optional] Specifies the action that occurs if the destination table already exists. The
   * following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery
   * overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data
   * to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error
   * is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only
   * occurs if BigQuery is able to complete the job successfully. Creation, truncation and append
   * actions occur as one atomic update upon job completion.
   * @return value or {@code null} for none
   */
  public java.lang.String getWriteDisposition() {
    return writeDisposition;
  }

  /**
   * [Optional] Specifies the action that occurs if the destination table already exists. The
   * following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery
   * overwrites the table data. WRITE_APPEND: If the table already exists, BigQuery appends the data
   * to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error
   * is returned in the job result. The default value is WRITE_EMPTY. Each action is atomic and only
   * occurs if BigQuery is able to complete the job successfully. Creation, truncation and append
   * actions occur as one atomic update upon job completion.
   * @param writeDisposition writeDisposition or {@code null} for none
   */
  public JobConfigurationQuery setWriteDisposition(java.lang.String writeDisposition) {
    this.writeDisposition = writeDisposition;
    return this;
  }

  @Override
  public JobConfigurationQuery set(String fieldName, Object value) {
    return (JobConfigurationQuery) super.set(fieldName, value);
  }

  @Override
  public JobConfigurationQuery clone() {
    return (JobConfigurationQuery) super.clone();
  }

}
