/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-12 at 23:59:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for JobList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobList extends com.google.api.client.json.GenericJson {

  /**
   * A hash of this page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * List of jobs that were requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Jobs> jobs;

  static {
    // hack to force ProGuard to consider Jobs used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Jobs.class);
  }

  /**
   * The resource type of the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A token to request the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A hash of this page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * A hash of this page of results.
   * @param etag etag or {@code null} for none
   */
  public JobList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * List of jobs that were requested.
   * @return value or {@code null} for none
   */
  public java.util.List<Jobs> getJobs() {
    return jobs;
  }

  /**
   * List of jobs that were requested.
   * @param jobs jobs or {@code null} for none
   */
  public JobList setJobs(java.util.List<Jobs> jobs) {
    this.jobs = jobs;
    return this;
  }

  /**
   * The resource type of the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The resource type of the response.
   * @param kind kind or {@code null} for none
   */
  public JobList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token to request the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token to request the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public JobList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public JobList set(String fieldName, Object value) {
    return (JobList) super.set(fieldName, value);
  }

  @Override
  public JobList clone() {
    return (JobList) super.clone();
  }

  /**
   * Model definition for JobListJobs.
   */
  public static final class Jobs extends com.google.api.client.json.GenericJson {

    /**
     * [Full-projection-only] Specifies the job configuration.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private JobConfiguration configuration;

    /**
     * A result object that will be present only if the job has failed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ErrorProto errorResult;

    /**
     * Unique opaque ID of the job.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * Job reference uniquely identifying the job.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private JobReference jobReference;

    /**
     * The resource type.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String kind;

    /**
     * Running state of the job. When the state is DONE, errorResult can be checked to determine
     * whether the job succeeded or failed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String state;

    /**
     * [Output-only] Information about the job, including starting time and ending time of the job.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private JobStatistics statistics;

    /**
     * [Full-projection-only] Describes the state of the job.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private JobStatus status;

    /**
     * [Full-projection-only] Email address of the user who ran the job.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("user_email")
    private java.lang.String userEmail;

    /**
     * [Full-projection-only] Specifies the job configuration.
     * @return value or {@code null} for none
     */
    public JobConfiguration getConfiguration() {
      return configuration;
    }

    /**
     * [Full-projection-only] Specifies the job configuration.
     * @param configuration configuration or {@code null} for none
     */
    public Jobs setConfiguration(JobConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * A result object that will be present only if the job has failed.
     * @return value or {@code null} for none
     */
    public ErrorProto getErrorResult() {
      return errorResult;
    }

    /**
     * A result object that will be present only if the job has failed.
     * @param errorResult errorResult or {@code null} for none
     */
    public Jobs setErrorResult(ErrorProto errorResult) {
      this.errorResult = errorResult;
      return this;
    }

    /**
     * Unique opaque ID of the job.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * Unique opaque ID of the job.
     * @param id id or {@code null} for none
     */
    public Jobs setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * Job reference uniquely identifying the job.
     * @return value or {@code null} for none
     */
    public JobReference getJobReference() {
      return jobReference;
    }

    /**
     * Job reference uniquely identifying the job.
     * @param jobReference jobReference or {@code null} for none
     */
    public Jobs setJobReference(JobReference jobReference) {
      this.jobReference = jobReference;
      return this;
    }

    /**
     * The resource type.
     * @return value or {@code null} for none
     */
    public java.lang.String getKind() {
      return kind;
    }

    /**
     * The resource type.
     * @param kind kind or {@code null} for none
     */
    public Jobs setKind(java.lang.String kind) {
      this.kind = kind;
      return this;
    }

    /**
     * Running state of the job. When the state is DONE, errorResult can be checked to determine
     * whether the job succeeded or failed.
     * @return value or {@code null} for none
     */
    public java.lang.String getState() {
      return state;
    }

    /**
     * Running state of the job. When the state is DONE, errorResult can be checked to determine
     * whether the job succeeded or failed.
     * @param state state or {@code null} for none
     */
    public Jobs setState(java.lang.String state) {
      this.state = state;
      return this;
    }

    /**
     * [Output-only] Information about the job, including starting time and ending time of the job.
     * @return value or {@code null} for none
     */
    public JobStatistics getStatistics() {
      return statistics;
    }

    /**
     * [Output-only] Information about the job, including starting time and ending time of the job.
     * @param statistics statistics or {@code null} for none
     */
    public Jobs setStatistics(JobStatistics statistics) {
      this.statistics = statistics;
      return this;
    }

    /**
     * [Full-projection-only] Describes the state of the job.
     * @return value or {@code null} for none
     */
    public JobStatus getStatus() {
      return status;
    }

    /**
     * [Full-projection-only] Describes the state of the job.
     * @param status status or {@code null} for none
     */
    public Jobs setStatus(JobStatus status) {
      this.status = status;
      return this;
    }

    /**
     * [Full-projection-only] Email address of the user who ran the job.
     * @return value or {@code null} for none
     */
    public java.lang.String getUserEmail() {
      return userEmail;
    }

    /**
     * [Full-projection-only] Email address of the user who ran the job.
     * @param userEmail userEmail or {@code null} for none
     */
    public Jobs setUserEmail(java.lang.String userEmail) {
      this.userEmail = userEmail;
      return this;
    }

    @Override
    public Jobs set(String fieldName, Object value) {
      return (Jobs) super.set(fieldName, value);
    }

    @Override
    public Jobs clone() {
      return (Jobs) super.clone();
    }

  }

}
