/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-12 at 23:59:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for Streamingbuffer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Streamingbuffer extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] A lower-bound estimate of the number of bytes currently in the streaming buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger estimatedBytes;

  /**
   * [Output-only] A lower-bound estimate of the number of rows currently in the streaming buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger estimatedRows;

  /**
   * [Output-only] Contains the timestamp of the oldest entry in the streaming buffer, in
   * milliseconds since the epoch, if the streaming buffer is available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger oldestEntryTime;

  /**
   * [Output-only] A lower-bound estimate of the number of bytes currently in the streaming buffer.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getEstimatedBytes() {
    return estimatedBytes;
  }

  /**
   * [Output-only] A lower-bound estimate of the number of bytes currently in the streaming buffer.
   * @param estimatedBytes estimatedBytes or {@code null} for none
   */
  public Streamingbuffer setEstimatedBytes(java.math.BigInteger estimatedBytes) {
    this.estimatedBytes = estimatedBytes;
    return this;
  }

  /**
   * [Output-only] A lower-bound estimate of the number of rows currently in the streaming buffer.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getEstimatedRows() {
    return estimatedRows;
  }

  /**
   * [Output-only] A lower-bound estimate of the number of rows currently in the streaming buffer.
   * @param estimatedRows estimatedRows or {@code null} for none
   */
  public Streamingbuffer setEstimatedRows(java.math.BigInteger estimatedRows) {
    this.estimatedRows = estimatedRows;
    return this;
  }

  /**
   * [Output-only] Contains the timestamp of the oldest entry in the streaming buffer, in
   * milliseconds since the epoch, if the streaming buffer is available.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getOldestEntryTime() {
    return oldestEntryTime;
  }

  /**
   * [Output-only] Contains the timestamp of the oldest entry in the streaming buffer, in
   * milliseconds since the epoch, if the streaming buffer is available.
   * @param oldestEntryTime oldestEntryTime or {@code null} for none
   */
  public Streamingbuffer setOldestEntryTime(java.math.BigInteger oldestEntryTime) {
    this.oldestEntryTime = oldestEntryTime;
    return this;
  }

  @Override
  public Streamingbuffer set(String fieldName, Object value) {
    return (Streamingbuffer) super.set(fieldName, value);
  }

  @Override
  public Streamingbuffer clone() {
    return (Streamingbuffer) super.clone();
  }

}
