/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-26 at 23:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableList extends com.google.api.client.json.GenericJson {

  /**
   * A hash of this page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The type of list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A token to request the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Tables in the requested dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Tables> tables;

  static {
    // hack to force ProGuard to consider Tables used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Tables.class);
  }

  /**
   * The total number of tables in the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalItems;

  /**
   * A hash of this page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * A hash of this page of results.
   * @param etag etag or {@code null} for none
   */
  public TableList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The type of list.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The type of list.
   * @param kind kind or {@code null} for none
   */
  public TableList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token to request the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token to request the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public TableList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Tables in the requested dataset.
   * @return value or {@code null} for none
   */
  public java.util.List<Tables> getTables() {
    return tables;
  }

  /**
   * Tables in the requested dataset.
   * @param tables tables or {@code null} for none
   */
  public TableList setTables(java.util.List<Tables> tables) {
    this.tables = tables;
    return this;
  }

  /**
   * The total number of tables in the dataset.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalItems() {
    return totalItems;
  }

  /**
   * The total number of tables in the dataset.
   * @param totalItems totalItems or {@code null} for none
   */
  public TableList setTotalItems(java.lang.Integer totalItems) {
    this.totalItems = totalItems;
    return this;
  }

  @Override
  public TableList set(String fieldName, Object value) {
    return (TableList) super.set(fieldName, value);
  }

  @Override
  public TableList clone() {
    return (TableList) super.clone();
  }

  /**
   * Model definition for TableListTables.
   */
  public static final class Tables extends com.google.api.client.json.GenericJson {

    /**
     * The user-friendly name for this table.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String friendlyName;

    /**
     * An opaque ID of the table
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The resource type.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String kind;

    /**
     * A reference uniquely identifying the table.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private TableReference tableReference;

    /**
     * The type of table. Possible values are: TABLE, VIEW.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The user-friendly name for this table.
     * @return value or {@code null} for none
     */
    public java.lang.String getFriendlyName() {
      return friendlyName;
    }

    /**
     * The user-friendly name for this table.
     * @param friendlyName friendlyName or {@code null} for none
     */
    public Tables setFriendlyName(java.lang.String friendlyName) {
      this.friendlyName = friendlyName;
      return this;
    }

    /**
     * An opaque ID of the table
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * An opaque ID of the table
     * @param id id or {@code null} for none
     */
    public Tables setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * The resource type.
     * @return value or {@code null} for none
     */
    public java.lang.String getKind() {
      return kind;
    }

    /**
     * The resource type.
     * @param kind kind or {@code null} for none
     */
    public Tables setKind(java.lang.String kind) {
      this.kind = kind;
      return this;
    }

    /**
     * A reference uniquely identifying the table.
     * @return value or {@code null} for none
     */
    public TableReference getTableReference() {
      return tableReference;
    }

    /**
     * A reference uniquely identifying the table.
     * @param tableReference tableReference or {@code null} for none
     */
    public Tables setTableReference(TableReference tableReference) {
      this.tableReference = tableReference;
      return this;
    }

    /**
     * The type of table. Possible values are: TABLE, VIEW.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The type of table. Possible values are: TABLE, VIEW.
     * @param type type or {@code null} for none
     */
    public Tables setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public Tables set(String fieldName, Object value) {
      return (Tables) super.set(fieldName, value);
    }

    @Override
    public Tables clone() {
      return (Tables) super.clone();
    }

  }

}
