/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-18 at 01:08:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for ExplainQueryStage.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExplainQueryStage extends com.google.api.client.json.GenericJson {

  /**
   * Relative amount of time the average shard spent on CPU-bound tasks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double computeRatioAvg;

  /**
   * Relative amount of time the slowest shard spent on CPU-bound tasks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double computeRatioMax;

  /**
   * Unique ID for stage within plan.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Human-readable name for stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Relative amount of time the average shard spent reading input.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double readRatioAvg;

  /**
   * Relative amount of time the slowest shard spent reading input.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double readRatioMax;

  /**
   * Number of records read into the stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long recordsRead;

  /**
   * Number of records written by the stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long recordsWritten;

  /**
   * List of operations within the stage in dependency order (approximately chronological).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExplainQueryStep> steps;

  /**
   * Relative amount of time the average shard spent waiting to be scheduled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double waitRatioAvg;

  /**
   * Relative amount of time the slowest shard spent waiting to be scheduled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double waitRatioMax;

  /**
   * Relative amount of time the average shard spent on writing output.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double writeRatioAvg;

  /**
   * Relative amount of time the slowest shard spent on writing output.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double writeRatioMax;

  /**
   * Relative amount of time the average shard spent on CPU-bound tasks.
   * @return value or {@code null} for none
   */
  public java.lang.Double getComputeRatioAvg() {
    return computeRatioAvg;
  }

  /**
   * Relative amount of time the average shard spent on CPU-bound tasks.
   * @param computeRatioAvg computeRatioAvg or {@code null} for none
   */
  public ExplainQueryStage setComputeRatioAvg(java.lang.Double computeRatioAvg) {
    this.computeRatioAvg = computeRatioAvg;
    return this;
  }

  /**
   * Relative amount of time the slowest shard spent on CPU-bound tasks.
   * @return value or {@code null} for none
   */
  public java.lang.Double getComputeRatioMax() {
    return computeRatioMax;
  }

  /**
   * Relative amount of time the slowest shard spent on CPU-bound tasks.
   * @param computeRatioMax computeRatioMax or {@code null} for none
   */
  public ExplainQueryStage setComputeRatioMax(java.lang.Double computeRatioMax) {
    this.computeRatioMax = computeRatioMax;
    return this;
  }

  /**
   * Unique ID for stage within plan.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Unique ID for stage within plan.
   * @param id id or {@code null} for none
   */
  public ExplainQueryStage setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Human-readable name for stage.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Human-readable name for stage.
   * @param name name or {@code null} for none
   */
  public ExplainQueryStage setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Relative amount of time the average shard spent reading input.
   * @return value or {@code null} for none
   */
  public java.lang.Double getReadRatioAvg() {
    return readRatioAvg;
  }

  /**
   * Relative amount of time the average shard spent reading input.
   * @param readRatioAvg readRatioAvg or {@code null} for none
   */
  public ExplainQueryStage setReadRatioAvg(java.lang.Double readRatioAvg) {
    this.readRatioAvg = readRatioAvg;
    return this;
  }

  /**
   * Relative amount of time the slowest shard spent reading input.
   * @return value or {@code null} for none
   */
  public java.lang.Double getReadRatioMax() {
    return readRatioMax;
  }

  /**
   * Relative amount of time the slowest shard spent reading input.
   * @param readRatioMax readRatioMax or {@code null} for none
   */
  public ExplainQueryStage setReadRatioMax(java.lang.Double readRatioMax) {
    this.readRatioMax = readRatioMax;
    return this;
  }

  /**
   * Number of records read into the stage.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRecordsRead() {
    return recordsRead;
  }

  /**
   * Number of records read into the stage.
   * @param recordsRead recordsRead or {@code null} for none
   */
  public ExplainQueryStage setRecordsRead(java.lang.Long recordsRead) {
    this.recordsRead = recordsRead;
    return this;
  }

  /**
   * Number of records written by the stage.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRecordsWritten() {
    return recordsWritten;
  }

  /**
   * Number of records written by the stage.
   * @param recordsWritten recordsWritten or {@code null} for none
   */
  public ExplainQueryStage setRecordsWritten(java.lang.Long recordsWritten) {
    this.recordsWritten = recordsWritten;
    return this;
  }

  /**
   * List of operations within the stage in dependency order (approximately chronological).
   * @return value or {@code null} for none
   */
  public java.util.List<ExplainQueryStep> getSteps() {
    return steps;
  }

  /**
   * List of operations within the stage in dependency order (approximately chronological).
   * @param steps steps or {@code null} for none
   */
  public ExplainQueryStage setSteps(java.util.List<ExplainQueryStep> steps) {
    this.steps = steps;
    return this;
  }

  /**
   * Relative amount of time the average shard spent waiting to be scheduled.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWaitRatioAvg() {
    return waitRatioAvg;
  }

  /**
   * Relative amount of time the average shard spent waiting to be scheduled.
   * @param waitRatioAvg waitRatioAvg or {@code null} for none
   */
  public ExplainQueryStage setWaitRatioAvg(java.lang.Double waitRatioAvg) {
    this.waitRatioAvg = waitRatioAvg;
    return this;
  }

  /**
   * Relative amount of time the slowest shard spent waiting to be scheduled.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWaitRatioMax() {
    return waitRatioMax;
  }

  /**
   * Relative amount of time the slowest shard spent waiting to be scheduled.
   * @param waitRatioMax waitRatioMax or {@code null} for none
   */
  public ExplainQueryStage setWaitRatioMax(java.lang.Double waitRatioMax) {
    this.waitRatioMax = waitRatioMax;
    return this;
  }

  /**
   * Relative amount of time the average shard spent on writing output.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWriteRatioAvg() {
    return writeRatioAvg;
  }

  /**
   * Relative amount of time the average shard spent on writing output.
   * @param writeRatioAvg writeRatioAvg or {@code null} for none
   */
  public ExplainQueryStage setWriteRatioAvg(java.lang.Double writeRatioAvg) {
    this.writeRatioAvg = writeRatioAvg;
    return this;
  }

  /**
   * Relative amount of time the slowest shard spent on writing output.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWriteRatioMax() {
    return writeRatioMax;
  }

  /**
   * Relative amount of time the slowest shard spent on writing output.
   * @param writeRatioMax writeRatioMax or {@code null} for none
   */
  public ExplainQueryStage setWriteRatioMax(java.lang.Double writeRatioMax) {
    this.writeRatioMax = writeRatioMax;
    return this;
  }

  @Override
  public ExplainQueryStage set(String fieldName, Object value) {
    return (ExplainQueryStage) super.set(fieldName, value);
  }

  @Override
  public ExplainQueryStage clone() {
    return (ExplainQueryStage) super.clone();
  }

}
