/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-10-17 16:43:55 UTC)
 * on 2016-10-25 at 05:54:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for JobStatistics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobStatistics extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] Creation time of this job, in milliseconds since the epoch. This field will be
   * present on all jobs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * [Output-only] End time of this job, in milliseconds since the epoch. This field will be present
   * whenever a job is in the DONE state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long endTime;

  /**
   * [Output-only] Statistics for an extract job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobStatistics4 extract;

  /**
   * [Output-only] Statistics for a load job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobStatistics3 load;

  /**
   * [Output-only] Statistics for a query job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobStatistics2 query;

  /**
   * [Output-only] Start time of this job, in milliseconds since the epoch. This field will be
   * present when the job transitions from the PENDING state to either RUNNING or DONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long startTime;

  /**
   * [Output-only] [Deprecated] Use the bytes processed in the query statistics instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalBytesProcessed;

  /**
   * [Output-only] Creation time of this job, in milliseconds since the epoch. This field will be
   * present on all jobs.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * [Output-only] Creation time of this job, in milliseconds since the epoch. This field will be
   * present on all jobs.
   * @param creationTime creationTime or {@code null} for none
   */
  public JobStatistics setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * [Output-only] End time of this job, in milliseconds since the epoch. This field will be present
   * whenever a job is in the DONE state.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEndTime() {
    return endTime;
  }

  /**
   * [Output-only] End time of this job, in milliseconds since the epoch. This field will be present
   * whenever a job is in the DONE state.
   * @param endTime endTime or {@code null} for none
   */
  public JobStatistics setEndTime(java.lang.Long endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * [Output-only] Statistics for an extract job.
   * @return value or {@code null} for none
   */
  public JobStatistics4 getExtract() {
    return extract;
  }

  /**
   * [Output-only] Statistics for an extract job.
   * @param extract extract or {@code null} for none
   */
  public JobStatistics setExtract(JobStatistics4 extract) {
    this.extract = extract;
    return this;
  }

  /**
   * [Output-only] Statistics for a load job.
   * @return value or {@code null} for none
   */
  public JobStatistics3 getLoad() {
    return load;
  }

  /**
   * [Output-only] Statistics for a load job.
   * @param load load or {@code null} for none
   */
  public JobStatistics setLoad(JobStatistics3 load) {
    this.load = load;
    return this;
  }

  /**
   * [Output-only] Statistics for a query job.
   * @return value or {@code null} for none
   */
  public JobStatistics2 getQuery() {
    return query;
  }

  /**
   * [Output-only] Statistics for a query job.
   * @param query query or {@code null} for none
   */
  public JobStatistics setQuery(JobStatistics2 query) {
    this.query = query;
    return this;
  }

  /**
   * [Output-only] Start time of this job, in milliseconds since the epoch. This field will be
   * present when the job transitions from the PENDING state to either RUNNING or DONE.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStartTime() {
    return startTime;
  }

  /**
   * [Output-only] Start time of this job, in milliseconds since the epoch. This field will be
   * present when the job transitions from the PENDING state to either RUNNING or DONE.
   * @param startTime startTime or {@code null} for none
   */
  public JobStatistics setStartTime(java.lang.Long startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * [Output-only] [Deprecated] Use the bytes processed in the query statistics instead.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalBytesProcessed() {
    return totalBytesProcessed;
  }

  /**
   * [Output-only] [Deprecated] Use the bytes processed in the query statistics instead.
   * @param totalBytesProcessed totalBytesProcessed or {@code null} for none
   */
  public JobStatistics setTotalBytesProcessed(java.lang.Long totalBytesProcessed) {
    this.totalBytesProcessed = totalBytesProcessed;
    return this;
  }

  @Override
  public JobStatistics set(String fieldName, Object value) {
    return (JobStatistics) super.set(fieldName, value);
  }

  @Override
  public JobStatistics clone() {
    return (JobStatistics) super.clone();
  }

}
