/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-11 at 21:14:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for JobConfigurationExtract.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobConfigurationExtract extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] The compression type to use for exported files. Possible values include GZIP and
   * NONE. The default value is NONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compression;

  /**
   * [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and
   * AVRO. The default value is CSV. Tables with nested or repeated fields cannot be exported as
   * CSV.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationFormat;

  /**
   * [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The
   * fully-qualified Google Cloud Storage URI where the extracted table should be written.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationUri;

  /**
   * [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should
   * be written.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> destinationUris;

  /**
   * [Optional] Delimiter to use between fields in the exported data. Default is ','
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldDelimiter;

  /**
   * [Optional] Whether to print out a header row in the results. Default is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean printHeader;

  /**
   * [Required] A reference to the table being exported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference sourceTable;

  /**
   * [Optional] The compression type to use for exported files. Possible values include GZIP and
   * NONE. The default value is NONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompression() {
    return compression;
  }

  /**
   * [Optional] The compression type to use for exported files. Possible values include GZIP and
   * NONE. The default value is NONE.
   * @param compression compression or {@code null} for none
   */
  public JobConfigurationExtract setCompression(java.lang.String compression) {
    this.compression = compression;
    return this;
  }

  /**
   * [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and
   * AVRO. The default value is CSV. Tables with nested or repeated fields cannot be exported as
   * CSV.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationFormat() {
    return destinationFormat;
  }

  /**
   * [Optional] The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and
   * AVRO. The default value is CSV. Tables with nested or repeated fields cannot be exported as
   * CSV.
   * @param destinationFormat destinationFormat or {@code null} for none
   */
  public JobConfigurationExtract setDestinationFormat(java.lang.String destinationFormat) {
    this.destinationFormat = destinationFormat;
    return this;
  }

  /**
   * [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The
   * fully-qualified Google Cloud Storage URI where the extracted table should be written.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationUri() {
    return destinationUri;
  }

  /**
   * [Pick one] DEPRECATED: Use destinationUris instead, passing only one URI as necessary. The
   * fully-qualified Google Cloud Storage URI where the extracted table should be written.
   * @param destinationUri destinationUri or {@code null} for none
   */
  public JobConfigurationExtract setDestinationUri(java.lang.String destinationUri) {
    this.destinationUri = destinationUri;
    return this;
  }

  /**
   * [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should
   * be written.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDestinationUris() {
    return destinationUris;
  }

  /**
   * [Pick one] A list of fully-qualified Google Cloud Storage URIs where the extracted table should
   * be written.
   * @param destinationUris destinationUris or {@code null} for none
   */
  public JobConfigurationExtract setDestinationUris(java.util.List<java.lang.String> destinationUris) {
    this.destinationUris = destinationUris;
    return this;
  }

  /**
   * [Optional] Delimiter to use between fields in the exported data. Default is ','
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldDelimiter() {
    return fieldDelimiter;
  }

  /**
   * [Optional] Delimiter to use between fields in the exported data. Default is ','
   * @param fieldDelimiter fieldDelimiter or {@code null} for none
   */
  public JobConfigurationExtract setFieldDelimiter(java.lang.String fieldDelimiter) {
    this.fieldDelimiter = fieldDelimiter;
    return this;
  }

  /**
   * [Optional] Whether to print out a header row in the results. Default is true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrintHeader() {
    return printHeader;
  }

  /**
   * [Optional] Whether to print out a header row in the results. Default is true.
   * @param printHeader printHeader or {@code null} for none
   */
  public JobConfigurationExtract setPrintHeader(java.lang.Boolean printHeader) {
    this.printHeader = printHeader;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   *[ Optional] Whether to print out a header row in the results. Default is true.
   * </p>
   */
  public boolean isPrintHeader() {
    if (printHeader == null || printHeader == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return printHeader;
  }

  /**
   * [Required] A reference to the table being exported.
   * @return value or {@code null} for none
   */
  public TableReference getSourceTable() {
    return sourceTable;
  }

  /**
   * [Required] A reference to the table being exported.
   * @param sourceTable sourceTable or {@code null} for none
   */
  public JobConfigurationExtract setSourceTable(TableReference sourceTable) {
    this.sourceTable = sourceTable;
    return this;
  }

  @Override
  public JobConfigurationExtract set(String fieldName, Object value) {
    return (JobConfigurationExtract) super.set(fieldName, value);
  }

  @Override
  public JobConfigurationExtract clone() {
    return (JobConfigurationExtract) super.clone();
  }

}
