/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-03-15 at 01:31:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery;

/**
 * Service definition for Bigquery (v2).
 *
 * <p>
 * A data platform for customers to create, manage, share and query data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/bigquery/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link BigqueryRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Bigquery extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.20.0 of the BigQuery API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Bigquery(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Bigquery(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Datasets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Datasets.List request = bigquery.datasets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Datasets datasets() {
    return new Datasets();
  }

  /**
   * The "datasets" collection of methods.
   */
  public class Datasets {

    /**
     * Deletes the dataset specified by the datasetId value. Before you can delete a dataset, you must
     * delete all its tables, either manually or by specifying deleteContents. Immediately after
     * deletion, you can create another dataset with the same name.
     *
     * Create a request for the method "datasets.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the dataset being deleted
     * @param datasetId Dataset ID of dataset being deleted
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Deletes the dataset specified by the datasetId value. Before you can delete a dataset, you must
       * delete all its tables, either manually or by specifying deleteContents. Immediately after
       * deletion, you can create another dataset with the same name.
       *
       * Create a request for the method "datasets.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the dataset being deleted
       * @param datasetId Dataset ID of dataset being deleted
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the dataset being deleted
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the dataset being deleted */
      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of dataset being deleted
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of dataset being deleted */
      public Delete setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /**
       * If True, delete all the tables in the dataset. If False and the dataset contains tables,
       * the request will fail. Default is False
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean deleteContents;

      /** If True, delete all the tables in the dataset. If False and the dataset contains tables, the
     request will fail. Default is False
       */
      public java.lang.Boolean getDeleteContents() {
        return deleteContents;
      }

      /**
       * If True, delete all the tables in the dataset. If False and the dataset contains tables,
       * the request will fail. Default is False
       */
      public Delete setDeleteContents(java.lang.Boolean deleteContents) {
        this.deleteContents = deleteContents;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the dataset specified by datasetID.
     *
     * Create a request for the method "datasets.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the requested dataset
     * @param datasetId Dataset ID of the requested dataset
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Returns the dataset specified by datasetID.
       *
       * Create a request for the method "datasets.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the requested dataset
       * @param datasetId Dataset ID of the requested dataset
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the requested dataset */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the requested dataset
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the requested dataset */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the requested dataset */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the requested dataset
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the requested dataset */
      public Get setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new empty dataset.
     *
     * Create a request for the method "datasets.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the new dataset
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets";

      /**
       * Creates a new empty dataset.
       *
       * Create a request for the method "datasets.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the new dataset
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the new dataset */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the new dataset
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the new dataset */
      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all datasets in the specified project to which you have been granted the READER dataset
     * role.
     *
     * Create a request for the method "datasets.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the datasets to be listed
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.DatasetList> {

      private static final String REST_PATH = "projects/{projectId}/datasets";

      /**
       * Lists all datasets in the specified project to which you have been granted the READER dataset
       * role.
       *
       * Create a request for the method "datasets.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the datasets to be listed
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.DatasetList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the datasets to be listed */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the datasets to be listed
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the datasets to be listed */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Whether to list all datasets, including hidden ones */
      @com.google.api.client.util.Key
      private java.lang.Boolean all;

      /** Whether to list all datasets, including hidden ones
       */
      public java.lang.Boolean getAll() {
        return all;
      }

      /** Whether to list all datasets, including hidden ones */
      public List setAll(java.lang.Boolean all) {
        this.all = all;
        return this;
      }

      /**
       * An expression for filtering the results of the request by label. The syntax is
       * "labels.[:]". Multiple filters can be ANDed together by connecting with a space. Example:
       * "labels.department:receiving labels.active". See Filtering datasets using labels for
       * details.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** An expression for filtering the results of the request by label. The syntax is "labels.[:]".
     Multiple filters can be ANDed together by connecting with a space. Example:
     "labels.department:receiving labels.active". See Filtering datasets using labels for details.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * An expression for filtering the results of the request by label. The syntax is
       * "labels.[:]". Multiple filters can be ANDed together by connecting with a space. Example:
       * "labels.department:receiving labels.active". See Filtering datasets using labels for
       * details.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** The maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing dataset. The update method replaces the entire dataset
     * resource, whereas the patch method only replaces fields that are provided in the submitted
     * dataset resource. This method supports patch semantics.
     *
     * Create a request for the method "datasets.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the dataset being updated
     * @param datasetId Dataset ID of the dataset being updated
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Updates information in an existing dataset. The update method replaces the entire dataset
       * resource, whereas the patch method only replaces fields that are provided in the submitted
       * dataset resource. This method supports patch semantics.
       *
       * Create a request for the method "datasets.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the dataset being updated
       * @param datasetId Dataset ID of the dataset being updated
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the dataset being updated
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the dataset being updated */
      public Patch setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the dataset being updated
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the dataset being updated */
      public Patch setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing dataset. The update method replaces the entire dataset
     * resource, whereas the patch method only replaces fields that are provided in the submitted
     * dataset resource.
     *
     * Create a request for the method "datasets.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the dataset being updated
     * @param datasetId Dataset ID of the dataset being updated
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";

      /**
       * Updates information in an existing dataset. The update method replaces the entire dataset
       * resource, whereas the patch method only replaces fields that are provided in the submitted
       * dataset resource.
       *
       * Create a request for the method "datasets.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the dataset being updated
       * @param datasetId Dataset ID of the dataset being updated
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the dataset being updated
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the dataset being updated */
      public Update setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the dataset being updated
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the dataset being updated */
      public Update setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Jobs collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Jobs.List request = bigquery.jobs().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Jobs jobs() {
    return new Jobs();
  }

  /**
   * The "jobs" collection of methods.
   */
  public class Jobs {

    /**
     * Requests that a job be cancelled. This call will return immediately, and the client will need to
     * poll for the job status to see if the cancel completed successfully. Cancelled jobs may still
     * incur costs.
     *
     * Create a request for the method "jobs.cancel".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param projectId [Required] Project ID of the job to cancel
     * @param jobId [Required] Job ID of the job to cancel
     * @return the request
     */
    public Cancel cancel(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Cancel result = new Cancel(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Cancel extends BigqueryRequest<com.google.api.services.bigquery.model.JobCancelResponse> {

      private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}/cancel";

      /**
       * Requests that a job be cancelled. This call will return immediately, and the client will need
       * to poll for the job status to see if the cancel completed successfully. Cancelled jobs may
       * still incur costs.
       *
       * Create a request for the method "jobs.cancel".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId [Required] Project ID of the job to cancel
       * @param jobId [Required] Job ID of the job to cancel
       * @since 1.13
       */
      protected Cancel(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "POST", REST_PATH, null, com.google.api.services.bigquery.model.JobCancelResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUserIp(java.lang.String userIp) {
        return (Cancel) super.setUserIp(userIp);
      }

      /** [Required] Project ID of the job to cancel */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**[ Required] Project ID of the job to cancel
    [

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** [Required] Project ID of the job to cancel */
      public Cancel setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** [Required] Job ID of the job to cancel */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /**[ Required] Job ID of the job to cancel
    [

       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** [Required] Job ID of the job to cancel */
      public Cancel setJobId(java.lang.String jobId) {
        this.jobId = jobId;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Returns information about a specific job. Job information is available for a six month period
     * after creation. Requires that you're the person who ran the job, or have the Is Owner project
     * role.
     *
     * Create a request for the method "jobs.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId [Required] Project ID of the requested job
     * @param jobId [Required] Job ID of the requested job
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Get result = new Get(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Job> {

      private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}";

      /**
       * Returns information about a specific job. Job information is available for a six month period
       * after creation. Requires that you're the person who ran the job, or have the Is Owner project
       * role.
       *
       * Create a request for the method "jobs.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId [Required] Project ID of the requested job
       * @param jobId [Required] Job ID of the requested job
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** [Required] Project ID of the requested job */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**[ Required] Project ID of the requested job
    [

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** [Required] Project ID of the requested job */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** [Required] Job ID of the requested job */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /**[ Required] Job ID of the requested job
    [

       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** [Required] Job ID of the requested job */
      public Get setJobId(java.lang.String jobId) {
        this.jobId = jobId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the results of a query job.
     *
     * Create a request for the method "jobs.getQueryResults".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetQueryResults#execute()} method to invoke the remote operation.
     *
     * @param projectId [Required] Project ID of the query job
     * @param jobId [Required] Job ID of the query job
     * @return the request
     */
    public GetQueryResults getQueryResults(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      GetQueryResults result = new GetQueryResults(projectId, jobId);
      initialize(result);
      return result;
    }

    public class GetQueryResults extends BigqueryRequest<com.google.api.services.bigquery.model.GetQueryResultsResponse> {

      private static final String REST_PATH = "projects/{projectId}/queries/{jobId}";

      /**
       * Retrieves the results of a query job.
       *
       * Create a request for the method "jobs.getQueryResults".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetQueryResults#execute()} method to invoke the remote
       * operation. <p> {@link GetQueryResults#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param projectId [Required] Project ID of the query job
       * @param jobId [Required] Job ID of the query job
       * @since 1.13
       */
      protected GetQueryResults(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.GetQueryResultsResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetQueryResults setAlt(java.lang.String alt) {
        return (GetQueryResults) super.setAlt(alt);
      }

      @Override
      public GetQueryResults setFields(java.lang.String fields) {
        return (GetQueryResults) super.setFields(fields);
      }

      @Override
      public GetQueryResults setKey(java.lang.String key) {
        return (GetQueryResults) super.setKey(key);
      }

      @Override
      public GetQueryResults setOauthToken(java.lang.String oauthToken) {
        return (GetQueryResults) super.setOauthToken(oauthToken);
      }

      @Override
      public GetQueryResults setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetQueryResults) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetQueryResults setQuotaUser(java.lang.String quotaUser) {
        return (GetQueryResults) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetQueryResults setUserIp(java.lang.String userIp) {
        return (GetQueryResults) super.setUserIp(userIp);
      }

      /** [Required] Project ID of the query job */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**[ Required] Project ID of the query job
    [

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** [Required] Project ID of the query job */
      public GetQueryResults setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** [Required] Job ID of the query job */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /**[ Required] Job ID of the query job
    [

       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** [Required] Job ID of the query job */
      public GetQueryResults setJobId(java.lang.String jobId) {
        this.jobId = jobId;
        return this;
      }

      /** Maximum number of results to read */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to read
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to read */
      public GetQueryResults setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public GetQueryResults setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Zero-based index of the starting row */
      @com.google.api.client.util.Key
      private java.math.BigInteger startIndex;

      /** Zero-based index of the starting row
       */
      public java.math.BigInteger getStartIndex() {
        return startIndex;
      }

      /** Zero-based index of the starting row */
      public GetQueryResults setStartIndex(java.math.BigInteger startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      /**
       * How long to wait for the query to complete, in milliseconds, before returning. Default is
       * 10 seconds. If the timeout passes before the job completes, the 'jobComplete' field in the
       * response will be false
       */
      @com.google.api.client.util.Key
      private java.lang.Long timeoutMs;

      /** How long to wait for the query to complete, in milliseconds, before returning. Default is 10
     seconds. If the timeout passes before the job completes, the 'jobComplete' field in the response
     will be false
       */
      public java.lang.Long getTimeoutMs() {
        return timeoutMs;
      }

      /**
       * How long to wait for the query to complete, in milliseconds, before returning. Default is
       * 10 seconds. If the timeout passes before the job completes, the 'jobComplete' field in the
       * response will be false
       */
      public GetQueryResults setTimeoutMs(java.lang.Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
      }

      @Override
      public GetQueryResults set(String parameterName, Object value) {
        return (GetQueryResults) super.set(parameterName, value);
      }
    }
    /**
     * Starts a new asynchronous job. Requires the Can View project role.
     *
     * Create a request for the method "jobs.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the project that will be billed for the job
     * @param content the {@link com.google.api.services.bigquery.model.Job}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    /**
     * Starts a new asynchronous job. Requires the Can View project role.
     *
     * Create a request for the method "jobs.insert".
     *
     * This request holds the parameters needed by the the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param projectId Project ID of the project that will be billed for the job
     * @param content the {@link com.google.api.services.bigquery.model.Job} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(projectId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Job> {

      private static final String REST_PATH = "projects/{projectId}/jobs";

      /**
       * Starts a new asynchronous job. Requires the Can View project role.
       *
       * Create a request for the method "jobs.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the project that will be billed for the job
       * @param content the {@link com.google.api.services.bigquery.model.Job}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      /**
       * Starts a new asynchronous job. Requires the Can View project role.
       *
       * Create a request for the method "jobs.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param projectId Project ID of the project that will be billed for the job
       * @param content the {@link com.google.api.services.bigquery.model.Job} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Bigquery.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the project that will be billed for the job */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the project that will be billed for the job
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the project that will be billed for the job */
      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all jobs that you started in the specified project. Job information is available for a six
     * month period after creation. The job list is sorted in reverse chronological order, by job
     * creation time. Requires the Can View project role, or the Is Owner project role if you set the
     * allUsers property.
     *
     * Create a request for the method "jobs.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the jobs to list
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.JobList> {

      private static final String REST_PATH = "projects/{projectId}/jobs";

      /**
       * Lists all jobs that you started in the specified project. Job information is available for a
       * six month period after creation. The job list is sorted in reverse chronological order, by job
       * creation time. Requires the Can View project role, or the Is Owner project role if you set the
       * allUsers property.
       *
       * Create a request for the method "jobs.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the jobs to list
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.JobList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the jobs to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the jobs to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the jobs to list */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Whether to display jobs owned by all users in the project. Default false */
      @com.google.api.client.util.Key
      private java.lang.Boolean allUsers;

      /** Whether to display jobs owned by all users in the project. Default false
       */
      public java.lang.Boolean getAllUsers() {
        return allUsers;
      }

      /** Whether to display jobs owned by all users in the project. Default false */
      public List setAllUsers(java.lang.Boolean allUsers) {
        this.allUsers = allUsers;
        return this;
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Restrict information returned to a set of selected fields */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Restrict information returned to a set of selected fields
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Restrict information returned to a set of selected fields */
      public List setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** Filter for job state */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> stateFilter;

      /** Filter for job state
       */
      public java.util.List<java.lang.String> getStateFilter() {
        return stateFilter;
      }

      /** Filter for job state */
      public List setStateFilter(java.util.List<java.lang.String> stateFilter) {
        this.stateFilter = stateFilter;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Runs a BigQuery SQL query synchronously and returns query results if the query completes within a
     * specified timeout.
     *
     * Create a request for the method "jobs.query".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Query#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the project billed for the query
     * @param content the {@link com.google.api.services.bigquery.model.QueryRequest}
     * @return the request
     */
    public Query query(java.lang.String projectId, com.google.api.services.bigquery.model.QueryRequest content) throws java.io.IOException {
      Query result = new Query(projectId, content);
      initialize(result);
      return result;
    }

    public class Query extends BigqueryRequest<com.google.api.services.bigquery.model.QueryResponse> {

      private static final String REST_PATH = "projects/{projectId}/queries";

      /**
       * Runs a BigQuery SQL query synchronously and returns query results if the query completes within
       * a specified timeout.
       *
       * Create a request for the method "jobs.query".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       * <p> {@link
       * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the project billed for the query
       * @param content the {@link com.google.api.services.bigquery.model.QueryRequest}
       * @since 1.13
       */
      protected Query(java.lang.String projectId, com.google.api.services.bigquery.model.QueryRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.QueryResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Query setAlt(java.lang.String alt) {
        return (Query) super.setAlt(alt);
      }

      @Override
      public Query setFields(java.lang.String fields) {
        return (Query) super.setFields(fields);
      }

      @Override
      public Query setKey(java.lang.String key) {
        return (Query) super.setKey(key);
      }

      @Override
      public Query setOauthToken(java.lang.String oauthToken) {
        return (Query) super.setOauthToken(oauthToken);
      }

      @Override
      public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Query) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Query setQuotaUser(java.lang.String quotaUser) {
        return (Query) super.setQuotaUser(quotaUser);
      }

      @Override
      public Query setUserIp(java.lang.String userIp) {
        return (Query) super.setUserIp(userIp);
      }

      /** Project ID of the project billed for the query */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the project billed for the query
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the project billed for the query */
      public Query setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Query set(String parameterName, Object value) {
        return (Query) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Projects.List request = bigquery.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Lists all projects to which you have been granted any project role.
     *
     * Create a request for the method "projects.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ProjectList> {

      private static final String REST_PATH = "projects";

      /**
       * Lists all projects to which you have been granted any project role.
       *
       * Create a request for the method "projects.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ProjectList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tabledata collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Tabledata.List request = bigquery.tabledata().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tabledata tabledata() {
    return new Tabledata();
  }

  /**
   * The "tabledata" collection of methods.
   */
  public class Tabledata {

    /**
     * Streams data into BigQuery one record at a time without needing to run a load job. Requires the
     * WRITER dataset role.
     *
     * Create a request for the method "tabledata.insertAll".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link InsertAll#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the destination table.
     * @param datasetId Dataset ID of the destination table.
     * @param tableId Table ID of the destination table.
     * @param content the {@link com.google.api.services.bigquery.model.TableDataInsertAllRequest}
     * @return the request
     */
    public InsertAll insertAll(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.TableDataInsertAllRequest content) throws java.io.IOException {
      InsertAll result = new InsertAll(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class InsertAll extends BigqueryRequest<com.google.api.services.bigquery.model.TableDataInsertAllResponse> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/insertAll";

      /**
       * Streams data into BigQuery one record at a time without needing to run a load job. Requires the
       * WRITER dataset role.
       *
       * Create a request for the method "tabledata.insertAll".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link InsertAll#execute()} method to invoke the remote
       * operation. <p> {@link
       * InsertAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the destination table.
       * @param datasetId Dataset ID of the destination table.
       * @param tableId Table ID of the destination table.
       * @param content the {@link com.google.api.services.bigquery.model.TableDataInsertAllRequest}
       * @since 1.13
       */
      protected InsertAll(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.TableDataInsertAllRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TableDataInsertAllResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public InsertAll setAlt(java.lang.String alt) {
        return (InsertAll) super.setAlt(alt);
      }

      @Override
      public InsertAll setFields(java.lang.String fields) {
        return (InsertAll) super.setFields(fields);
      }

      @Override
      public InsertAll setKey(java.lang.String key) {
        return (InsertAll) super.setKey(key);
      }

      @Override
      public InsertAll setOauthToken(java.lang.String oauthToken) {
        return (InsertAll) super.setOauthToken(oauthToken);
      }

      @Override
      public InsertAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (InsertAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public InsertAll setQuotaUser(java.lang.String quotaUser) {
        return (InsertAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public InsertAll setUserIp(java.lang.String userIp) {
        return (InsertAll) super.setUserIp(userIp);
      }

      /** Project ID of the destination table. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the destination table.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the destination table. */
      public InsertAll setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the destination table. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the destination table.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the destination table. */
      public InsertAll setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the destination table. */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the destination table.
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the destination table. */
      public InsertAll setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public InsertAll set(String parameterName, Object value) {
        return (InsertAll) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves table data from a specified set of rows. Requires the READER dataset role.
     *
     * Create a request for the method "tabledata.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to read
     * @param datasetId Dataset ID of the table to read
     * @param tableId Table ID of the table to read
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      List result = new List(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.TableDataList> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/data";

      /**
       * Retrieves table data from a specified set of rows. Requires the READER dataset role.
       *
       * Create a request for the method "tabledata.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to read
       * @param datasetId Dataset ID of the table to read
       * @param tableId Table ID of the table to read
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.TableDataList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the table to read */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to read
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to read */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to read */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to read
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to read */
      public List setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to read */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to read
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to read */
      public List setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, identifying the result set */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, identifying the result set
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, identifying the result set */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      @com.google.api.client.util.Key
      private java.lang.String selectedFields;

      /** List of fields to return (comma-separated). If unspecified, all fields are returned
       */
      public java.lang.String getSelectedFields() {
        return selectedFields;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      public List setSelectedFields(java.lang.String selectedFields) {
        this.selectedFields = selectedFields;
        return this;
      }

      /** Zero-based index of the starting row to read */
      @com.google.api.client.util.Key
      private java.math.BigInteger startIndex;

      /** Zero-based index of the starting row to read
       */
      public java.math.BigInteger getStartIndex() {
        return startIndex;
      }

      /** Zero-based index of the starting row to read */
      public List setStartIndex(java.math.BigInteger startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tables collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Tables.List request = bigquery.tables().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tables tables() {
    return new Tables();
  }

  /**
   * The "tables" collection of methods.
   */
  public class Tables {

    /**
     * Deletes the table specified by tableId from the dataset. If the table contains data, all the data
     * will be deleted.
     *
     * Create a request for the method "tables.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to delete
     * @param datasetId Dataset ID of the table to delete
     * @param tableId Table ID of the table to delete
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Deletes the table specified by tableId from the dataset. If the table contains data, all the
       * data will be deleted.
       *
       * Create a request for the method "tables.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to delete
       * @param datasetId Dataset ID of the table to delete
       * @param tableId Table ID of the table to delete
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to delete
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to delete */
      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to delete
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to delete */
      public Delete setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to delete
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to delete */
      public Delete setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified table resource by table ID. This method does not return the data in the table,
     * it only returns the table resource, which describes the structure of this table.
     *
     * Create a request for the method "tables.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the requested table
     * @param datasetId Dataset ID of the requested table
     * @param tableId Table ID of the requested table
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Gets the specified table resource by table ID. This method does not return the data in the
       * table, it only returns the table resource, which describes the structure of this table.
       *
       * Create a request for the method "tables.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the requested table
       * @param datasetId Dataset ID of the requested table
       * @param tableId Table ID of the requested table
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the requested table
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the requested table */
      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the requested table
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the requested table */
      public Get setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the requested table
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the requested table */
      public Get setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      @com.google.api.client.util.Key
      private java.lang.String selectedFields;

      /** List of fields to return (comma-separated). If unspecified, all fields are returned
       */
      public java.lang.String getSelectedFields() {
        return selectedFields;
      }

      /** List of fields to return (comma-separated). If unspecified, all fields are returned */
      public Get setSelectedFields(java.lang.String selectedFields) {
        this.selectedFields = selectedFields;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new, empty table in the dataset.
     *
     * Create a request for the method "tables.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the new table
     * @param datasetId Dataset ID of the new table
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Insert result = new Insert(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";

      /**
       * Creates a new, empty table in the dataset.
       *
       * Create a request for the method "tables.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the new table
       * @param datasetId Dataset ID of the new table
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID of the new table */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the new table
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the new table */
      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the new table */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the new table
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the new table */
      public Insert setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all tables in the specified dataset. Requires the READER dataset role.
     *
     * Create a request for the method "tables.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the tables to list
     * @param datasetId Dataset ID of the tables to list
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.TableList> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";

      /**
       * Lists all tables in the specified dataset. Requires the READER dataset role.
       *
       * Create a request for the method "tables.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the tables to list
       * @param datasetId Dataset ID of the tables to list
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.TableList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID of the tables to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the tables to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the tables to list */
      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the tables to list */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the tables to list
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the tables to list */
      public List setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Maximum number of results to return */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to return
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to return */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing table. The update method replaces the entire table resource,
     * whereas the patch method only replaces fields that are provided in the submitted table resource.
     * This method supports patch semantics.
     *
     * Create a request for the method "tables.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to update
     * @param datasetId Dataset ID of the table to update
     * @param tableId Table ID of the table to update
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Updates information in an existing table. The update method replaces the entire table resource,
       * whereas the patch method only replaces fields that are provided in the submitted table
       * resource. This method supports patch semantics.
       *
       * Create a request for the method "tables.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to update
       * @param datasetId Dataset ID of the table to update
       * @param tableId Table ID of the table to update
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to update */
      public Patch setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to update */
      public Patch setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to update
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to update */
      public Patch setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing table. The update method replaces the entire table resource,
     * whereas the patch method only replaces fields that are provided in the submitted table resource.
     *
     * Create a request for the method "tables.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the table to update
     * @param datasetId Dataset ID of the table to update
     * @param tableId Table ID of the table to update
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";

      /**
       * Updates information in an existing table. The update method replaces the entire table resource,
       * whereas the patch method only replaces fields that are provided in the submitted table
       * resource.
       *
       * Create a request for the method "tables.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the table to update
       * @param datasetId Dataset ID of the table to update
       * @param tableId Table ID of the table to update
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the table to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the table to update */
      public Update setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /** Dataset ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Dataset ID of the table to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Dataset ID of the table to update */
      public Update setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /** Table ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Table ID of the table to update
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Table ID of the table to update */
      public Update setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Bigquery}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Bigquery}. */
    @Override
    public Bigquery build() {
      return new Bigquery(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link BigqueryRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setBigqueryRequestInitializer(
        BigqueryRequestInitializer bigqueryRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(bigqueryRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
