/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-19 at 01:33:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for Table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Table extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] The time when this table was created, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * [Optional] A user-friendly description of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output-only] A hash of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * [Optional] The time when this table expires, in milliseconds since the epoch. If not present,
   * the table will persist indefinitely. Expired tables will be deleted and their storage
   * reclaimed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationTime;

  /**
   * [Optional] Describes the data format, location, and other properties of a table stored outside
   * of BigQuery. By defining these properties, the data source can then be queried as if it were a
   * standard BigQuery table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalDataConfiguration externalDataConfiguration;

  /**
   * [Optional] A descriptive name for this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * [Output-only] An opaque ID uniquely identifying the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * [Output-only] The type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Experimental] The labels associated with this table. You can use these to organize and group
   * your tables. Label keys and values can be no longer than 63 characters, can only contain
   * lowercase letters, numeric characters, underscores and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter and each label in the
   * list must have a different key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * [Output-only] The time when this table was last modified, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger lastModifiedTime;

  /**
   * [Output-only] The geographic location where the table resides. This value is inherited from the
   * dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * [Output-only] The size of this table in bytes, excluding any data in the streaming buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numBytes;

  /**
   * [Output-only] The number of bytes in the table that are considered "long-term storage".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numLongTermBytes;

  /**
   * [Output-only] The number of rows of data in this table, excluding any data in the streaming
   * buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger numRows;

  /**
   * [Optional] Describes the schema of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableSchema schema;

  /**
   * [Output-only] A URL that can be used to access this resource again.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output-only] Contains information regarding this table's streaming buffer, if one is present.
   * This field will be absent if the table is not being streamed to or if there is no data in the
   * streaming buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Streamingbuffer streamingBuffer;

  /**
   * [Required] Reference describing the ID of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference tableReference;

  /**
   * [Experimental] If specified, configures time-based partitioning for this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimePartitioning timePartitioning;

  /**
   * [Output-only] Describes the table type. The following values are supported: TABLE: A normal
   * BigQuery table. VIEW: A virtual table defined by a SQL query. EXTERNAL: A table that references
   * data stored in an external storage system, such as Google Cloud Storage. The default value is
   * TABLE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Optional] The view definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ViewDefinition view;

  /**
   * [Output-only] The time when this table was created, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * [Output-only] The time when this table was created, in milliseconds since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public Table setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * [Optional] A user-friendly description of this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Optional] A user-friendly description of this table.
   * @param description description or {@code null} for none
   */
  public Table setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output-only] A hash of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * [Output-only] A hash of this resource.
   * @param etag etag or {@code null} for none
   */
  public Table setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * [Optional] The time when this table expires, in milliseconds since the epoch. If not present,
   * the table will persist indefinitely. Expired tables will be deleted and their storage
   * reclaimed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationTime() {
    return expirationTime;
  }

  /**
   * [Optional] The time when this table expires, in milliseconds since the epoch. If not present,
   * the table will persist indefinitely. Expired tables will be deleted and their storage
   * reclaimed.
   * @param expirationTime expirationTime or {@code null} for none
   */
  public Table setExpirationTime(java.lang.Long expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * [Optional] Describes the data format, location, and other properties of a table stored outside
   * of BigQuery. By defining these properties, the data source can then be queried as if it were a
   * standard BigQuery table.
   * @return value or {@code null} for none
   */
  public ExternalDataConfiguration getExternalDataConfiguration() {
    return externalDataConfiguration;
  }

  /**
   * [Optional] Describes the data format, location, and other properties of a table stored outside
   * of BigQuery. By defining these properties, the data source can then be queried as if it were a
   * standard BigQuery table.
   * @param externalDataConfiguration externalDataConfiguration or {@code null} for none
   */
  public Table setExternalDataConfiguration(ExternalDataConfiguration externalDataConfiguration) {
    this.externalDataConfiguration = externalDataConfiguration;
    return this;
  }

  /**
   * [Optional] A descriptive name for this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * [Optional] A descriptive name for this table.
   * @param friendlyName friendlyName or {@code null} for none
   */
  public Table setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * [Output-only] An opaque ID uniquely identifying the table.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output-only] An opaque ID uniquely identifying the table.
   * @param id id or {@code null} for none
   */
  public Table setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * [Output-only] The type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output-only] The type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Table setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Experimental] The labels associated with this table. You can use these to organize and group
   * your tables. Label keys and values can be no longer than 63 characters, can only contain
   * lowercase letters, numeric characters, underscores and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter and each label in the
   * list must have a different key.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * [Experimental] The labels associated with this table. You can use these to organize and group
   * your tables. Label keys and values can be no longer than 63 characters, can only contain
   * lowercase letters, numeric characters, underscores and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter and each label in the
   * list must have a different key.
   * @param labels labels or {@code null} for none
   */
  public Table setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * [Output-only] The time when this table was last modified, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * [Output-only] The time when this table was last modified, in milliseconds since the epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Table setLastModifiedTime(java.math.BigInteger lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * [Output-only] The geographic location where the table resides. This value is inherited from the
   * dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * [Output-only] The geographic location where the table resides. This value is inherited from the
   * dataset.
   * @param location location or {@code null} for none
   */
  public Table setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * [Output-only] The size of this table in bytes, excluding any data in the streaming buffer.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumBytes() {
    return numBytes;
  }

  /**
   * [Output-only] The size of this table in bytes, excluding any data in the streaming buffer.
   * @param numBytes numBytes or {@code null} for none
   */
  public Table setNumBytes(java.lang.Long numBytes) {
    this.numBytes = numBytes;
    return this;
  }

  /**
   * [Output-only] The number of bytes in the table that are considered "long-term storage".
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumLongTermBytes() {
    return numLongTermBytes;
  }

  /**
   * [Output-only] The number of bytes in the table that are considered "long-term storage".
   * @param numLongTermBytes numLongTermBytes or {@code null} for none
   */
  public Table setNumLongTermBytes(java.lang.Long numLongTermBytes) {
    this.numLongTermBytes = numLongTermBytes;
    return this;
  }

  /**
   * [Output-only] The number of rows of data in this table, excluding any data in the streaming
   * buffer.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getNumRows() {
    return numRows;
  }

  /**
   * [Output-only] The number of rows of data in this table, excluding any data in the streaming
   * buffer.
   * @param numRows numRows or {@code null} for none
   */
  public Table setNumRows(java.math.BigInteger numRows) {
    this.numRows = numRows;
    return this;
  }

  /**
   * [Optional] Describes the schema of this table.
   * @return value or {@code null} for none
   */
  public TableSchema getSchema() {
    return schema;
  }

  /**
   * [Optional] Describes the schema of this table.
   * @param schema schema or {@code null} for none
   */
  public Table setSchema(TableSchema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * [Output-only] A URL that can be used to access this resource again.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output-only] A URL that can be used to access this resource again.
   * @param selfLink selfLink or {@code null} for none
   */
  public Table setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output-only] Contains information regarding this table's streaming buffer, if one is present.
   * This field will be absent if the table is not being streamed to or if there is no data in the
   * streaming buffer.
   * @return value or {@code null} for none
   */
  public Streamingbuffer getStreamingBuffer() {
    return streamingBuffer;
  }

  /**
   * [Output-only] Contains information regarding this table's streaming buffer, if one is present.
   * This field will be absent if the table is not being streamed to or if there is no data in the
   * streaming buffer.
   * @param streamingBuffer streamingBuffer or {@code null} for none
   */
  public Table setStreamingBuffer(Streamingbuffer streamingBuffer) {
    this.streamingBuffer = streamingBuffer;
    return this;
  }

  /**
   * [Required] Reference describing the ID of this table.
   * @return value or {@code null} for none
   */
  public TableReference getTableReference() {
    return tableReference;
  }

  /**
   * [Required] Reference describing the ID of this table.
   * @param tableReference tableReference or {@code null} for none
   */
  public Table setTableReference(TableReference tableReference) {
    this.tableReference = tableReference;
    return this;
  }

  /**
   * [Experimental] If specified, configures time-based partitioning for this table.
   * @return value or {@code null} for none
   */
  public TimePartitioning getTimePartitioning() {
    return timePartitioning;
  }

  /**
   * [Experimental] If specified, configures time-based partitioning for this table.
   * @param timePartitioning timePartitioning or {@code null} for none
   */
  public Table setTimePartitioning(TimePartitioning timePartitioning) {
    this.timePartitioning = timePartitioning;
    return this;
  }

  /**
   * [Output-only] Describes the table type. The following values are supported: TABLE: A normal
   * BigQuery table. VIEW: A virtual table defined by a SQL query. EXTERNAL: A table that references
   * data stored in an external storage system, such as Google Cloud Storage. The default value is
   * TABLE.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * [Output-only] Describes the table type. The following values are supported: TABLE: A normal
   * BigQuery table. VIEW: A virtual table defined by a SQL query. EXTERNAL: A table that references
   * data stored in an external storage system, such as Google Cloud Storage. The default value is
   * TABLE.
   * @param type type or {@code null} for none
   */
  public Table setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * [Optional] The view definition.
   * @return value or {@code null} for none
   */
  public ViewDefinition getView() {
    return view;
  }

  /**
   * [Optional] The view definition.
   * @param view view or {@code null} for none
   */
  public Table setView(ViewDefinition view) {
    this.view = view;
    return this;
  }

  @Override
  public Table set(String fieldName, Object value) {
    return (Table) super.set(fieldName, value);
  }

  @Override
  public Table clone() {
    return (Table) super.clone();
  }

}
