/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-24 at 22:53:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableSchema.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableSchema extends com.google.api.client.json.GenericJson {

  /**
   * Describes the fields in a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableFieldSchema> fields;

  static {
    // hack to force ProGuard to consider TableFieldSchema used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TableFieldSchema.class);
  }

  /**
   * Describes the fields in a table.
   * @return value or {@code null} for none
   */
  public java.util.List<TableFieldSchema> getFields() {
    return fields;
  }

  /**
   * Describes the fields in a table.
   * @param fields fields or {@code null} for none
   */
  public TableSchema setFields(java.util.List<TableFieldSchema> fields) {
    this.fields = fields;
    return this;
  }

  @Override
  public TableSchema set(String fieldName, Object value) {
    return (TableSchema) super.set(fieldName, value);
  }

  @Override
  public TableSchema clone() {
    return (TableSchema) super.clone();
  }

}
