/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-30 at 10:05:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for JobReference.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobReference extends com.google.api.client.json.GenericJson {

  /**
   * [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), or dashes (-). The maximum length is 1,024 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobId;

  /**
   * [Required] The ID of the project containing this job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), or dashes (-). The maximum length is 1,024 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getJobId() {
    return jobId;
  }

  /**
   * [Required] The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), or dashes (-). The maximum length is 1,024 characters.
   * @param jobId jobId or {@code null} for none
   */
  public JobReference setJobId(java.lang.String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * [Required] The ID of the project containing this job.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * [Required] The ID of the project containing this job.
   * @param projectId projectId or {@code null} for none
   */
  public JobReference setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  @Override
  public JobReference set(String fieldName, Object value) {
    return (JobReference) super.set(fieldName, value);
  }

  @Override
  public JobReference clone() {
    return (JobReference) super.clone();
  }

}
