/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-18 at 17:53:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for BigtableOptions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigtableOptions extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] List of column families to expose in the table schema along with their types. This
   * list restricts the column families that can be referenced in queries and specifies their value
   * types. You can use this list to do type conversions - see the 'type' field for more details. If
   * you leave this list empty, all column families are present in the table schema and their values
   * are read as BYTES. During a query only the column families referenced in that query are read
   * from Bigtable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BigtableColumnFamily> columnFamilies;

  static {
    // hack to force ProGuard to consider BigtableColumnFamily used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BigtableColumnFamily.class);
  }

  /**
   * [Optional] If field is true, then the column families that are not specified in columnFamilies
   * list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The
   * default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreUnspecifiedColumnFamilies;

  /**
   * [Optional] If field is true, then the rowkey column families will be read and converted to
   * string. Otherwise they are read with BYTES type values and users need to manually cast them
   * with CAST if necessary. The default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean readRowkeyAsString;

  /**
   * [Optional] List of column families to expose in the table schema along with their types. This
   * list restricts the column families that can be referenced in queries and specifies their value
   * types. You can use this list to do type conversions - see the 'type' field for more details. If
   * you leave this list empty, all column families are present in the table schema and their values
   * are read as BYTES. During a query only the column families referenced in that query are read
   * from Bigtable.
   * @return value or {@code null} for none
   */
  public java.util.List<BigtableColumnFamily> getColumnFamilies() {
    return columnFamilies;
  }

  /**
   * [Optional] List of column families to expose in the table schema along with their types. This
   * list restricts the column families that can be referenced in queries and specifies their value
   * types. You can use this list to do type conversions - see the 'type' field for more details. If
   * you leave this list empty, all column families are present in the table schema and their values
   * are read as BYTES. During a query only the column families referenced in that query are read
   * from Bigtable.
   * @param columnFamilies columnFamilies or {@code null} for none
   */
  public BigtableOptions setColumnFamilies(java.util.List<BigtableColumnFamily> columnFamilies) {
    this.columnFamilies = columnFamilies;
    return this;
  }

  /**
   * [Optional] If field is true, then the column families that are not specified in columnFamilies
   * list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The
   * default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreUnspecifiedColumnFamilies() {
    return ignoreUnspecifiedColumnFamilies;
  }

  /**
   * [Optional] If field is true, then the column families that are not specified in columnFamilies
   * list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The
   * default value is false.
   * @param ignoreUnspecifiedColumnFamilies ignoreUnspecifiedColumnFamilies or {@code null} for none
   */
  public BigtableOptions setIgnoreUnspecifiedColumnFamilies(java.lang.Boolean ignoreUnspecifiedColumnFamilies) {
    this.ignoreUnspecifiedColumnFamilies = ignoreUnspecifiedColumnFamilies;
    return this;
  }

  /**
   * [Optional] If field is true, then the rowkey column families will be read and converted to
   * string. Otherwise they are read with BYTES type values and users need to manually cast them
   * with CAST if necessary. The default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getReadRowkeyAsString() {
    return readRowkeyAsString;
  }

  /**
   * [Optional] If field is true, then the rowkey column families will be read and converted to
   * string. Otherwise they are read with BYTES type values and users need to manually cast them
   * with CAST if necessary. The default value is false.
   * @param readRowkeyAsString readRowkeyAsString or {@code null} for none
   */
  public BigtableOptions setReadRowkeyAsString(java.lang.Boolean readRowkeyAsString) {
    this.readRowkeyAsString = readRowkeyAsString;
    return this;
  }

  @Override
  public BigtableOptions set(String fieldName, Object value) {
    return (BigtableOptions) super.set(fieldName, value);
  }

  @Override
  public BigtableOptions clone() {
    return (BigtableOptions) super.clone();
  }

}
