/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-07-19 at 01:37:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for JobConfiguration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * [Pick one] Copies a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobConfigurationTableCopy copy;

  /**
   * [Optional] If set, don't actually run this job. A valid query will return a mostly empty
   * response with some processing statistics, while an invalid query will return the same error it
   * would if it wasn't a dry run. Behavior of non-query jobs is undefined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dryRun;

  /**
   * [Pick one] Configures an extract job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobConfigurationExtract extract;

  /**
   * [Experimental] The labels associated with this job. You can use these to organize and group
   * your jobs. Label keys and values can be no longer than 63 characters, can only contain
   * lowercase letters, numeric characters, underscores and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter and each label in the
   * list must have a different key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * [Pick one] Configures a load job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobConfigurationLoad load;

  /**
   * [Pick one] Configures a query job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JobConfigurationQuery query;

  /**
   * [Pick one] Copies a table.
   * @return value or {@code null} for none
   */
  public JobConfigurationTableCopy getCopy() {
    return copy;
  }

  /**
   * [Pick one] Copies a table.
   * @param copy copy or {@code null} for none
   */
  public JobConfiguration setCopy(JobConfigurationTableCopy copy) {
    this.copy = copy;
    return this;
  }

  /**
   * [Optional] If set, don't actually run this job. A valid query will return a mostly empty
   * response with some processing statistics, while an invalid query will return the same error it
   * would if it wasn't a dry run. Behavior of non-query jobs is undefined.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDryRun() {
    return dryRun;
  }

  /**
   * [Optional] If set, don't actually run this job. A valid query will return a mostly empty
   * response with some processing statistics, while an invalid query will return the same error it
   * would if it wasn't a dry run. Behavior of non-query jobs is undefined.
   * @param dryRun dryRun or {@code null} for none
   */
  public JobConfiguration setDryRun(java.lang.Boolean dryRun) {
    this.dryRun = dryRun;
    return this;
  }

  /**
   * [Pick one] Configures an extract job.
   * @return value or {@code null} for none
   */
  public JobConfigurationExtract getExtract() {
    return extract;
  }

  /**
   * [Pick one] Configures an extract job.
   * @param extract extract or {@code null} for none
   */
  public JobConfiguration setExtract(JobConfigurationExtract extract) {
    this.extract = extract;
    return this;
  }

  /**
   * [Experimental] The labels associated with this job. You can use these to organize and group
   * your jobs. Label keys and values can be no longer than 63 characters, can only contain
   * lowercase letters, numeric characters, underscores and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter and each label in the
   * list must have a different key.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * [Experimental] The labels associated with this job. You can use these to organize and group
   * your jobs. Label keys and values can be no longer than 63 characters, can only contain
   * lowercase letters, numeric characters, underscores and dashes. International characters are
   * allowed. Label values are optional. Label keys must start with a letter and each label in the
   * list must have a different key.
   * @param labels labels or {@code null} for none
   */
  public JobConfiguration setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * [Pick one] Configures a load job.
   * @return value or {@code null} for none
   */
  public JobConfigurationLoad getLoad() {
    return load;
  }

  /**
   * [Pick one] Configures a load job.
   * @param load load or {@code null} for none
   */
  public JobConfiguration setLoad(JobConfigurationLoad load) {
    this.load = load;
    return this;
  }

  /**
   * [Pick one] Configures a query job.
   * @return value or {@code null} for none
   */
  public JobConfigurationQuery getQuery() {
    return query;
  }

  /**
   * [Pick one] Configures a query job.
   * @param query query or {@code null} for none
   */
  public JobConfiguration setQuery(JobConfigurationQuery query) {
    this.query = query;
    return this;
  }

  @Override
  public JobConfiguration set(String fieldName, Object value) {
    return (JobConfiguration) super.set(fieldName, value);
  }

  @Override
  public JobConfiguration clone() {
    return (JobConfiguration) super.clone();
  }

}
