/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-08-11 at 05:16:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for QueryRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryRequest extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] Specifies the default datasetId and projectId to assume for any unqualified table
   * names in the query. If not set, all table names in the query string must be qualified in the
   * format 'datasetId.tableId'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatasetReference defaultDataset;

  /**
   * [Optional] If set to true, BigQuery doesn't run the job. Instead, if the query is valid,
   * BigQuery returns statistics about the job such as how many bytes would be processed. If the
   * query is invalid, an error returns. The default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dryRun;

  /**
   * The resource type of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Optional] The maximum number of rows of data to return per page of results. Setting this flag
   * to a small value such as 1000 and then paging through results might improve reliability when
   * the query result set is large. In addition to this limit, responses are also limited to 10 MB.
   * By default, there is no maximum row count, and only the byte limit applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long maxResults;

  /**
   * Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use
   * named (@myparam) query parameters in this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parameterMode;

  /**
   * [Deprecated] This property is deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean preserveNulls;

  /**
   * [Required] A query string, following the BigQuery query syntax, of the query to execute.
   * Example: "SELECT count(f1) FROM [myProjectId:myDatasetId.myTableId]".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * Query parameters for Standard SQL queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<QueryParameter> queryParameters;

  static {
    // hack to force ProGuard to consider QueryParameter used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(QueryParameter.class);
  }

  /**
   * [Optional] How long to wait for the query to complete, in milliseconds, before the request
   * times out and returns. Note that this is only a timeout for the request, not the query. If the
   * query takes longer to run than the timeout value, the call returns without any results and with
   * the 'jobComplete' flag set to false. You can call GetQueryResults() to wait for the query to
   * complete and read the results. The default value is 10000 milliseconds (10 seconds).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long timeoutMs;

  /**
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is
   * true. If set to false, the query will use BigQuery's standard SQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value
   * of flattenResults is ignored; query will be run as if flattenResults is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useLegacySql;

  /**
   * [Optional] Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. The default value is
   * true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useQueryCache;

  /**
   * [Optional] Specifies the default datasetId and projectId to assume for any unqualified table
   * names in the query. If not set, all table names in the query string must be qualified in the
   * format 'datasetId.tableId'.
   * @return value or {@code null} for none
   */
  public DatasetReference getDefaultDataset() {
    return defaultDataset;
  }

  /**
   * [Optional] Specifies the default datasetId and projectId to assume for any unqualified table
   * names in the query. If not set, all table names in the query string must be qualified in the
   * format 'datasetId.tableId'.
   * @param defaultDataset defaultDataset or {@code null} for none
   */
  public QueryRequest setDefaultDataset(DatasetReference defaultDataset) {
    this.defaultDataset = defaultDataset;
    return this;
  }

  /**
   * [Optional] If set to true, BigQuery doesn't run the job. Instead, if the query is valid,
   * BigQuery returns statistics about the job such as how many bytes would be processed. If the
   * query is invalid, an error returns. The default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDryRun() {
    return dryRun;
  }

  /**
   * [Optional] If set to true, BigQuery doesn't run the job. Instead, if the query is valid,
   * BigQuery returns statistics about the job such as how many bytes would be processed. If the
   * query is invalid, an error returns. The default value is false.
   * @param dryRun dryRun or {@code null} for none
   */
  public QueryRequest setDryRun(java.lang.Boolean dryRun) {
    this.dryRun = dryRun;
    return this;
  }

  /**
   * The resource type of the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The resource type of the request.
   * @param kind kind or {@code null} for none
   */
  public QueryRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Optional] The maximum number of rows of data to return per page of results. Setting this flag
   * to a small value such as 1000 and then paging through results might improve reliability when
   * the query result set is large. In addition to this limit, responses are also limited to 10 MB.
   * By default, there is no maximum row count, and only the byte limit applies.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxResults() {
    return maxResults;
  }

  /**
   * [Optional] The maximum number of rows of data to return per page of results. Setting this flag
   * to a small value such as 1000 and then paging through results might improve reliability when
   * the query result set is large. In addition to this limit, responses are also limited to 10 MB.
   * By default, there is no maximum row count, and only the byte limit applies.
   * @param maxResults maxResults or {@code null} for none
   */
  public QueryRequest setMaxResults(java.lang.Long maxResults) {
    this.maxResults = maxResults;
    return this;
  }

  /**
   * Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use
   * named (@myparam) query parameters in this query.
   * @return value or {@code null} for none
   */
  public java.lang.String getParameterMode() {
    return parameterMode;
  }

  /**
   * Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use
   * named (@myparam) query parameters in this query.
   * @param parameterMode parameterMode or {@code null} for none
   */
  public QueryRequest setParameterMode(java.lang.String parameterMode) {
    this.parameterMode = parameterMode;
    return this;
  }

  /**
   * [Deprecated] This property is deprecated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPreserveNulls() {
    return preserveNulls;
  }

  /**
   * [Deprecated] This property is deprecated.
   * @param preserveNulls preserveNulls or {@code null} for none
   */
  public QueryRequest setPreserveNulls(java.lang.Boolean preserveNulls) {
    this.preserveNulls = preserveNulls;
    return this;
  }

  /**
   * [Required] A query string, following the BigQuery query syntax, of the query to execute.
   * Example: "SELECT count(f1) FROM [myProjectId:myDatasetId.myTableId]".
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * [Required] A query string, following the BigQuery query syntax, of the query to execute.
   * Example: "SELECT count(f1) FROM [myProjectId:myDatasetId.myTableId]".
   * @param query query or {@code null} for none
   */
  public QueryRequest setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * Query parameters for Standard SQL queries.
   * @return value or {@code null} for none
   */
  public java.util.List<QueryParameter> getQueryParameters() {
    return queryParameters;
  }

  /**
   * Query parameters for Standard SQL queries.
   * @param queryParameters queryParameters or {@code null} for none
   */
  public QueryRequest setQueryParameters(java.util.List<QueryParameter> queryParameters) {
    this.queryParameters = queryParameters;
    return this;
  }

  /**
   * [Optional] How long to wait for the query to complete, in milliseconds, before the request
   * times out and returns. Note that this is only a timeout for the request, not the query. If the
   * query takes longer to run than the timeout value, the call returns without any results and with
   * the 'jobComplete' flag set to false. You can call GetQueryResults() to wait for the query to
   * complete and read the results. The default value is 10000 milliseconds (10 seconds).
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimeoutMs() {
    return timeoutMs;
  }

  /**
   * [Optional] How long to wait for the query to complete, in milliseconds, before the request
   * times out and returns. Note that this is only a timeout for the request, not the query. If the
   * query takes longer to run than the timeout value, the call returns without any results and with
   * the 'jobComplete' flag set to false. You can call GetQueryResults() to wait for the query to
   * complete and read the results. The default value is 10000 milliseconds (10 seconds).
   * @param timeoutMs timeoutMs or {@code null} for none
   */
  public QueryRequest setTimeoutMs(java.lang.Long timeoutMs) {
    this.timeoutMs = timeoutMs;
    return this;
  }

  /**
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is
   * true. If set to false, the query will use BigQuery's standard SQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value
   * of flattenResults is ignored; query will be run as if flattenResults is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseLegacySql() {
    return useLegacySql;
  }

  /**
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is
   * true. If set to false, the query will use BigQuery's standard SQL:
   * https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to false, the value
   * of flattenResults is ignored; query will be run as if flattenResults is false.
   * @param useLegacySql useLegacySql or {@code null} for none
   */
  public QueryRequest setUseLegacySql(java.lang.Boolean useLegacySql) {
    this.useLegacySql = useLegacySql;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
 If set to false, the query will use BigQuery's standard SQL: https://cloud.google.com/bigquery/sql-
 reference/ When useLegacySql is set to false, the value of flattenResults is ignored; query will be
 run as if flattenResults is false.
   * </p>
   */
  public boolean isUseLegacySql() {
    if (useLegacySql == null || useLegacySql == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return useLegacySql;
  }

  /**
   * [Optional] Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. The default value is
   * true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseQueryCache() {
    return useQueryCache;
  }

  /**
   * [Optional] Whether to look for the result in the query cache. The query cache is a best-effort
   * cache that will be flushed whenever tables in the query are modified. The default value is
   * true.
   * @param useQueryCache useQueryCache or {@code null} for none
   */
  public QueryRequest setUseQueryCache(java.lang.Boolean useQueryCache) {
    this.useQueryCache = useQueryCache;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   *[ Optional] Whether to look for the result in the query cache. The query cache is a best-effort
[ cache that will be flushed whenever tables in the query are modified. The default value is true.
   * </p>
   */
  public boolean isUseQueryCache() {
    if (useQueryCache == null || useQueryCache == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return useQueryCache;
  }

  @Override
  public QueryRequest set(String fieldName, Object value) {
    return (QueryRequest) super.set(fieldName, value);
  }

  @Override
  public QueryRequest clone() {
    return (QueryRequest) super.clone();
  }

}
