/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-06 at 08:03:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for QueryParameterType.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryParameterType extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] The type of the array's elements, if this is an array.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QueryParameterType arrayType;

  /**
   * [Optional] The types of the fields of this struct, in order, if this is a struct.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StructTypes> structTypes;

  static {
    // hack to force ProGuard to consider StructTypes used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StructTypes.class);
  }

  /**
   * [Required] The top level type of this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Optional] The type of the array's elements, if this is an array.
   * @return value or {@code null} for none
   */
  public QueryParameterType getArrayType() {
    return arrayType;
  }

  /**
   * [Optional] The type of the array's elements, if this is an array.
   * @param arrayType arrayType or {@code null} for none
   */
  public QueryParameterType setArrayType(QueryParameterType arrayType) {
    this.arrayType = arrayType;
    return this;
  }

  /**
   * [Optional] The types of the fields of this struct, in order, if this is a struct.
   * @return value or {@code null} for none
   */
  public java.util.List<StructTypes> getStructTypes() {
    return structTypes;
  }

  /**
   * [Optional] The types of the fields of this struct, in order, if this is a struct.
   * @param structTypes structTypes or {@code null} for none
   */
  public QueryParameterType setStructTypes(java.util.List<StructTypes> structTypes) {
    this.structTypes = structTypes;
    return this;
  }

  /**
   * [Required] The top level type of this field.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * [Required] The top level type of this field.
   * @param type type or {@code null} for none
   */
  public QueryParameterType setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public QueryParameterType set(String fieldName, Object value) {
    return (QueryParameterType) super.set(fieldName, value);
  }

  @Override
  public QueryParameterType clone() {
    return (QueryParameterType) super.clone();
  }

  /**
   * Model definition for QueryParameterTypeStructTypes.
   */
  public static final class StructTypes extends com.google.api.client.json.GenericJson {

    /**
     * [Optional] Human-oriented description of the field.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String description;

    /**
     * [Optional] The name of this field.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * [Required] The type of this field.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private QueryParameterType type;

    /**
     * [Optional] Human-oriented description of the field.
     * @return value or {@code null} for none
     */
    public java.lang.String getDescription() {
      return description;
    }

    /**
     * [Optional] Human-oriented description of the field.
     * @param description description or {@code null} for none
     */
    public StructTypes setDescription(java.lang.String description) {
      this.description = description;
      return this;
    }

    /**
     * [Optional] The name of this field.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * [Optional] The name of this field.
     * @param name name or {@code null} for none
     */
    public StructTypes setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    /**
     * [Required] The type of this field.
     * @return value or {@code null} for none
     */
    public QueryParameterType getType() {
      return type;
    }

    /**
     * [Required] The type of this field.
     * @param type type or {@code null} for none
     */
    public StructTypes setType(QueryParameterType type) {
      this.type = type;
      return this;
    }

    @Override
    public StructTypes set(String fieldName, Object value) {
      return (StructTypes) super.set(fieldName, value);
    }

    @Override
    public StructTypes clone() {
      return (StructTypes) super.clone();
    }

  }

}
