/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-27 at 07:18:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for ExternalDataConfiguration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalDataConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * Try to detect schema and format options automatically. Any option specified explicitly will be
   * honored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autodetect;

  /**
   * [Optional] Additional options if sourceFormat is set to BIGTABLE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BigtableOptions bigtableOptions;

  /**
   * [Optional] The compression type of the data source. Possible values include GZIP and NONE. The
   * default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud
   * Datastore backups and Avro formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String compression;

  /**
   * Additional properties to set if sourceFormat is set to CSV.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CsvOptions csvOptions;

  /**
   * [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleSheetsOptions googleSheetsOptions;

  /**
   * [Optional] Indicates if BigQuery should allow extra values that are not represented in the
   * table schema. If true, the extra values are ignored. If false, records with extra columns are
   * treated as bad records, and if there are too many bad records, an invalid error is returned in
   * the job result. The default value is false. The sourceFormat property determines what BigQuery
   * treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column
   * names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This
   * setting is ignored. Avro: This setting is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreUnknownValues;

  /**
   * [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the
   * number of bad records exceeds this value, an invalid error is returned in the job result. The
   * default value is 0, which requires that all records are valid. This setting is ignored for
   * Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxBadRecords;

  /**
   * [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is
   * disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableSchema schema;

  /**
   * [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify
   * "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files,
   * specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For
   * Google Cloud Bigtable, specify "BIGTABLE".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceFormat;

  /**
   * [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud
   * Storage URIs: Each URI can contain one '*' wildcard character and it must come after the
   * 'bucket' name. Size limits related to load jobs apply to external data sources. For Google
   * Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid
   * HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one
   * URI can be specified. Also, the '*' wildcard character is not allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sourceUris;

  /**
   * Try to detect schema and format options automatically. Any option specified explicitly will be
   * honored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutodetect() {
    return autodetect;
  }

  /**
   * Try to detect schema and format options automatically. Any option specified explicitly will be
   * honored.
   * @param autodetect autodetect or {@code null} for none
   */
  public ExternalDataConfiguration setAutodetect(java.lang.Boolean autodetect) {
    this.autodetect = autodetect;
    return this;
  }

  /**
   * [Optional] Additional options if sourceFormat is set to BIGTABLE.
   * @return value or {@code null} for none
   */
  public BigtableOptions getBigtableOptions() {
    return bigtableOptions;
  }

  /**
   * [Optional] Additional options if sourceFormat is set to BIGTABLE.
   * @param bigtableOptions bigtableOptions or {@code null} for none
   */
  public ExternalDataConfiguration setBigtableOptions(BigtableOptions bigtableOptions) {
    this.bigtableOptions = bigtableOptions;
    return this;
  }

  /**
   * [Optional] The compression type of the data source. Possible values include GZIP and NONE. The
   * default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud
   * Datastore backups and Avro formats.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompression() {
    return compression;
  }

  /**
   * [Optional] The compression type of the data source. Possible values include GZIP and NONE. The
   * default value is NONE. This setting is ignored for Google Cloud Bigtable, Google Cloud
   * Datastore backups and Avro formats.
   * @param compression compression or {@code null} for none
   */
  public ExternalDataConfiguration setCompression(java.lang.String compression) {
    this.compression = compression;
    return this;
  }

  /**
   * Additional properties to set if sourceFormat is set to CSV.
   * @return value or {@code null} for none
   */
  public CsvOptions getCsvOptions() {
    return csvOptions;
  }

  /**
   * Additional properties to set if sourceFormat is set to CSV.
   * @param csvOptions csvOptions or {@code null} for none
   */
  public ExternalDataConfiguration setCsvOptions(CsvOptions csvOptions) {
    this.csvOptions = csvOptions;
    return this;
  }

  /**
   * [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
   * @return value or {@code null} for none
   */
  public GoogleSheetsOptions getGoogleSheetsOptions() {
    return googleSheetsOptions;
  }

  /**
   * [Optional] Additional options if sourceFormat is set to GOOGLE_SHEETS.
   * @param googleSheetsOptions googleSheetsOptions or {@code null} for none
   */
  public ExternalDataConfiguration setGoogleSheetsOptions(GoogleSheetsOptions googleSheetsOptions) {
    this.googleSheetsOptions = googleSheetsOptions;
    return this;
  }

  /**
   * [Optional] Indicates if BigQuery should allow extra values that are not represented in the
   * table schema. If true, the extra values are ignored. If false, records with extra columns are
   * treated as bad records, and if there are too many bad records, an invalid error is returned in
   * the job result. The default value is false. The sourceFormat property determines what BigQuery
   * treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column
   * names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This
   * setting is ignored. Avro: This setting is ignored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreUnknownValues() {
    return ignoreUnknownValues;
  }

  /**
   * [Optional] Indicates if BigQuery should allow extra values that are not represented in the
   * table schema. If true, the extra values are ignored. If false, records with extra columns are
   * treated as bad records, and if there are too many bad records, an invalid error is returned in
   * the job result. The default value is false. The sourceFormat property determines what BigQuery
   * treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column
   * names Google Cloud Bigtable: This setting is ignored. Google Cloud Datastore backups: This
   * setting is ignored. Avro: This setting is ignored.
   * @param ignoreUnknownValues ignoreUnknownValues or {@code null} for none
   */
  public ExternalDataConfiguration setIgnoreUnknownValues(java.lang.Boolean ignoreUnknownValues) {
    this.ignoreUnknownValues = ignoreUnknownValues;
    return this;
  }

  /**
   * [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the
   * number of bad records exceeds this value, an invalid error is returned in the job result. The
   * default value is 0, which requires that all records are valid. This setting is ignored for
   * Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxBadRecords() {
    return maxBadRecords;
  }

  /**
   * [Optional] The maximum number of bad records that BigQuery can ignore when reading data. If the
   * number of bad records exceeds this value, an invalid error is returned in the job result. The
   * default value is 0, which requires that all records are valid. This setting is ignored for
   * Google Cloud Bigtable, Google Cloud Datastore backups and Avro formats.
   * @param maxBadRecords maxBadRecords or {@code null} for none
   */
  public ExternalDataConfiguration setMaxBadRecords(java.lang.Integer maxBadRecords) {
    this.maxBadRecords = maxBadRecords;
    return this;
  }

  /**
   * [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is
   * disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
   * @return value or {@code null} for none
   */
  public TableSchema getSchema() {
    return schema;
  }

  /**
   * [Optional] The schema for the data. Schema is required for CSV and JSON formats. Schema is
   * disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats.
   * @param schema schema or {@code null} for none
   */
  public ExternalDataConfiguration setSchema(TableSchema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify
   * "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files,
   * specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For
   * Google Cloud Bigtable, specify "BIGTABLE".
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceFormat() {
    return sourceFormat;
  }

  /**
   * [Required] The data format. For CSV files, specify "CSV". For Google sheets, specify
   * "GOOGLE_SHEETS". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro files,
   * specify "AVRO". For Google Cloud Datastore backups, specify "DATASTORE_BACKUP". [Beta] For
   * Google Cloud Bigtable, specify "BIGTABLE".
   * @param sourceFormat sourceFormat or {@code null} for none
   */
  public ExternalDataConfiguration setSourceFormat(java.lang.String sourceFormat) {
    this.sourceFormat = sourceFormat;
    return this;
  }

  /**
   * [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud
   * Storage URIs: Each URI can contain one '*' wildcard character and it must come after the
   * 'bucket' name. Size limits related to load jobs apply to external data sources. For Google
   * Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid
   * HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one
   * URI can be specified. Also, the '*' wildcard character is not allowed.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSourceUris() {
    return sourceUris;
  }

  /**
   * [Required] The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud
   * Storage URIs: Each URI can contain one '*' wildcard character and it must come after the
   * 'bucket' name. Size limits related to load jobs apply to external data sources. For Google
   * Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid
   * HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups, exactly one
   * URI can be specified. Also, the '*' wildcard character is not allowed.
   * @param sourceUris sourceUris or {@code null} for none
   */
  public ExternalDataConfiguration setSourceUris(java.util.List<java.lang.String> sourceUris) {
    this.sourceUris = sourceUris;
    return this;
  }

  @Override
  public ExternalDataConfiguration set(String fieldName, Object value) {
    return (ExternalDataConfiguration) super.set(fieldName, value);
  }

  @Override
  public ExternalDataConfiguration clone() {
    return (ExternalDataConfiguration) super.clone();
  }

}
