/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-12 at 07:41:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for QueryTimelineSample.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryTimelineSample extends com.google.api.client.json.GenericJson {

  /**
   * Total number of active workers. This does not correspond directly to slot usage. This is the
   * largest value observed since the last sample.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer activeInputs;

  /**
   * Total parallel units of work completed by this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer completedInputs;

  /**
   * Total parallel units of work completed by the currently active stages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer completedInputsForActiveStages;

  /**
   * Milliseconds elapsed since the start of query execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long elapsedMs;

  /**
   * Total parallel units of work remaining for the active stages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long pendingInputs;

  /**
   * Cumulative slot-ms consumed by the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalSlotMs;

  /**
   * Total number of active workers. This does not correspond directly to slot usage. This is the
   * largest value observed since the last sample.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getActiveInputs() {
    return activeInputs;
  }

  /**
   * Total number of active workers. This does not correspond directly to slot usage. This is the
   * largest value observed since the last sample.
   * @param activeInputs activeInputs or {@code null} for none
   */
  public QueryTimelineSample setActiveInputs(java.lang.Integer activeInputs) {
    this.activeInputs = activeInputs;
    return this;
  }

  /**
   * Total parallel units of work completed by this query.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCompletedInputs() {
    return completedInputs;
  }

  /**
   * Total parallel units of work completed by this query.
   * @param completedInputs completedInputs or {@code null} for none
   */
  public QueryTimelineSample setCompletedInputs(java.lang.Integer completedInputs) {
    this.completedInputs = completedInputs;
    return this;
  }

  /**
   * Total parallel units of work completed by the currently active stages.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCompletedInputsForActiveStages() {
    return completedInputsForActiveStages;
  }

  /**
   * Total parallel units of work completed by the currently active stages.
   * @param completedInputsForActiveStages completedInputsForActiveStages or {@code null} for none
   */
  public QueryTimelineSample setCompletedInputsForActiveStages(java.lang.Integer completedInputsForActiveStages) {
    this.completedInputsForActiveStages = completedInputsForActiveStages;
    return this;
  }

  /**
   * Milliseconds elapsed since the start of query execution.
   * @return value or {@code null} for none
   */
  public java.lang.Long getElapsedMs() {
    return elapsedMs;
  }

  /**
   * Milliseconds elapsed since the start of query execution.
   * @param elapsedMs elapsedMs or {@code null} for none
   */
  public QueryTimelineSample setElapsedMs(java.lang.Long elapsedMs) {
    this.elapsedMs = elapsedMs;
    return this;
  }

  /**
   * Total parallel units of work remaining for the active stages.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPendingInputs() {
    return pendingInputs;
  }

  /**
   * Total parallel units of work remaining for the active stages.
   * @param pendingInputs pendingInputs or {@code null} for none
   */
  public QueryTimelineSample setPendingInputs(java.lang.Long pendingInputs) {
    this.pendingInputs = pendingInputs;
    return this;
  }

  /**
   * Cumulative slot-ms consumed by the query.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalSlotMs() {
    return totalSlotMs;
  }

  /**
   * Cumulative slot-ms consumed by the query.
   * @param totalSlotMs totalSlotMs or {@code null} for none
   */
  public QueryTimelineSample setTotalSlotMs(java.lang.Long totalSlotMs) {
    this.totalSlotMs = totalSlotMs;
    return this;
  }

  @Override
  public QueryTimelineSample set(String fieldName, Object value) {
    return (QueryTimelineSample) super.set(fieldName, value);
  }

  @Override
  public QueryTimelineSample clone() {
    return (QueryTimelineSample) super.clone();
  }

}
