/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-13 at 06:29:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for EncryptionConfiguration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EncryptionConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] Describes the Cloud KMS encryption key that will be used to protect destination
   * BigQuery table. The BigQuery Service Account associated with your project requires access to
   * this encryption key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmsKeyName;

  /**
   * [Optional] Describes the Cloud KMS encryption key that will be used to protect destination
   * BigQuery table. The BigQuery Service Account associated with your project requires access to
   * this encryption key.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmsKeyName() {
    return kmsKeyName;
  }

  /**
   * [Optional] Describes the Cloud KMS encryption key that will be used to protect destination
   * BigQuery table. The BigQuery Service Account associated with your project requires access to
   * this encryption key.
   * @param kmsKeyName kmsKeyName or {@code null} for none
   */
  public EncryptionConfiguration setKmsKeyName(java.lang.String kmsKeyName) {
    this.kmsKeyName = kmsKeyName;
    return this;
  }

  @Override
  public EncryptionConfiguration set(String fieldName, Object value) {
    return (EncryptionConfiguration) super.set(fieldName, value);
  }

  @Override
  public EncryptionConfiguration clone() {
    return (EncryptionConfiguration) super.clone();
  }

}
