/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-04-06 17:52:19 UTC)
 * on 2018-05-01 at 17:39:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableList extends com.google.api.client.json.GenericJson {

  /**
   * A hash of this page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The type of list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A token to request the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Tables in the requested dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Tables> tables;

  static {
    // hack to force ProGuard to consider Tables used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Tables.class);
  }

  /**
   * The total number of tables in the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalItems;

  /**
   * A hash of this page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * A hash of this page of results.
   * @param etag etag or {@code null} for none
   */
  public TableList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The type of list.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The type of list.
   * @param kind kind or {@code null} for none
   */
  public TableList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token to request the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token to request the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public TableList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Tables in the requested dataset.
   * @return value or {@code null} for none
   */
  public java.util.List<Tables> getTables() {
    return tables;
  }

  /**
   * Tables in the requested dataset.
   * @param tables tables or {@code null} for none
   */
  public TableList setTables(java.util.List<Tables> tables) {
    this.tables = tables;
    return this;
  }

  /**
   * The total number of tables in the dataset.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalItems() {
    return totalItems;
  }

  /**
   * The total number of tables in the dataset.
   * @param totalItems totalItems or {@code null} for none
   */
  public TableList setTotalItems(java.lang.Integer totalItems) {
    this.totalItems = totalItems;
    return this;
  }

  @Override
  public TableList set(String fieldName, Object value) {
    return (TableList) super.set(fieldName, value);
  }

  @Override
  public TableList clone() {
    return (TableList) super.clone();
  }

  /**
   * Model definition for TableListTables.
   */
  public static final class Tables extends com.google.api.client.json.GenericJson {

    /**
     * [Experimental] Clustering specification for this table, if configured.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Clustering clustering;

    /**
     * The time when this table was created, in milliseconds since the epoch.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long creationTime;

    /**
     * [Optional] The time when this table expires, in milliseconds since the epoch. If not present,
     * the table will persist indefinitely. Expired tables will be deleted and their storage
     * reclaimed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long expirationTime;

    /**
     * The user-friendly name for this table.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String friendlyName;

    /**
     * An opaque ID of the table
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The resource type.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String kind;

    /**
     * The labels associated with this table. You can use these to organize and group your tables.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, java.lang.String> labels;

    /**
     * A reference uniquely identifying the table.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private TableReference tableReference;

    /**
     * The time-based partitioning specification for this table, if configured.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private TimePartitioning timePartitioning;

    /**
     * The type of table. Possible values are: TABLE, VIEW.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Additional details for a view.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private View view;

    /**
     * [Experimental] Clustering specification for this table, if configured.
     * @return value or {@code null} for none
     */
    public Clustering getClustering() {
      return clustering;
    }

    /**
     * [Experimental] Clustering specification for this table, if configured.
     * @param clustering clustering or {@code null} for none
     */
    public Tables setClustering(Clustering clustering) {
      this.clustering = clustering;
      return this;
    }

    /**
     * The time when this table was created, in milliseconds since the epoch.
     * @return value or {@code null} for none
     */
    public java.lang.Long getCreationTime() {
      return creationTime;
    }

    /**
     * The time when this table was created, in milliseconds since the epoch.
     * @param creationTime creationTime or {@code null} for none
     */
    public Tables setCreationTime(java.lang.Long creationTime) {
      this.creationTime = creationTime;
      return this;
    }

    /**
     * [Optional] The time when this table expires, in milliseconds since the epoch. If not present,
     * the table will persist indefinitely. Expired tables will be deleted and their storage
     * reclaimed.
     * @return value or {@code null} for none
     */
    public java.lang.Long getExpirationTime() {
      return expirationTime;
    }

    /**
     * [Optional] The time when this table expires, in milliseconds since the epoch. If not present,
     * the table will persist indefinitely. Expired tables will be deleted and their storage
     * reclaimed.
     * @param expirationTime expirationTime or {@code null} for none
     */
    public Tables setExpirationTime(java.lang.Long expirationTime) {
      this.expirationTime = expirationTime;
      return this;
    }

    /**
     * The user-friendly name for this table.
     * @return value or {@code null} for none
     */
    public java.lang.String getFriendlyName() {
      return friendlyName;
    }

    /**
     * The user-friendly name for this table.
     * @param friendlyName friendlyName or {@code null} for none
     */
    public Tables setFriendlyName(java.lang.String friendlyName) {
      this.friendlyName = friendlyName;
      return this;
    }

    /**
     * An opaque ID of the table
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * An opaque ID of the table
     * @param id id or {@code null} for none
     */
    public Tables setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * The resource type.
     * @return value or {@code null} for none
     */
    public java.lang.String getKind() {
      return kind;
    }

    /**
     * The resource type.
     * @param kind kind or {@code null} for none
     */
    public Tables setKind(java.lang.String kind) {
      this.kind = kind;
      return this;
    }

    /**
     * The labels associated with this table. You can use these to organize and group your tables.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.String> getLabels() {
      return labels;
    }

    /**
     * The labels associated with this table. You can use these to organize and group your tables.
     * @param labels labels or {@code null} for none
     */
    public Tables setLabels(java.util.Map<String, java.lang.String> labels) {
      this.labels = labels;
      return this;
    }

    /**
     * A reference uniquely identifying the table.
     * @return value or {@code null} for none
     */
    public TableReference getTableReference() {
      return tableReference;
    }

    /**
     * A reference uniquely identifying the table.
     * @param tableReference tableReference or {@code null} for none
     */
    public Tables setTableReference(TableReference tableReference) {
      this.tableReference = tableReference;
      return this;
    }

    /**
     * The time-based partitioning specification for this table, if configured.
     * @return value or {@code null} for none
     */
    public TimePartitioning getTimePartitioning() {
      return timePartitioning;
    }

    /**
     * The time-based partitioning specification for this table, if configured.
     * @param timePartitioning timePartitioning or {@code null} for none
     */
    public Tables setTimePartitioning(TimePartitioning timePartitioning) {
      this.timePartitioning = timePartitioning;
      return this;
    }

    /**
     * The type of table. Possible values are: TABLE, VIEW.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The type of table. Possible values are: TABLE, VIEW.
     * @param type type or {@code null} for none
     */
    public Tables setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    /**
     * Additional details for a view.
     * @return value or {@code null} for none
     */
    public View getView() {
      return view;
    }

    /**
     * Additional details for a view.
     * @param view view or {@code null} for none
     */
    public Tables setView(View view) {
      this.view = view;
      return this;
    }

    @Override
    public Tables set(String fieldName, Object value) {
      return (Tables) super.set(fieldName, value);
    }

    @Override
    public Tables clone() {
      return (Tables) super.clone();
    }

    /**
     * Additional details for a view.
     */
    public static final class View extends com.google.api.client.json.GenericJson {

      /**
       * True if view is defined in legacy SQL dialect, false if in standard SQL.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useLegacySql;

      /**
       * True if view is defined in legacy SQL dialect, false if in standard SQL.
       * @return value or {@code null} for none
       */
      public java.lang.Boolean getUseLegacySql() {
        return useLegacySql;
      }

      /**
       * True if view is defined in legacy SQL dialect, false if in standard SQL.
       * @param useLegacySql useLegacySql or {@code null} for none
       */
      public View setUseLegacySql(java.lang.Boolean useLegacySql) {
        this.useLegacySql = useLegacySql;
        return this;
      }

      @Override
      public View set(String fieldName, Object value) {
        return (View) super.set(fieldName, value);
      }

      @Override
      public View clone() {
        return (View) super.clone();
      }

    }
  }

}
