/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-25 at 07:33:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for DatasetList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DatasetList extends com.google.api.client.json.GenericJson {

  /**
   * An array of the dataset resources in the project. Each resource contains basic information. For
   * full information about a particular dataset resource, use the Datasets: get method. This
   * property is omitted when there are no datasets in the project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Datasets> datasets;

  static {
    // hack to force ProGuard to consider Datasets used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Datasets.class);
  }

  /**
   * A hash value of the results page. You can use this property to determine if the page has
   * changed since the last request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The list type. This property always returns the value "bigquery#datasetList".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A token that can be used to request the next results page. This property is omitted on the
   * final results page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * An array of the dataset resources in the project. Each resource contains basic information. For
   * full information about a particular dataset resource, use the Datasets: get method. This
   * property is omitted when there are no datasets in the project.
   * @return value or {@code null} for none
   */
  public java.util.List<Datasets> getDatasets() {
    return datasets;
  }

  /**
   * An array of the dataset resources in the project. Each resource contains basic information. For
   * full information about a particular dataset resource, use the Datasets: get method. This
   * property is omitted when there are no datasets in the project.
   * @param datasets datasets or {@code null} for none
   */
  public DatasetList setDatasets(java.util.List<Datasets> datasets) {
    this.datasets = datasets;
    return this;
  }

  /**
   * A hash value of the results page. You can use this property to determine if the page has
   * changed since the last request.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * A hash value of the results page. You can use this property to determine if the page has
   * changed since the last request.
   * @param etag etag or {@code null} for none
   */
  public DatasetList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The list type. This property always returns the value "bigquery#datasetList".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The list type. This property always returns the value "bigquery#datasetList".
   * @param kind kind or {@code null} for none
   */
  public DatasetList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token that can be used to request the next results page. This property is omitted on the
   * final results page.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token that can be used to request the next results page. This property is omitted on the
   * final results page.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public DatasetList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public DatasetList set(String fieldName, Object value) {
    return (DatasetList) super.set(fieldName, value);
  }

  @Override
  public DatasetList clone() {
    return (DatasetList) super.clone();
  }

  /**
   * Model definition for DatasetListDatasets.
   */
  public static final class Datasets extends com.google.api.client.json.GenericJson {

    /**
     * The dataset reference. Use this property to access specific parts of the dataset's ID, such as
     * project ID or dataset ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DatasetReference datasetReference;

    /**
     * A descriptive name for the dataset, if one exists.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String friendlyName;

    /**
     * The fully-qualified, unique, opaque ID of the dataset.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The resource type. This property always returns the value "bigquery#dataset".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String kind;

    /**
     * The labels associated with this dataset. You can use these to organize and group your datasets.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, java.lang.String> labels;

    /**
     * [Experimental] The geographic location where the data resides.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String location;

    /**
     * The dataset reference. Use this property to access specific parts of the dataset's ID, such as
     * project ID or dataset ID.
     * @return value or {@code null} for none
     */
    public DatasetReference getDatasetReference() {
      return datasetReference;
    }

    /**
     * The dataset reference. Use this property to access specific parts of the dataset's ID, such as
     * project ID or dataset ID.
     * @param datasetReference datasetReference or {@code null} for none
     */
    public Datasets setDatasetReference(DatasetReference datasetReference) {
      this.datasetReference = datasetReference;
      return this;
    }

    /**
     * A descriptive name for the dataset, if one exists.
     * @return value or {@code null} for none
     */
    public java.lang.String getFriendlyName() {
      return friendlyName;
    }

    /**
     * A descriptive name for the dataset, if one exists.
     * @param friendlyName friendlyName or {@code null} for none
     */
    public Datasets setFriendlyName(java.lang.String friendlyName) {
      this.friendlyName = friendlyName;
      return this;
    }

    /**
     * The fully-qualified, unique, opaque ID of the dataset.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The fully-qualified, unique, opaque ID of the dataset.
     * @param id id or {@code null} for none
     */
    public Datasets setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * The resource type. This property always returns the value "bigquery#dataset".
     * @return value or {@code null} for none
     */
    public java.lang.String getKind() {
      return kind;
    }

    /**
     * The resource type. This property always returns the value "bigquery#dataset".
     * @param kind kind or {@code null} for none
     */
    public Datasets setKind(java.lang.String kind) {
      this.kind = kind;
      return this;
    }

    /**
     * The labels associated with this dataset. You can use these to organize and group your datasets.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.String> getLabels() {
      return labels;
    }

    /**
     * The labels associated with this dataset. You can use these to organize and group your datasets.
     * @param labels labels or {@code null} for none
     */
    public Datasets setLabels(java.util.Map<String, java.lang.String> labels) {
      this.labels = labels;
      return this;
    }

    /**
     * [Experimental] The geographic location where the data resides.
     * @return value or {@code null} for none
     */
    public java.lang.String getLocation() {
      return location;
    }

    /**
     * [Experimental] The geographic location where the data resides.
     * @param location location or {@code null} for none
     */
    public Datasets setLocation(java.lang.String location) {
      this.location = location;
      return this;
    }

    @Override
    public Datasets set(String fieldName, Object value) {
      return (Datasets) super.set(fieldName, value);
    }

    @Override
    public Datasets clone() {
      return (Datasets) super.clone();
    }

  }

}
