/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-15 at 05:53:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TrainingRun.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrainingRun extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only, Beta] List of each iteration results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IterationResult> iterationResults;

  static {
    // hack to force ProGuard to consider IterationResult used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IterationResult.class);
  }

  /**
   * [Output-only, Beta] Training run start time in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startTime;

  /**
   * [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is
   * in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run
   * successfully completed. CANCELLED: Training run cancelled by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * [Output-only, Beta] Training options used by this training run. These options are mutable for
   * subsequent training runs. Default values are explicitly stored for options not specified in the
   * input query of the first training run. For subsequent training runs, any option not explicitly
   * specified in the input query will be copied from the previous training run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TrainingOptions trainingOptions;

  /**
   * [Output-only, Beta] List of each iteration results.
   * @return value or {@code null} for none
   */
  public java.util.List<IterationResult> getIterationResults() {
    return iterationResults;
  }

  /**
   * [Output-only, Beta] List of each iteration results.
   * @param iterationResults iterationResults or {@code null} for none
   */
  public TrainingRun setIterationResults(java.util.List<IterationResult> iterationResults) {
    this.iterationResults = iterationResults;
    return this;
  }

  /**
   * [Output-only, Beta] Training run start time in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartTime() {
    return startTime;
  }

  /**
   * [Output-only, Beta] Training run start time in milliseconds since the epoch.
   * @param startTime startTime or {@code null} for none
   */
  public TrainingRun setStartTime(com.google.api.client.util.DateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is
   * in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run
   * successfully completed. CANCELLED: Training run cancelled by the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is
   * in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run
   * successfully completed. CANCELLED: Training run cancelled by the user.
   * @param state state or {@code null} for none
   */
  public TrainingRun setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * [Output-only, Beta] Training options used by this training run. These options are mutable for
   * subsequent training runs. Default values are explicitly stored for options not specified in the
   * input query of the first training run. For subsequent training runs, any option not explicitly
   * specified in the input query will be copied from the previous training run.
   * @return value or {@code null} for none
   */
  public TrainingOptions getTrainingOptions() {
    return trainingOptions;
  }

  /**
   * [Output-only, Beta] Training options used by this training run. These options are mutable for
   * subsequent training runs. Default values are explicitly stored for options not specified in the
   * input query of the first training run. For subsequent training runs, any option not explicitly
   * specified in the input query will be copied from the previous training run.
   * @param trainingOptions trainingOptions or {@code null} for none
   */
  public TrainingRun setTrainingOptions(TrainingOptions trainingOptions) {
    this.trainingOptions = trainingOptions;
    return this;
  }

  @Override
  public TrainingRun set(String fieldName, Object value) {
    return (TrainingRun) super.set(fieldName, value);
  }

  @Override
  public TrainingRun clone() {
    return (TrainingRun) super.clone();
  }

  /**
   * [Output-only, Beta] Training options used by this training run. These options are mutable for
   * subsequent training runs. Default values are explicitly stored for options not specified in the
   * input query of the first training run. For subsequent training runs, any option not explicitly
   * specified in the input query will be copied from the previous training run.
   */
  public static final class TrainingOptions extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean earlyStop;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double l1Reg;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double l2Reg;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double learnRate;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String learnRateStrategy;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double lineSearchInitLearnRate;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long maxIteration;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double minRelProgress;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean warmStart;

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getEarlyStop() {
      return earlyStop;
    }

    /**
     * @param earlyStop earlyStop or {@code null} for none
     */
    public TrainingOptions setEarlyStop(java.lang.Boolean earlyStop) {
      this.earlyStop = earlyStop;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Double getL1Reg() {
      return l1Reg;
    }

    /**
     * @param l1Reg l1Reg or {@code null} for none
     */
    public TrainingOptions setL1Reg(java.lang.Double l1Reg) {
      this.l1Reg = l1Reg;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Double getL2Reg() {
      return l2Reg;
    }

    /**
     * @param l2Reg l2Reg or {@code null} for none
     */
    public TrainingOptions setL2Reg(java.lang.Double l2Reg) {
      this.l2Reg = l2Reg;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Double getLearnRate() {
      return learnRate;
    }

    /**
     * @param learnRate learnRate or {@code null} for none
     */
    public TrainingOptions setLearnRate(java.lang.Double learnRate) {
      this.learnRate = learnRate;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.String getLearnRateStrategy() {
      return learnRateStrategy;
    }

    /**
     * @param learnRateStrategy learnRateStrategy or {@code null} for none
     */
    public TrainingOptions setLearnRateStrategy(java.lang.String learnRateStrategy) {
      this.learnRateStrategy = learnRateStrategy;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Double getLineSearchInitLearnRate() {
      return lineSearchInitLearnRate;
    }

    /**
     * @param lineSearchInitLearnRate lineSearchInitLearnRate or {@code null} for none
     */
    public TrainingOptions setLineSearchInitLearnRate(java.lang.Double lineSearchInitLearnRate) {
      this.lineSearchInitLearnRate = lineSearchInitLearnRate;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Long getMaxIteration() {
      return maxIteration;
    }

    /**
     * @param maxIteration maxIteration or {@code null} for none
     */
    public TrainingOptions setMaxIteration(java.lang.Long maxIteration) {
      this.maxIteration = maxIteration;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Double getMinRelProgress() {
      return minRelProgress;
    }

    /**
     * @param minRelProgress minRelProgress or {@code null} for none
     */
    public TrainingOptions setMinRelProgress(java.lang.Double minRelProgress) {
      this.minRelProgress = minRelProgress;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getWarmStart() {
      return warmStart;
    }

    /**
     * @param warmStart warmStart or {@code null} for none
     */
    public TrainingOptions setWarmStart(java.lang.Boolean warmStart) {
      this.warmStart = warmStart;
      return this;
    }

    @Override
    public TrainingOptions set(String fieldName, Object value) {
      return (TrainingOptions) super.set(fieldName, value);
    }

    @Override
    public TrainingOptions clone() {
      return (TrainingOptions) super.clone();
    }

  }
}
