/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-15 at 08:02:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for RoutineReference.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RoutineReference extends com.google.api.client.json.GenericJson {

  /**
   * [Required] The ID of the dataset containing this routine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasetId;

  /**
   * [Required] The ID of the project containing this routine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * or underscores (_). The maximum length is 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String routineId;

  /**
   * [Required] The ID of the dataset containing this routine.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasetId() {
    return datasetId;
  }

  /**
   * [Required] The ID of the dataset containing this routine.
   * @param datasetId datasetId or {@code null} for none
   */
  public RoutineReference setDatasetId(java.lang.String datasetId) {
    this.datasetId = datasetId;
    return this;
  }

  /**
   * [Required] The ID of the project containing this routine.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * [Required] The ID of the project containing this routine.
   * @param projectId projectId or {@code null} for none
   */
  public RoutineReference setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * or underscores (_). The maximum length is 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getRoutineId() {
    return routineId;
  }

  /**
   * [Required] The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * or underscores (_). The maximum length is 256 characters.
   * @param routineId routineId or {@code null} for none
   */
  public RoutineReference setRoutineId(java.lang.String routineId) {
    this.routineId = routineId;
    return this;
  }

  @Override
  public RoutineReference set(String fieldName, Object value) {
    return (RoutineReference) super.set(fieldName, value);
  }

  @Override
  public RoutineReference clone() {
    return (RoutineReference) super.clone();
  }

}
