/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 19:19:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for MaterializedViewDefinition.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MaterializedViewDefinition extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] [TrustedTester] The time when this materialized view was last modified, in
   * milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastRefreshTime;

  /**
   * [Required] A query whose result is persisted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * [Output-only] [TrustedTester] The time when this materialized view was last modified, in
   * milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastRefreshTime() {
    return lastRefreshTime;
  }

  /**
   * [Output-only] [TrustedTester] The time when this materialized view was last modified, in
   * milliseconds since the epoch.
   * @param lastRefreshTime lastRefreshTime or {@code null} for none
   */
  public MaterializedViewDefinition setLastRefreshTime(java.lang.Long lastRefreshTime) {
    this.lastRefreshTime = lastRefreshTime;
    return this;
  }

  /**
   * [Required] A query whose result is persisted.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * [Required] A query whose result is persisted.
   * @param query query or {@code null} for none
   */
  public MaterializedViewDefinition setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  @Override
  public MaterializedViewDefinition set(String fieldName, Object value) {
    return (MaterializedViewDefinition) super.set(fieldName, value);
  }

  @Override
  public MaterializedViewDefinition clone() {
    return (MaterializedViewDefinition) super.clone();
  }

}
