/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 19:19:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Id path of a model.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModelReference extends com.google.api.client.json.GenericJson {

  /**
   * [Required] The ID of the dataset containing this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasetId;

  /**
   * [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_). The maximum length is 1,024 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String modelId;

  /**
   * [Required] The ID of the project containing this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * [Required] The ID of the dataset containing this model.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasetId() {
    return datasetId;
  }

  /**
   * [Required] The ID of the dataset containing this model.
   * @param datasetId datasetId or {@code null} for none
   */
  public ModelReference setDatasetId(java.lang.String datasetId) {
    this.datasetId = datasetId;
    return this;
  }

  /**
   * [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_). The maximum length is 1,024 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getModelId() {
    return modelId;
  }

  /**
   * [Required] The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_). The maximum length is 1,024 characters.
   * @param modelId modelId or {@code null} for none
   */
  public ModelReference setModelId(java.lang.String modelId) {
    this.modelId = modelId;
    return this;
  }

  /**
   * [Required] The ID of the project containing this model.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * [Required] The ID of the project containing this model.
   * @param projectId projectId or {@code null} for none
   */
  public ModelReference setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  @Override
  public ModelReference set(String fieldName, Object value) {
    return (ModelReference) super.set(fieldName, value);
  }

  @Override
  public ModelReference clone() {
    return (ModelReference) super.clone();
  }

}
