/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 19:19:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Evaluation metrics for regression models.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegressionMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Mean absolute error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double meanAbsoluteError;

  /**
   * Mean squared error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double meanSquaredError;

  /**
   * Mean squared log error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double meanSquaredLogError;

  /**
   * Median absolute error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double medianAbsoluteError;

  /**
   * R^2 score.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double rSquared;

  /**
   * Mean absolute error.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMeanAbsoluteError() {
    return meanAbsoluteError;
  }

  /**
   * Mean absolute error.
   * @param meanAbsoluteError meanAbsoluteError or {@code null} for none
   */
  public RegressionMetrics setMeanAbsoluteError(java.lang.Double meanAbsoluteError) {
    this.meanAbsoluteError = meanAbsoluteError;
    return this;
  }

  /**
   * Mean squared error.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMeanSquaredError() {
    return meanSquaredError;
  }

  /**
   * Mean squared error.
   * @param meanSquaredError meanSquaredError or {@code null} for none
   */
  public RegressionMetrics setMeanSquaredError(java.lang.Double meanSquaredError) {
    this.meanSquaredError = meanSquaredError;
    return this;
  }

  /**
   * Mean squared log error.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMeanSquaredLogError() {
    return meanSquaredLogError;
  }

  /**
   * Mean squared log error.
   * @param meanSquaredLogError meanSquaredLogError or {@code null} for none
   */
  public RegressionMetrics setMeanSquaredLogError(java.lang.Double meanSquaredLogError) {
    this.meanSquaredLogError = meanSquaredLogError;
    return this;
  }

  /**
   * Median absolute error.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMedianAbsoluteError() {
    return medianAbsoluteError;
  }

  /**
   * Median absolute error.
   * @param medianAbsoluteError medianAbsoluteError or {@code null} for none
   */
  public RegressionMetrics setMedianAbsoluteError(java.lang.Double medianAbsoluteError) {
    this.medianAbsoluteError = medianAbsoluteError;
    return this;
  }

  /**
   * R^2 score.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRSquared() {
    return rSquared;
  }

  /**
   * R^2 score.
   * @param rSquared rSquared or {@code null} for none
   */
  public RegressionMetrics setRSquared(java.lang.Double rSquared) {
    this.rSquared = rSquared;
    return this;
  }

  @Override
  public RegressionMetrics set(String fieldName, Object value) {
    return (RegressionMetrics) super.set(fieldName, value);
  }

  @Override
  public RegressionMetrics clone() {
    return (RegressionMetrics) super.clone();
  }

}
