/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 19:19:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for Model.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Model extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time when this model was created, in millisecs since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * [Optional] A user-friendly description of this model. @mutable bigquery.models.patch
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. A hash of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * [Optional] The time when this model expires, in milliseconds since the epoch. If not present,
   * the model will persist indefinitely. Expired models will be deleted and their storage
   * reclaimed.  The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created models. @mutable bigquery.models.patch
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationTime;

  /**
   * Output only. Input feature columns that were used to train this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StandardSqlField> featureColumns;

  static {
    // hack to force ProGuard to consider StandardSqlField used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StandardSqlField.class);
  }

  /**
   * [Optional] A descriptive name for this model. @mutable bigquery.models.patch
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * Output only. Label columns that were used to train this model. The output of the model will
   * have a “predicted_” prefix to these columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StandardSqlField> labelColumns;

  static {
    // hack to force ProGuard to consider StandardSqlField used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StandardSqlField.class);
  }

  /**
   * [Optional] The labels associated with this model. You can use these to organize and group your
   * models. Label keys and values can be no longer than 63 characters, can only contain lowercase
   * letters, numeric characters, underscores and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter and each label in the list must
   * have a different key. @mutable bigquery.models.patch
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Output only. The time when this model was last modified, in millisecs since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastModifiedTime;

  /**
   * Output only. The geographic location where the model resides. This value is inherited from the
   * dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Required. Unique identifier for this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ModelReference modelReference;

  /**
   * Output only. Type of the model resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String modelType;

  /**
   * Output only. Information for all training runs in increasing order of start_time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TrainingRun> trainingRuns;

  /**
   * Output only. The time when this model was created, in millisecs since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time when this model was created, in millisecs since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public Model setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * [Optional] A user-friendly description of this model. @mutable bigquery.models.patch
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Optional] A user-friendly description of this model. @mutable bigquery.models.patch
   * @param description description or {@code null} for none
   */
  public Model setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. A hash of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. A hash of this resource.
   * @param etag etag or {@code null} for none
   */
  public Model setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * [Optional] The time when this model expires, in milliseconds since the epoch. If not present,
   * the model will persist indefinitely. Expired models will be deleted and their storage
   * reclaimed.  The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created models. @mutable bigquery.models.patch
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationTime() {
    return expirationTime;
  }

  /**
   * [Optional] The time when this model expires, in milliseconds since the epoch. If not present,
   * the model will persist indefinitely. Expired models will be deleted and their storage
   * reclaimed.  The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created models. @mutable bigquery.models.patch
   * @param expirationTime expirationTime or {@code null} for none
   */
  public Model setExpirationTime(java.lang.Long expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * Output only. Input feature columns that were used to train this model.
   * @return value or {@code null} for none
   */
  public java.util.List<StandardSqlField> getFeatureColumns() {
    return featureColumns;
  }

  /**
   * Output only. Input feature columns that were used to train this model.
   * @param featureColumns featureColumns or {@code null} for none
   */
  public Model setFeatureColumns(java.util.List<StandardSqlField> featureColumns) {
    this.featureColumns = featureColumns;
    return this;
  }

  /**
   * [Optional] A descriptive name for this model. @mutable bigquery.models.patch
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * [Optional] A descriptive name for this model. @mutable bigquery.models.patch
   * @param friendlyName friendlyName or {@code null} for none
   */
  public Model setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * Output only. Label columns that were used to train this model. The output of the model will
   * have a “predicted_” prefix to these columns.
   * @return value or {@code null} for none
   */
  public java.util.List<StandardSqlField> getLabelColumns() {
    return labelColumns;
  }

  /**
   * Output only. Label columns that were used to train this model. The output of the model will
   * have a “predicted_” prefix to these columns.
   * @param labelColumns labelColumns or {@code null} for none
   */
  public Model setLabelColumns(java.util.List<StandardSqlField> labelColumns) {
    this.labelColumns = labelColumns;
    return this;
  }

  /**
   * [Optional] The labels associated with this model. You can use these to organize and group your
   * models. Label keys and values can be no longer than 63 characters, can only contain lowercase
   * letters, numeric characters, underscores and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter and each label in the list must
   * have a different key. @mutable bigquery.models.patch
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * [Optional] The labels associated with this model. You can use these to organize and group your
   * models. Label keys and values can be no longer than 63 characters, can only contain lowercase
   * letters, numeric characters, underscores and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter and each label in the list must
   * have a different key. @mutable bigquery.models.patch
   * @param labels labels or {@code null} for none
   */
  public Model setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Output only. The time when this model was last modified, in millisecs since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * Output only. The time when this model was last modified, in millisecs since the epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Model setLastModifiedTime(java.lang.Long lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * Output only. The geographic location where the model resides. This value is inherited from the
   * dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Output only. The geographic location where the model resides. This value is inherited from the
   * dataset.
   * @param location location or {@code null} for none
   */
  public Model setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Required. Unique identifier for this model.
   * @return value or {@code null} for none
   */
  public ModelReference getModelReference() {
    return modelReference;
  }

  /**
   * Required. Unique identifier for this model.
   * @param modelReference modelReference or {@code null} for none
   */
  public Model setModelReference(ModelReference modelReference) {
    this.modelReference = modelReference;
    return this;
  }

  /**
   * Output only. Type of the model resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getModelType() {
    return modelType;
  }

  /**
   * Output only. Type of the model resource.
   * @param modelType modelType or {@code null} for none
   */
  public Model setModelType(java.lang.String modelType) {
    this.modelType = modelType;
    return this;
  }

  /**
   * Output only. Information for all training runs in increasing order of start_time.
   * @return value or {@code null} for none
   */
  public java.util.List<TrainingRun> getTrainingRuns() {
    return trainingRuns;
  }

  /**
   * Output only. Information for all training runs in increasing order of start_time.
   * @param trainingRuns trainingRuns or {@code null} for none
   */
  public Model setTrainingRuns(java.util.List<TrainingRun> trainingRuns) {
    this.trainingRuns = trainingRuns;
    return this;
  }

  @Override
  public Model set(String fieldName, Object value) {
    return (Model) super.set(fieldName, value);
  }

  @Override
  public Model clone() {
    return (Model) super.clone();
  }

}
