/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 19:19:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for RangePartitioning.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RangePartitioning extends com.google.api.client.json.GenericJson {

  /**
   * [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-
   * level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String field;

  /**
   * [TrustedTester] [Required] Defines the ranges for range partitioning.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range range;

  /**
   * [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-
   * level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
   * @return value or {@code null} for none
   */
  public java.lang.String getField() {
    return field;
  }

  /**
   * [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-
   * level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
   * @param field field or {@code null} for none
   */
  public RangePartitioning setField(java.lang.String field) {
    this.field = field;
    return this;
  }

  /**
   * [TrustedTester] [Required] Defines the ranges for range partitioning.
   * @return value or {@code null} for none
   */
  public Range getRange() {
    return range;
  }

  /**
   * [TrustedTester] [Required] Defines the ranges for range partitioning.
   * @param range range or {@code null} for none
   */
  public RangePartitioning setRange(Range range) {
    this.range = range;
    return this;
  }

  @Override
  public RangePartitioning set(String fieldName, Object value) {
    return (RangePartitioning) super.set(fieldName, value);
  }

  @Override
  public RangePartitioning clone() {
    return (RangePartitioning) super.clone();
  }

  /**
   * [TrustedTester] [Required] Defines the ranges for range partitioning.
   */
  public static final class Range extends com.google.api.client.json.GenericJson {

    /**
     * [TrustedTester] [Required] The end of range partitioning, exclusive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long end;

    /**
     * [TrustedTester] [Required] The width of each interval.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long interval;

    /**
     * [TrustedTester] [Required] The start of range partitioning, inclusive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long start;

    /**
     * [TrustedTester] [Required] The end of range partitioning, exclusive.
     * @return value or {@code null} for none
     */
    public java.lang.Long getEnd() {
      return end;
    }

    /**
     * [TrustedTester] [Required] The end of range partitioning, exclusive.
     * @param end end or {@code null} for none
     */
    public Range setEnd(java.lang.Long end) {
      this.end = end;
      return this;
    }

    /**
     * [TrustedTester] [Required] The width of each interval.
     * @return value or {@code null} for none
     */
    public java.lang.Long getInterval() {
      return interval;
    }

    /**
     * [TrustedTester] [Required] The width of each interval.
     * @param interval interval or {@code null} for none
     */
    public Range setInterval(java.lang.Long interval) {
      this.interval = interval;
      return this;
    }

    /**
     * [TrustedTester] [Required] The start of range partitioning, inclusive.
     * @return value or {@code null} for none
     */
    public java.lang.Long getStart() {
      return start;
    }

    /**
     * [TrustedTester] [Required] The start of range partitioning, inclusive.
     * @param start start or {@code null} for none
     */
    public Range setStart(java.lang.Long start) {
      this.start = start;
      return this;
    }

    @Override
    public Range set(String fieldName, Object value) {
      return (Range) super.set(fieldName, value);
    }

    @Override
    public Range clone() {
      return (Range) super.clone();
    }

  }
}
