/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 23:16:01 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for BigQueryModelTraining.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigQueryModelTraining extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only, Beta] Index of current ML training iteration. Updated during create model query
   * job to show job progress.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer currentIteration;

  /**
   * [Output-only, Beta] Expected number of iterations for the create model query job specified as
   * num_iterations in the input query. The actual total number of iterations may be less than this
   * number due to early stop.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expectedTotalIterations;

  /**
   * [Output-only, Beta] Index of current ML training iteration. Updated during create model query
   * job to show job progress.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCurrentIteration() {
    return currentIteration;
  }

  /**
   * [Output-only, Beta] Index of current ML training iteration. Updated during create model query
   * job to show job progress.
   * @param currentIteration currentIteration or {@code null} for none
   */
  public BigQueryModelTraining setCurrentIteration(java.lang.Integer currentIteration) {
    this.currentIteration = currentIteration;
    return this;
  }

  /**
   * [Output-only, Beta] Expected number of iterations for the create model query job specified as
   * num_iterations in the input query. The actual total number of iterations may be less than this
   * number due to early stop.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpectedTotalIterations() {
    return expectedTotalIterations;
  }

  /**
   * [Output-only, Beta] Expected number of iterations for the create model query job specified as
   * num_iterations in the input query. The actual total number of iterations may be less than this
   * number due to early stop.
   * @param expectedTotalIterations expectedTotalIterations or {@code null} for none
   */
  public BigQueryModelTraining setExpectedTotalIterations(java.lang.Long expectedTotalIterations) {
    this.expectedTotalIterations = expectedTotalIterations;
    return this;
  }

  @Override
  public BigQueryModelTraining set(String fieldName, Object value) {
    return (BigQueryModelTraining) super.set(fieldName, value);
  }

  @Override
  public BigQueryModelTraining clone() {
    return (BigQueryModelTraining) super.clone();
  }

}
