/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 19:19:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * A single entry in the confusion matrix.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BigqueryEntry extends com.google.api.client.json.GenericJson {

  /**
   * Number of items being predicted as this label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long itemCount;

  /**
   * The predicted label. For confidence_threshold > 0, we will also add an entry indicating the
   * number of items under the confidence threshold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String predictedLabel;

  /**
   * Number of items being predicted as this label.
   * @return value or {@code null} for none
   */
  public java.lang.Long getItemCount() {
    return itemCount;
  }

  /**
   * Number of items being predicted as this label.
   * @param itemCount itemCount or {@code null} for none
   */
  public BigqueryEntry setItemCount(java.lang.Long itemCount) {
    this.itemCount = itemCount;
    return this;
  }

  /**
   * The predicted label. For confidence_threshold > 0, we will also add an entry indicating the
   * number of items under the confidence threshold.
   * @return value or {@code null} for none
   */
  public java.lang.String getPredictedLabel() {
    return predictedLabel;
  }

  /**
   * The predicted label. For confidence_threshold > 0, we will also add an entry indicating the
   * number of items under the confidence threshold.
   * @param predictedLabel predictedLabel or {@code null} for none
   */
  public BigqueryEntry setPredictedLabel(java.lang.String predictedLabel) {
    this.predictedLabel = predictedLabel;
    return this;
  }

  @Override
  public BigqueryEntry set(String fieldName, Object value) {
    return (BigqueryEntry) super.set(fieldName, value);
  }

  @Override
  public BigqueryEntry clone() {
    return (BigqueryEntry) super.clone();
  }

}
