/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-03 at 06:50:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for DestinationTableProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DestinationTableProperties extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] The description for the destination table. This will only be used if the destination
   * table is newly created. If the table already exists and a value different than the current
   * description is provided, the job will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Optional] The friendly name for the destination table. This will only be used if the
   * destination table is newly created. If the table already exists and a value different than the
   * current friendly name is provided, the job will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * [Optional] The labels associated with this table. You can use these to organize and group your
   * tables. This will only be used if the destination table is newly created. If the table already
   * exists and labels are different than the current labels are provided, the job will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * [Optional] The description for the destination table. This will only be used if the destination
   * table is newly created. If the table already exists and a value different than the current
   * description is provided, the job will fail.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Optional] The description for the destination table. This will only be used if the destination
   * table is newly created. If the table already exists and a value different than the current
   * description is provided, the job will fail.
   * @param description description or {@code null} for none
   */
  public DestinationTableProperties setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Optional] The friendly name for the destination table. This will only be used if the
   * destination table is newly created. If the table already exists and a value different than the
   * current friendly name is provided, the job will fail.
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * [Optional] The friendly name for the destination table. This will only be used if the
   * destination table is newly created. If the table already exists and a value different than the
   * current friendly name is provided, the job will fail.
   * @param friendlyName friendlyName or {@code null} for none
   */
  public DestinationTableProperties setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * [Optional] The labels associated with this table. You can use these to organize and group your
   * tables. This will only be used if the destination table is newly created. If the table already
   * exists and labels are different than the current labels are provided, the job will fail.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * [Optional] The labels associated with this table. You can use these to organize and group your
   * tables. This will only be used if the destination table is newly created. If the table already
   * exists and labels are different than the current labels are provided, the job will fail.
   * @param labels labels or {@code null} for none
   */
  public DestinationTableProperties setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public DestinationTableProperties set(String fieldName, Object value) {
    return (DestinationTableProperties) super.set(fieldName, value);
  }

  @Override
  public DestinationTableProperties clone() {
    return (DestinationTableProperties) super.clone();
  }

}
