/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-08 at 04:28:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TrainingOptions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TrainingOptions extends com.google.api.client.json.GenericJson {

  /**
   * The column to split data with. This column won't be used as a feature. 1. When
   * data_split_method is CUSTOM, the corresponding column should be boolean. The rows with true
   * value tag are eval data, and the false are training data. 2. When data_split_method is SEQ, the
   * first DATA_SPLIT_EVAL_FRACTION rows (from smallest to largest) in the corresponding column are
   * used as training data, and the rest are eval data. It respects the order in Orderable data
   * types: https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data-type-
   * properties
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSplitColumn;

  /**
   * The fraction of evaluation data over the whole input data. The rest of data will be used as
   * training data. The format should be double. Accurate to two decimal places. Default value is
   * 0.2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double dataSplitEvalFraction;

  /**
   * The data split type for training and evaluation, e.g. RANDOM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSplitMethod;

  /**
   * [Beta] Distance type for clustering models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String distanceType;

  /**
   * Whether to stop early when the loss doesn't improve significantly any more (compared to
   * min_relative_progress).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean earlyStop;

  /**
   * Specifies the initial learning rate for line search to start at.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double initialLearnRate;

  /**
   * Name of input label columns in training data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> inputLabelColumns;

  /**
   * L1 regularization coefficient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double l1Regularization;

  /**
   * L2 regularization coefficient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double l2Regularization;

  /**
   * Weights associated with each label class, for rebalancing the training data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Double> labelClassWeights;

  /**
   * Learning rate in training.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double learnRate;

  /**
   * The strategy to determine learning rate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String learnRateStrategy;

  /**
   * Type of loss function used during training run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lossType;

  /**
   * The maximum number of iterations in training.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxIterations;

  /**
   * When early_stop is true, stops training when accuracy improvement is less than
   * 'min_relative_progress'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double minRelativeProgress;

  /**
   * [Beta] Number of clusters for clustering models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numClusters;

  /**
   * Whether to train a model from the last checkpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean warmStart;

  /**
   * The column to split data with. This column won't be used as a feature. 1. When
   * data_split_method is CUSTOM, the corresponding column should be boolean. The rows with true
   * value tag are eval data, and the false are training data. 2. When data_split_method is SEQ, the
   * first DATA_SPLIT_EVAL_FRACTION rows (from smallest to largest) in the corresponding column are
   * used as training data, and the rest are eval data. It respects the order in Orderable data
   * types: https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data-type-
   * properties
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSplitColumn() {
    return dataSplitColumn;
  }

  /**
   * The column to split data with. This column won't be used as a feature. 1. When
   * data_split_method is CUSTOM, the corresponding column should be boolean. The rows with true
   * value tag are eval data, and the false are training data. 2. When data_split_method is SEQ, the
   * first DATA_SPLIT_EVAL_FRACTION rows (from smallest to largest) in the corresponding column are
   * used as training data, and the rest are eval data. It respects the order in Orderable data
   * types: https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data-type-
   * properties
   * @param dataSplitColumn dataSplitColumn or {@code null} for none
   */
  public TrainingOptions setDataSplitColumn(java.lang.String dataSplitColumn) {
    this.dataSplitColumn = dataSplitColumn;
    return this;
  }

  /**
   * The fraction of evaluation data over the whole input data. The rest of data will be used as
   * training data. The format should be double. Accurate to two decimal places. Default value is
   * 0.2.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDataSplitEvalFraction() {
    return dataSplitEvalFraction;
  }

  /**
   * The fraction of evaluation data over the whole input data. The rest of data will be used as
   * training data. The format should be double. Accurate to two decimal places. Default value is
   * 0.2.
   * @param dataSplitEvalFraction dataSplitEvalFraction or {@code null} for none
   */
  public TrainingOptions setDataSplitEvalFraction(java.lang.Double dataSplitEvalFraction) {
    this.dataSplitEvalFraction = dataSplitEvalFraction;
    return this;
  }

  /**
   * The data split type for training and evaluation, e.g. RANDOM.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSplitMethod() {
    return dataSplitMethod;
  }

  /**
   * The data split type for training and evaluation, e.g. RANDOM.
   * @param dataSplitMethod dataSplitMethod or {@code null} for none
   */
  public TrainingOptions setDataSplitMethod(java.lang.String dataSplitMethod) {
    this.dataSplitMethod = dataSplitMethod;
    return this;
  }

  /**
   * [Beta] Distance type for clustering models.
   * @return value or {@code null} for none
   */
  public java.lang.String getDistanceType() {
    return distanceType;
  }

  /**
   * [Beta] Distance type for clustering models.
   * @param distanceType distanceType or {@code null} for none
   */
  public TrainingOptions setDistanceType(java.lang.String distanceType) {
    this.distanceType = distanceType;
    return this;
  }

  /**
   * Whether to stop early when the loss doesn't improve significantly any more (compared to
   * min_relative_progress).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEarlyStop() {
    return earlyStop;
  }

  /**
   * Whether to stop early when the loss doesn't improve significantly any more (compared to
   * min_relative_progress).
   * @param earlyStop earlyStop or {@code null} for none
   */
  public TrainingOptions setEarlyStop(java.lang.Boolean earlyStop) {
    this.earlyStop = earlyStop;
    return this;
  }

  /**
   * Specifies the initial learning rate for line search to start at.
   * @return value or {@code null} for none
   */
  public java.lang.Double getInitialLearnRate() {
    return initialLearnRate;
  }

  /**
   * Specifies the initial learning rate for line search to start at.
   * @param initialLearnRate initialLearnRate or {@code null} for none
   */
  public TrainingOptions setInitialLearnRate(java.lang.Double initialLearnRate) {
    this.initialLearnRate = initialLearnRate;
    return this;
  }

  /**
   * Name of input label columns in training data.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInputLabelColumns() {
    return inputLabelColumns;
  }

  /**
   * Name of input label columns in training data.
   * @param inputLabelColumns inputLabelColumns or {@code null} for none
   */
  public TrainingOptions setInputLabelColumns(java.util.List<java.lang.String> inputLabelColumns) {
    this.inputLabelColumns = inputLabelColumns;
    return this;
  }

  /**
   * L1 regularization coefficient.
   * @return value or {@code null} for none
   */
  public java.lang.Double getL1Regularization() {
    return l1Regularization;
  }

  /**
   * L1 regularization coefficient.
   * @param l1Regularization l1Regularization or {@code null} for none
   */
  public TrainingOptions setL1Regularization(java.lang.Double l1Regularization) {
    this.l1Regularization = l1Regularization;
    return this;
  }

  /**
   * L2 regularization coefficient.
   * @return value or {@code null} for none
   */
  public java.lang.Double getL2Regularization() {
    return l2Regularization;
  }

  /**
   * L2 regularization coefficient.
   * @param l2Regularization l2Regularization or {@code null} for none
   */
  public TrainingOptions setL2Regularization(java.lang.Double l2Regularization) {
    this.l2Regularization = l2Regularization;
    return this;
  }

  /**
   * Weights associated with each label class, for rebalancing the training data.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Double> getLabelClassWeights() {
    return labelClassWeights;
  }

  /**
   * Weights associated with each label class, for rebalancing the training data.
   * @param labelClassWeights labelClassWeights or {@code null} for none
   */
  public TrainingOptions setLabelClassWeights(java.util.Map<String, java.lang.Double> labelClassWeights) {
    this.labelClassWeights = labelClassWeights;
    return this;
  }

  /**
   * Learning rate in training.
   * @return value or {@code null} for none
   */
  public java.lang.Double getLearnRate() {
    return learnRate;
  }

  /**
   * Learning rate in training.
   * @param learnRate learnRate or {@code null} for none
   */
  public TrainingOptions setLearnRate(java.lang.Double learnRate) {
    this.learnRate = learnRate;
    return this;
  }

  /**
   * The strategy to determine learning rate.
   * @return value or {@code null} for none
   */
  public java.lang.String getLearnRateStrategy() {
    return learnRateStrategy;
  }

  /**
   * The strategy to determine learning rate.
   * @param learnRateStrategy learnRateStrategy or {@code null} for none
   */
  public TrainingOptions setLearnRateStrategy(java.lang.String learnRateStrategy) {
    this.learnRateStrategy = learnRateStrategy;
    return this;
  }

  /**
   * Type of loss function used during training run.
   * @return value or {@code null} for none
   */
  public java.lang.String getLossType() {
    return lossType;
  }

  /**
   * Type of loss function used during training run.
   * @param lossType lossType or {@code null} for none
   */
  public TrainingOptions setLossType(java.lang.String lossType) {
    this.lossType = lossType;
    return this;
  }

  /**
   * The maximum number of iterations in training.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxIterations() {
    return maxIterations;
  }

  /**
   * The maximum number of iterations in training.
   * @param maxIterations maxIterations or {@code null} for none
   */
  public TrainingOptions setMaxIterations(java.lang.Long maxIterations) {
    this.maxIterations = maxIterations;
    return this;
  }

  /**
   * When early_stop is true, stops training when accuracy improvement is less than
   * 'min_relative_progress'.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMinRelativeProgress() {
    return minRelativeProgress;
  }

  /**
   * When early_stop is true, stops training when accuracy improvement is less than
   * 'min_relative_progress'.
   * @param minRelativeProgress minRelativeProgress or {@code null} for none
   */
  public TrainingOptions setMinRelativeProgress(java.lang.Double minRelativeProgress) {
    this.minRelativeProgress = minRelativeProgress;
    return this;
  }

  /**
   * [Beta] Number of clusters for clustering models.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumClusters() {
    return numClusters;
  }

  /**
   * [Beta] Number of clusters for clustering models.
   * @param numClusters numClusters or {@code null} for none
   */
  public TrainingOptions setNumClusters(java.lang.Long numClusters) {
    this.numClusters = numClusters;
    return this;
  }

  /**
   * Whether to train a model from the last checkpoint.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWarmStart() {
    return warmStart;
  }

  /**
   * Whether to train a model from the last checkpoint.
   * @param warmStart warmStart or {@code null} for none
   */
  public TrainingOptions setWarmStart(java.lang.Boolean warmStart) {
    this.warmStart = warmStart;
    return this;
  }

  @Override
  public TrainingOptions set(String fieldName, Object value) {
    return (TrainingOptions) super.set(fieldName, value);
  }

  @Override
  public TrainingOptions clone() {
    return (TrainingOptions) super.clone();
  }

}
