/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-11-07 at 05:23:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Representative value of a categorical feature.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CategoricalValue extends com.google.api.client.json.GenericJson {

  /**
   * Counts of all categories for the categorical feature. If there are more than ten categories, we
   * return top ten (by count) and return one more CategoryCount with category "_OTHER_" and count
   * as aggregate counts of remaining categories.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CategoryCount> categoryCounts;

  /**
   * Counts of all categories for the categorical feature. If there are more than ten categories, we
   * return top ten (by count) and return one more CategoryCount with category "_OTHER_" and count
   * as aggregate counts of remaining categories.
   * @return value or {@code null} for none
   */
  public java.util.List<CategoryCount> getCategoryCounts() {
    return categoryCounts;
  }

  /**
   * Counts of all categories for the categorical feature. If there are more than ten categories, we
   * return top ten (by count) and return one more CategoryCount with category "_OTHER_" and count
   * as aggregate counts of remaining categories.
   * @param categoryCounts categoryCounts or {@code null} for none
   */
  public CategoricalValue setCategoryCounts(java.util.List<CategoryCount> categoryCounts) {
    this.categoryCounts = categoryCounts;
    return this;
  }

  @Override
  public CategoricalValue set(String fieldName, Object value) {
    return (CategoricalValue) super.set(fieldName, value);
  }

  @Override
  public CategoricalValue clone() {
    return (CategoricalValue) super.clone();
  }

}
