/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-11-14 at 13:21:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * (Auto-)arima fitting result. Wrap everything in ArimaResult for easier refactoring if we want to
 * use model-specific iteration results.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ArimaResult extends com.google.api.client.json.GenericJson {

  /**
   * This message is repeated because there are multiple arima models fitted in auto-arima. For non-
   * auto-arima model, its size is one.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ArimaModelInfo> arimaModelInfo;

  static {
    // hack to force ProGuard to consider ArimaModelInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ArimaModelInfo.class);
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> seasonalPeriods;

  /**
   * This message is repeated because there are multiple arima models fitted in auto-arima. For non-
   * auto-arima model, its size is one.
   * @return value or {@code null} for none
   */
  public java.util.List<ArimaModelInfo> getArimaModelInfo() {
    return arimaModelInfo;
  }

  /**
   * This message is repeated because there are multiple arima models fitted in auto-arima. For non-
   * auto-arima model, its size is one.
   * @param arimaModelInfo arimaModelInfo or {@code null} for none
   */
  public ArimaResult setArimaModelInfo(java.util.List<ArimaModelInfo> arimaModelInfo) {
    this.arimaModelInfo = arimaModelInfo;
    return this;
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSeasonalPeriods() {
    return seasonalPeriods;
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * @param seasonalPeriods seasonalPeriods or {@code null} for none
   */
  public ArimaResult setSeasonalPeriods(java.util.List<java.lang.String> seasonalPeriods) {
    this.seasonalPeriods = seasonalPeriods;
    return this;
  }

  @Override
  public ArimaResult set(String fieldName, Object value) {
    return (ArimaResult) super.set(fieldName, value);
  }

  @Override
  public ArimaResult clone() {
    return (ArimaResult) super.clone();
  }

}
