/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-12 at 00:09:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableFieldSchema.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableFieldSchema extends com.google.api.client.json.GenericJson {

  /**
   * [Optional] The categories attached to this field, used for field-level access control.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Categories categories;

  /**
   * [Optional] The field description. The maximum length is 1,024 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Optional] Describes the nested schema fields if the type property is set to RECORD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableFieldSchema> fields;

  /**
   * [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default
   * value is NULLABLE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_), and must start with a letter or underscore. The maximum length is 128
   * characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PolicyTags policyTags;

  /**
   * [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as
   * INTEGER), FLOAT, FLOAT64 (same as FLOAT), BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE,
   * TIME, DATETIME, RECORD (where RECORD indicates that the field contains a nested schema) or
   * STRUCT (same as RECORD).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Optional] The categories attached to this field, used for field-level access control.
   * @return value or {@code null} for none
   */
  public Categories getCategories() {
    return categories;
  }

  /**
   * [Optional] The categories attached to this field, used for field-level access control.
   * @param categories categories or {@code null} for none
   */
  public TableFieldSchema setCategories(Categories categories) {
    this.categories = categories;
    return this;
  }

  /**
   * [Optional] The field description. The maximum length is 1,024 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Optional] The field description. The maximum length is 1,024 characters.
   * @param description description or {@code null} for none
   */
  public TableFieldSchema setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Optional] Describes the nested schema fields if the type property is set to RECORD.
   * @return value or {@code null} for none
   */
  public java.util.List<TableFieldSchema> getFields() {
    return fields;
  }

  /**
   * [Optional] Describes the nested schema fields if the type property is set to RECORD.
   * @param fields fields or {@code null} for none
   */
  public TableFieldSchema setFields(java.util.List<TableFieldSchema> fields) {
    this.fields = fields;
    return this;
  }

  /**
   * [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default
   * value is NULLABLE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * [Optional] The field mode. Possible values include NULLABLE, REQUIRED and REPEATED. The default
   * value is NULLABLE.
   * @param mode mode or {@code null} for none
   */
  public TableFieldSchema setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_), and must start with a letter or underscore. The maximum length is 128
   * characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Required] The field name. The name must contain only letters (a-z, A-Z), numbers (0-9), or
   * underscores (_), and must start with a letter or underscore. The maximum length is 128
   * characters.
   * @param name name or {@code null} for none
   */
  public TableFieldSchema setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public PolicyTags getPolicyTags() {
    return policyTags;
  }

  /**
   * @param policyTags policyTags or {@code null} for none
   */
  public TableFieldSchema setPolicyTags(PolicyTags policyTags) {
    this.policyTags = policyTags;
    return this;
  }

  /**
   * [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as
   * INTEGER), FLOAT, FLOAT64 (same as FLOAT), BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE,
   * TIME, DATETIME, RECORD (where RECORD indicates that the field contains a nested schema) or
   * STRUCT (same as RECORD).
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * [Required] The field data type. Possible values include STRING, BYTES, INTEGER, INT64 (same as
   * INTEGER), FLOAT, FLOAT64 (same as FLOAT), BOOLEAN, BOOL (same as BOOLEAN), TIMESTAMP, DATE,
   * TIME, DATETIME, RECORD (where RECORD indicates that the field contains a nested schema) or
   * STRUCT (same as RECORD).
   * @param type type or {@code null} for none
   */
  public TableFieldSchema setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public TableFieldSchema set(String fieldName, Object value) {
    return (TableFieldSchema) super.set(fieldName, value);
  }

  @Override
  public TableFieldSchema clone() {
    return (TableFieldSchema) super.clone();
  }

  /**
   * [Optional] The categories attached to this field, used for field-level access control.
   */
  public static final class Categories extends com.google.api.client.json.GenericJson {

    /**
     * A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most
     * 5 categories are allowed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> names;

    /**
     * A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most
     * 5 categories are allowed.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getNames() {
      return names;
    }

    /**
     * A list of category resource names. For example, "projects/1/taxonomies/2/categories/3". At most
     * 5 categories are allowed.
     * @param names names or {@code null} for none
     */
    public Categories setNames(java.util.List<java.lang.String> names) {
      this.names = names;
      return this;
    }

    @Override
    public Categories set(String fieldName, Object value) {
      return (Categories) super.set(fieldName, value);
    }

    @Override
    public Categories clone() {
      return (Categories) super.clone();
    }

  }

  /**
   * Model definition for TableFieldSchemaPolicyTags.
   */
  public static final class PolicyTags extends com.google.api.client.json.GenericJson {

    /**
     * A list of category resource names. For example,
     * "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> names;

    /**
     * A list of category resource names. For example,
     * "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getNames() {
      return names;
    }

    /**
     * A list of category resource names. For example,
     * "projects/1/location/eu/taxonomies/2/policyTags/3". At most 1 policy tag is allowed.
     * @param names names or {@code null} for none
     */
    public PolicyTags setNames(java.util.List<java.lang.String> names) {
      this.names = names;
      return this;
    }

    @Override
    public PolicyTags set(String fieldName, Object value) {
      return (PolicyTags) super.set(fieldName, value);
    }

    @Override
    public PolicyTags clone() {
      return (PolicyTags) super.clone();
    }

  }

}
