/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-18 at 03:52:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Arima order, can be used for both non-seasonal and seasonal parts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ArimaOrder extends com.google.api.client.json.GenericJson {

  /**
   * Order of the differencing part.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long d;

  /**
   * Order of the autoregressive part.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long p;

  /**
   * Order of the moving-average part.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long q;

  /**
   * Order of the differencing part.
   * @return value or {@code null} for none
   */
  public java.lang.Long getD() {
    return d;
  }

  /**
   * Order of the differencing part.
   * @param d d or {@code null} for none
   */
  public ArimaOrder setD(java.lang.Long d) {
    this.d = d;
    return this;
  }

  /**
   * Order of the autoregressive part.
   * @return value or {@code null} for none
   */
  public java.lang.Long getP() {
    return p;
  }

  /**
   * Order of the autoregressive part.
   * @param p p or {@code null} for none
   */
  public ArimaOrder setP(java.lang.Long p) {
    this.p = p;
    return this;
  }

  /**
   * Order of the moving-average part.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQ() {
    return q;
  }

  /**
   * Order of the moving-average part.
   * @param q q or {@code null} for none
   */
  public ArimaOrder setQ(java.lang.Long q) {
    this.q = q;
    return this;
  }

  @Override
  public ArimaOrder set(String fieldName, Object value) {
    return (ArimaOrder) super.set(fieldName, value);
  }

  @Override
  public ArimaOrder clone() {
    return (ArimaOrder) super.clone();
  }

}
