/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-18 at 03:52:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * A user-defined function or a stored procedure.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Routine extends com.google.api.client.json.GenericJson {

  /**
   * Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Argument> arguments;

  static {
    // hack to force ProGuard to consider Argument used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Argument.class);
  }

  /**
   * Output only. The time when this routine was created, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * Required. The body of the routine.
   *
   * For functions, this is the expression in the AS clause.
   *
   * If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for
   * the function created with the following statement:
   *
   * `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\n", y))`
   *
   * The definition_body is `concat(x, "\n", y)` (\n is not replaced with linebreak).
   *
   * If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the
   * function created with the following statement:
   *
   * `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\n";\n'`
   *
   * The definition_body is
   *
   * `return "\n";\n`
   *
   * Note that both \n are replaced with linebreaks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String definitionBody;

  /**
   * Optional. [Experimental] The description of the routine if defined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. A hash of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT
   * libraries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> importedLibraries;

  /**
   * Optional. Defaults to "SQL".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * Output only. The time when this routine was last modified, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastModifiedTime;

  /**
   * Optional if language = "SQL"; required otherwise.
   *
   * If absent, the return type is inferred from definition_body at query time in each query that
   * references this routine. If present, then the evaluated result will be cast to the specified
   * returned type at query time.
   *
   * For example, for the functions created with the following statements:
   *
   * * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);`
   *
   * * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));`
   *
   * * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));`
   *
   * The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for
   * `Increment` (inferred as FLOAT64 at query time).
   *
   * Suppose the function `Add` is replaced by   `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64)
   * AS (x + y);`
   *
   * Then the inferred return type of `Increment` is automatically changed to INT64 at query time,
   * while the return type of `Decrement` remains FLOAT64.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StandardSqlDataType returnType;

  /**
   * Required. Reference describing the ID of this routine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RoutineReference routineReference;

  /**
   * Required. The type of routine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String routineType;

  /**
   * Optional.
   * @return value or {@code null} for none
   */
  public java.util.List<Argument> getArguments() {
    return arguments;
  }

  /**
   * Optional.
   * @param arguments arguments or {@code null} for none
   */
  public Routine setArguments(java.util.List<Argument> arguments) {
    this.arguments = arguments;
    return this;
  }

  /**
   * Output only. The time when this routine was created, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time when this routine was created, in milliseconds since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public Routine setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Required. The body of the routine.
   *
   * For functions, this is the expression in the AS clause.
   *
   * If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for
   * the function created with the following statement:
   *
   * `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\n", y))`
   *
   * The definition_body is `concat(x, "\n", y)` (\n is not replaced with linebreak).
   *
   * If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the
   * function created with the following statement:
   *
   * `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\n";\n'`
   *
   * The definition_body is
   *
   * `return "\n";\n`
   *
   * Note that both \n are replaced with linebreaks.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefinitionBody() {
    return definitionBody;
  }

  /**
   * Required. The body of the routine.
   *
   * For functions, this is the expression in the AS clause.
   *
   * If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for
   * the function created with the following statement:
   *
   * `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\n", y))`
   *
   * The definition_body is `concat(x, "\n", y)` (\n is not replaced with linebreak).
   *
   * If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the
   * function created with the following statement:
   *
   * `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\n";\n'`
   *
   * The definition_body is
   *
   * `return "\n";\n`
   *
   * Note that both \n are replaced with linebreaks.
   * @param definitionBody definitionBody or {@code null} for none
   */
  public Routine setDefinitionBody(java.lang.String definitionBody) {
    this.definitionBody = definitionBody;
    return this;
  }

  /**
   * Optional. [Experimental] The description of the routine if defined.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. [Experimental] The description of the routine if defined.
   * @param description description or {@code null} for none
   */
  public Routine setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. A hash of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. A hash of this resource.
   * @param etag etag or {@code null} for none
   */
  public Routine setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT
   * libraries.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getImportedLibraries() {
    return importedLibraries;
  }

  /**
   * Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT
   * libraries.
   * @param importedLibraries importedLibraries or {@code null} for none
   */
  public Routine setImportedLibraries(java.util.List<java.lang.String> importedLibraries) {
    this.importedLibraries = importedLibraries;
    return this;
  }

  /**
   * Optional. Defaults to "SQL".
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * Optional. Defaults to "SQL".
   * @param language language or {@code null} for none
   */
  public Routine setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  /**
   * Output only. The time when this routine was last modified, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * Output only. The time when this routine was last modified, in milliseconds since the epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Routine setLastModifiedTime(java.lang.Long lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * Optional if language = "SQL"; required otherwise.
   *
   * If absent, the return type is inferred from definition_body at query time in each query that
   * references this routine. If present, then the evaluated result will be cast to the specified
   * returned type at query time.
   *
   * For example, for the functions created with the following statements:
   *
   * * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);`
   *
   * * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));`
   *
   * * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));`
   *
   * The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for
   * `Increment` (inferred as FLOAT64 at query time).
   *
   * Suppose the function `Add` is replaced by   `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64)
   * AS (x + y);`
   *
   * Then the inferred return type of `Increment` is automatically changed to INT64 at query time,
   * while the return type of `Decrement` remains FLOAT64.
   * @return value or {@code null} for none
   */
  public StandardSqlDataType getReturnType() {
    return returnType;
  }

  /**
   * Optional if language = "SQL"; required otherwise.
   *
   * If absent, the return type is inferred from definition_body at query time in each query that
   * references this routine. If present, then the evaluated result will be cast to the specified
   * returned type at query time.
   *
   * For example, for the functions created with the following statements:
   *
   * * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);`
   *
   * * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));`
   *
   * * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));`
   *
   * The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for
   * `Increment` (inferred as FLOAT64 at query time).
   *
   * Suppose the function `Add` is replaced by   `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64)
   * AS (x + y);`
   *
   * Then the inferred return type of `Increment` is automatically changed to INT64 at query time,
   * while the return type of `Decrement` remains FLOAT64.
   * @param returnType returnType or {@code null} for none
   */
  public Routine setReturnType(StandardSqlDataType returnType) {
    this.returnType = returnType;
    return this;
  }

  /**
   * Required. Reference describing the ID of this routine.
   * @return value or {@code null} for none
   */
  public RoutineReference getRoutineReference() {
    return routineReference;
  }

  /**
   * Required. Reference describing the ID of this routine.
   * @param routineReference routineReference or {@code null} for none
   */
  public Routine setRoutineReference(RoutineReference routineReference) {
    this.routineReference = routineReference;
    return this;
  }

  /**
   * Required. The type of routine.
   * @return value or {@code null} for none
   */
  public java.lang.String getRoutineType() {
    return routineType;
  }

  /**
   * Required. The type of routine.
   * @param routineType routineType or {@code null} for none
   */
  public Routine setRoutineType(java.lang.String routineType) {
    this.routineType = routineType;
    return this;
  }

  @Override
  public Routine set(String fieldName, Object value) {
    return (Routine) super.set(fieldName, value);
  }

  @Override
  public Routine clone() {
    return (Routine) super.clone();
  }

}
