/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-18 at 03:52:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * A field or a column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StandardSqlField extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The name of this field. Can be absent for struct fields.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION
   * statement can omit the return type; in this case the output parameter does not have this "type"
   * field).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StandardSqlDataType type;

  /**
   * Optional. The name of this field. Can be absent for struct fields.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Optional. The name of this field. Can be absent for struct fields.
   * @param name name or {@code null} for none
   */
  public StandardSqlField setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION
   * statement can omit the return type; in this case the output parameter does not have this "type"
   * field).
   * @return value or {@code null} for none
   */
  public StandardSqlDataType getType() {
    return type;
  }

  /**
   * Optional. The type of this parameter. Absent if not explicitly specified (e.g., CREATE FUNCTION
   * statement can omit the return type; in this case the output parameter does not have this "type"
   * field).
   * @param type type or {@code null} for none
   */
  public StandardSqlField setType(StandardSqlDataType type) {
    this.type = type;
    return this;
  }

  @Override
  public StandardSqlField set(String fieldName, Object value) {
    return (StandardSqlField) super.set(fieldName, value);
  }

  @Override
  public StandardSqlField clone() {
    return (StandardSqlField) super.clone();
  }

}
