/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-26 at 03:47:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Arima model information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ArimaModelInfo extends com.google.api.client.json.GenericJson {

  /**
   * Arima coefficients.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaCoefficients arimaCoefficients;

  /**
   * Arima fitting metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaFittingMetrics arimaFittingMetrics;

  /**
   * Non-seasonal order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaOrder nonSeasonalOrder;

  /**
   * Arima coefficients.
   * @return value or {@code null} for none
   */
  public ArimaCoefficients getArimaCoefficients() {
    return arimaCoefficients;
  }

  /**
   * Arima coefficients.
   * @param arimaCoefficients arimaCoefficients or {@code null} for none
   */
  public ArimaModelInfo setArimaCoefficients(ArimaCoefficients arimaCoefficients) {
    this.arimaCoefficients = arimaCoefficients;
    return this;
  }

  /**
   * Arima fitting metrics.
   * @return value or {@code null} for none
   */
  public ArimaFittingMetrics getArimaFittingMetrics() {
    return arimaFittingMetrics;
  }

  /**
   * Arima fitting metrics.
   * @param arimaFittingMetrics arimaFittingMetrics or {@code null} for none
   */
  public ArimaModelInfo setArimaFittingMetrics(ArimaFittingMetrics arimaFittingMetrics) {
    this.arimaFittingMetrics = arimaFittingMetrics;
    return this;
  }

  /**
   * Non-seasonal order.
   * @return value or {@code null} for none
   */
  public ArimaOrder getNonSeasonalOrder() {
    return nonSeasonalOrder;
  }

  /**
   * Non-seasonal order.
   * @param nonSeasonalOrder nonSeasonalOrder or {@code null} for none
   */
  public ArimaModelInfo setNonSeasonalOrder(ArimaOrder nonSeasonalOrder) {
    this.nonSeasonalOrder = nonSeasonalOrder;
    return this;
  }

  @Override
  public ArimaModelInfo set(String fieldName, Object value) {
    return (ArimaModelInfo) super.set(fieldName, value);
  }

  @Override
  public ArimaModelInfo clone() {
    return (ArimaModelInfo) super.clone();
  }

}
