/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-26 at 03:47:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Confusion matrix for multi-class classification models.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConfusionMatrix extends com.google.api.client.json.GenericJson {

  /**
   * Confidence threshold used when computing the entries of the confusion matrix.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double confidenceThreshold;

  /**
   * One row per actual label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Row> rows;

  /**
   * Confidence threshold used when computing the entries of the confusion matrix.
   * @return value or {@code null} for none
   */
  public java.lang.Double getConfidenceThreshold() {
    return confidenceThreshold;
  }

  /**
   * Confidence threshold used when computing the entries of the confusion matrix.
   * @param confidenceThreshold confidenceThreshold or {@code null} for none
   */
  public ConfusionMatrix setConfidenceThreshold(java.lang.Double confidenceThreshold) {
    this.confidenceThreshold = confidenceThreshold;
    return this;
  }

  /**
   * One row per actual label.
   * @return value or {@code null} for none
   */
  public java.util.List<Row> getRows() {
    return rows;
  }

  /**
   * One row per actual label.
   * @param rows rows or {@code null} for none
   */
  public ConfusionMatrix setRows(java.util.List<Row> rows) {
    this.rows = rows;
    return this;
  }

  @Override
  public ConfusionMatrix set(String fieldName, Object value) {
    return (ConfusionMatrix) super.set(fieldName, value);
  }

  @Override
  public ConfusionMatrix clone() {
    return (ConfusionMatrix) super.clone();
  }

}
