/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-26 at 03:47:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for TableDataInsertAllResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableDataInsertAllResponse extends com.google.api.client.json.GenericJson {

  /**
   * An array of errors for rows that were not inserted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InsertErrors> insertErrors;

  static {
    // hack to force ProGuard to consider InsertErrors used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InsertErrors.class);
  }

  /**
   * The resource type of the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * An array of errors for rows that were not inserted.
   * @return value or {@code null} for none
   */
  public java.util.List<InsertErrors> getInsertErrors() {
    return insertErrors;
  }

  /**
   * An array of errors for rows that were not inserted.
   * @param insertErrors insertErrors or {@code null} for none
   */
  public TableDataInsertAllResponse setInsertErrors(java.util.List<InsertErrors> insertErrors) {
    this.insertErrors = insertErrors;
    return this;
  }

  /**
   * The resource type of the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The resource type of the response.
   * @param kind kind or {@code null} for none
   */
  public TableDataInsertAllResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public TableDataInsertAllResponse set(String fieldName, Object value) {
    return (TableDataInsertAllResponse) super.set(fieldName, value);
  }

  @Override
  public TableDataInsertAllResponse clone() {
    return (TableDataInsertAllResponse) super.clone();
  }

  /**
   * Model definition for TableDataInsertAllResponseInsertErrors.
   */
  public static final class InsertErrors extends com.google.api.client.json.GenericJson {

    /**
     * Error information for the row indicated by the index property.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<ErrorProto> errors;

    /**
     * The index of the row that error applies to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Long index;

    /**
     * Error information for the row indicated by the index property.
     * @return value or {@code null} for none
     */
    public java.util.List<ErrorProto> getErrors() {
      return errors;
    }

    /**
     * Error information for the row indicated by the index property.
     * @param errors errors or {@code null} for none
     */
    public InsertErrors setErrors(java.util.List<ErrorProto> errors) {
      this.errors = errors;
      return this;
    }

    /**
     * The index of the row that error applies to.
     * @return value or {@code null} for none
     */
    public java.lang.Long getIndex() {
      return index;
    }

    /**
     * The index of the row that error applies to.
     * @param index index or {@code null} for none
     */
    public InsertErrors setIndex(java.lang.Long index) {
      this.index = index;
      return this;
    }

    @Override
    public InsertErrors set(String fieldName, Object value) {
      return (InsertErrors) super.set(fieldName, value);
    }

    @Override
    public InsertErrors clone() {
      return (InsertErrors) super.clone();
    }

  }

}
