/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger;

/**
 * Service definition for Blogger (v3).
 *
 * <p>
 * The Blogger API provides access to posts, comments and pages of a Blogger blog.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/blogger/docs/3.0/getting_started" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link BloggerRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Blogger extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Blogger API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://blogger.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://blogger.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Blogger(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Blogger(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the BlogUserInfos collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.BlogUserInfos.List request = blogger.blogUserInfos().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BlogUserInfos blogUserInfos() {
    return new BlogUserInfos();
  }

  /**
   * The "blogUserInfos" collection of methods.
   */
  public class BlogUserInfos {

    /**
     * Gets one blog and user info pair by blog id and user id.
     *
     * Create a request for the method "blogUserInfos.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param userId
     * @param blogId
     * @return the request
     */
    public Get get(java.lang.String userId, java.lang.String blogId) throws java.io.IOException {
      Get result = new Get(userId, blogId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.BlogUserInfo> {

      private static final String REST_PATH = "v3/users/{userId}/blogs/{blogId}";

      /**
       * Gets one blog and user info pair by blog id and user id.
       *
       * Create a request for the method "blogUserInfos.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId
       * @param blogId
       * @since 1.13
       */
      protected Get(java.lang.String userId, java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.BlogUserInfo.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String userId;

      /**

       */
      public java.lang.String getUserId() {
        return userId;
      }

      public Get setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxPosts;

      /**

       */
      public java.lang.Long getMaxPosts() {
        return maxPosts;
      }

      public Get setMaxPosts(java.lang.Long maxPosts) {
        this.maxPosts = maxPosts;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Blogs collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.Blogs.List request = blogger.blogs().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Blogs blogs() {
    return new Blogs();
  }

  /**
   * The "blogs" collection of methods.
   */
  public class Blogs {

    /**
     * Gets a blog by id.
     *
     * Create a request for the method "blogs.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @return the request
     */
    public Get get(java.lang.String blogId) throws java.io.IOException {
      Get result = new Get(blogId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.Blog> {

      private static final String REST_PATH = "v3/blogs/{blogId}";

      /**
       * Gets a blog by id.
       *
       * Create a request for the method "blogs.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @since 1.13
       */
      protected Get(java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Blog.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxPosts;

      /**

       */
      public java.lang.Long getMaxPosts() {
        return maxPosts;
      }

      public Get setMaxPosts(java.lang.Long maxPosts) {
        this.maxPosts = maxPosts;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public Get setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets a blog by url.
     *
     * Create a request for the method "blogs.getByUrl".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link GetByUrl#execute()} method to invoke the remote operation.
     *
     * @param url
     * @return the request
     */
    public GetByUrl getByUrl(java.lang.String url) throws java.io.IOException {
      GetByUrl result = new GetByUrl(url);
      initialize(result);
      return result;
    }

    public class GetByUrl extends BloggerRequest<com.google.api.services.blogger.model.Blog> {

      private static final String REST_PATH = "v3/blogs/byurl";

      /**
       * Gets a blog by url.
       *
       * Create a request for the method "blogs.getByUrl".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link GetByUrl#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetByUrl#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param url
       * @since 1.13
       */
      protected GetByUrl(java.lang.String url) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Blog.class);
        this.url = com.google.api.client.util.Preconditions.checkNotNull(url, "Required parameter url must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetByUrl set$Xgafv(java.lang.String $Xgafv) {
        return (GetByUrl) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetByUrl setAccessToken(java.lang.String accessToken) {
        return (GetByUrl) super.setAccessToken(accessToken);
      }

      @Override
      public GetByUrl setAlt(java.lang.String alt) {
        return (GetByUrl) super.setAlt(alt);
      }

      @Override
      public GetByUrl setCallback(java.lang.String callback) {
        return (GetByUrl) super.setCallback(callback);
      }

      @Override
      public GetByUrl setFields(java.lang.String fields) {
        return (GetByUrl) super.setFields(fields);
      }

      @Override
      public GetByUrl setKey(java.lang.String key) {
        return (GetByUrl) super.setKey(key);
      }

      @Override
      public GetByUrl setOauthToken(java.lang.String oauthToken) {
        return (GetByUrl) super.setOauthToken(oauthToken);
      }

      @Override
      public GetByUrl setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetByUrl) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetByUrl setQuotaUser(java.lang.String quotaUser) {
        return (GetByUrl) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetByUrl setUploadType(java.lang.String uploadType) {
        return (GetByUrl) super.setUploadType(uploadType);
      }

      @Override
      public GetByUrl setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetByUrl) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String url;

      /**

       */
      public java.lang.String getUrl() {
        return url;
      }

      public GetByUrl setUrl(java.lang.String url) {
        this.url = url;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public GetByUrl setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public GetByUrl set(String parameterName, Object value) {
        return (GetByUrl) super.set(parameterName, value);
      }
    }
    /**
     * Lists blogs by user.
     *
     * Create a request for the method "blogs.listByUser".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link ListByUser#execute()} method to invoke the remote operation.
     *
     * @param userId
     * @return the request
     */
    public ListByUser listByUser(java.lang.String userId) throws java.io.IOException {
      ListByUser result = new ListByUser(userId);
      initialize(result);
      return result;
    }

    public class ListByUser extends BloggerRequest<com.google.api.services.blogger.model.BlogList> {

      private static final String REST_PATH = "v3/users/{userId}/blogs";

      /**
       * Lists blogs by user.
       *
       * Create a request for the method "blogs.listByUser".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link ListByUser#execute()} method to invoke the remote operation. <p>
       * {@link
       * ListByUser#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId
       * @since 1.13
       */
      protected ListByUser(java.lang.String userId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.BlogList.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListByUser set$Xgafv(java.lang.String $Xgafv) {
        return (ListByUser) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListByUser setAccessToken(java.lang.String accessToken) {
        return (ListByUser) super.setAccessToken(accessToken);
      }

      @Override
      public ListByUser setAlt(java.lang.String alt) {
        return (ListByUser) super.setAlt(alt);
      }

      @Override
      public ListByUser setCallback(java.lang.String callback) {
        return (ListByUser) super.setCallback(callback);
      }

      @Override
      public ListByUser setFields(java.lang.String fields) {
        return (ListByUser) super.setFields(fields);
      }

      @Override
      public ListByUser setKey(java.lang.String key) {
        return (ListByUser) super.setKey(key);
      }

      @Override
      public ListByUser setOauthToken(java.lang.String oauthToken) {
        return (ListByUser) super.setOauthToken(oauthToken);
      }

      @Override
      public ListByUser setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListByUser) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListByUser setQuotaUser(java.lang.String quotaUser) {
        return (ListByUser) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListByUser setUploadType(java.lang.String uploadType) {
        return (ListByUser) super.setUploadType(uploadType);
      }

      @Override
      public ListByUser setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListByUser) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String userId;

      /**

       */
      public java.lang.String getUserId() {
        return userId;
      }

      public ListByUser setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchUserInfo;

      /**

       */
      public java.lang.Boolean getFetchUserInfo() {
        return fetchUserInfo;
      }

      public ListByUser setFetchUserInfo(java.lang.Boolean fetchUserInfo) {
        this.fetchUserInfo = fetchUserInfo;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> role;

      /**

       */
      public java.util.List<java.lang.String> getRole() {
        return role;
      }

      public ListByUser setRole(java.util.List<java.lang.String> role) {
        this.role = role;
        return this;
      }

      /** Default value of status is LIVE. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> status;

      /** Default value of status is LIVE. [default: LIVE]
       */
      public java.util.List<java.lang.String> getStatus() {
        return status;
      }

      /** Default value of status is LIVE. */
      public ListByUser setStatus(java.util.List<java.lang.String> status) {
        this.status = status;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public ListByUser setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public ListByUser set(String parameterName, Object value) {
        return (ListByUser) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.Comments.List request = blogger.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Marks a comment as not spam by blog id, post id and comment id.
     *
     * Create a request for the method "comments.approve".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Approve#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param commentId
     * @return the request
     */
    public Approve approve(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) throws java.io.IOException {
      Approve result = new Approve(blogId, postId, commentId);
      initialize(result);
      return result;
    }

    public class Approve extends BloggerRequest<com.google.api.services.blogger.model.Comment> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}/approve";

      /**
       * Marks a comment as not spam by blog id, post id and comment id.
       *
       * Create a request for the method "comments.approve".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Approve#execute()} method to invoke the remote operation. <p>
       * {@link
       * Approve#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @param commentId
       * @since 1.13
       */
      protected Approve(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Comment.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Approve set$Xgafv(java.lang.String $Xgafv) {
        return (Approve) super.set$Xgafv($Xgafv);
      }

      @Override
      public Approve setAccessToken(java.lang.String accessToken) {
        return (Approve) super.setAccessToken(accessToken);
      }

      @Override
      public Approve setAlt(java.lang.String alt) {
        return (Approve) super.setAlt(alt);
      }

      @Override
      public Approve setCallback(java.lang.String callback) {
        return (Approve) super.setCallback(callback);
      }

      @Override
      public Approve setFields(java.lang.String fields) {
        return (Approve) super.setFields(fields);
      }

      @Override
      public Approve setKey(java.lang.String key) {
        return (Approve) super.setKey(key);
      }

      @Override
      public Approve setOauthToken(java.lang.String oauthToken) {
        return (Approve) super.setOauthToken(oauthToken);
      }

      @Override
      public Approve setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Approve) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Approve setQuotaUser(java.lang.String quotaUser) {
        return (Approve) super.setQuotaUser(quotaUser);
      }

      @Override
      public Approve setUploadType(java.lang.String uploadType) {
        return (Approve) super.setUploadType(uploadType);
      }

      @Override
      public Approve setUploadProtocol(java.lang.String uploadProtocol) {
        return (Approve) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Approve setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Approve setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /**

       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      public Approve setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Approve set(String parameterName, Object value) {
        return (Approve) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a comment by blog id, post id and comment id.
     *
     * Create a request for the method "comments.delete".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param commentId
     * @return the request
     */
    public Delete delete(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) throws java.io.IOException {
      Delete result = new Delete(blogId, postId, commentId);
      initialize(result);
      return result;
    }

    public class Delete extends BloggerRequest<Void> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}";

      /**
       * Deletes a comment by blog id, post id and comment id.
       *
       * Create a request for the method "comments.delete".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @param commentId
       * @since 1.13
       */
      protected Delete(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) {
        super(Blogger.this, "DELETE", REST_PATH, null, Void.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Delete setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Delete setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /**

       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a comment by id.
     *
     * Create a request for the method "comments.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param commentId
     * @return the request
     */
    public Get get(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) throws java.io.IOException {
      Get result = new Get(blogId, postId, commentId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.Comment> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}";

      /**
       * Gets a comment by id.
       *
       * Create a request for the method "comments.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @param commentId
       * @since 1.13
       */
      protected Get(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Comment.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Get setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /**

       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public Get setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists comments.
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @return the request
     */
    public List list(java.lang.String blogId, java.lang.String postId) throws java.io.IOException {
      List result = new List(blogId, postId);
      initialize(result);
      return result;
    }

    public class List extends BloggerRequest<com.google.api.services.blogger.model.CommentList> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments";

      /**
       * Lists comments.
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @since 1.13
       */
      protected List(java.lang.String blogId, java.lang.String postId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.CommentList.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public List setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public List setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String endDate;

      /**

       */
      public java.lang.String getEndDate() {
        return endDate;
      }

      public List setEndDate(java.lang.String endDate) {
        this.endDate = endDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBodies;

      /**

       */
      public java.lang.Boolean getFetchBodies() {
        return fetchBodies;
      }

      public List setFetchBodies(java.lang.Boolean fetchBodies) {
        this.fetchBodies = fetchBodies;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**

       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /**

       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String startDate;

      /**

       */
      public java.lang.String getStartDate() {
        return startDate;
      }

      public List setStartDate(java.lang.String startDate) {
        this.startDate = startDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String status;

      /**

       */
      public java.lang.String getStatus() {
        return status;
      }

      public List setStatus(java.lang.String status) {
        this.status = status;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public List setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists comments by blog.
     *
     * Create a request for the method "comments.listByBlog".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link ListByBlog#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @return the request
     */
    public ListByBlog listByBlog(java.lang.String blogId) throws java.io.IOException {
      ListByBlog result = new ListByBlog(blogId);
      initialize(result);
      return result;
    }

    public class ListByBlog extends BloggerRequest<com.google.api.services.blogger.model.CommentList> {

      private static final String REST_PATH = "v3/blogs/{blogId}/comments";

      /**
       * Lists comments by blog.
       *
       * Create a request for the method "comments.listByBlog".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link ListByBlog#execute()} method to invoke the remote operation. <p>
       * {@link
       * ListByBlog#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @since 1.13
       */
      protected ListByBlog(java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.CommentList.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListByBlog set$Xgafv(java.lang.String $Xgafv) {
        return (ListByBlog) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListByBlog setAccessToken(java.lang.String accessToken) {
        return (ListByBlog) super.setAccessToken(accessToken);
      }

      @Override
      public ListByBlog setAlt(java.lang.String alt) {
        return (ListByBlog) super.setAlt(alt);
      }

      @Override
      public ListByBlog setCallback(java.lang.String callback) {
        return (ListByBlog) super.setCallback(callback);
      }

      @Override
      public ListByBlog setFields(java.lang.String fields) {
        return (ListByBlog) super.setFields(fields);
      }

      @Override
      public ListByBlog setKey(java.lang.String key) {
        return (ListByBlog) super.setKey(key);
      }

      @Override
      public ListByBlog setOauthToken(java.lang.String oauthToken) {
        return (ListByBlog) super.setOauthToken(oauthToken);
      }

      @Override
      public ListByBlog setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListByBlog) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListByBlog setQuotaUser(java.lang.String quotaUser) {
        return (ListByBlog) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListByBlog setUploadType(java.lang.String uploadType) {
        return (ListByBlog) super.setUploadType(uploadType);
      }

      @Override
      public ListByBlog setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListByBlog) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public ListByBlog setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String endDate;

      /**

       */
      public java.lang.String getEndDate() {
        return endDate;
      }

      public ListByBlog setEndDate(java.lang.String endDate) {
        this.endDate = endDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBodies;

      /**

       */
      public java.lang.Boolean getFetchBodies() {
        return fetchBodies;
      }

      public ListByBlog setFetchBodies(java.lang.Boolean fetchBodies) {
        this.fetchBodies = fetchBodies;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**

       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      public ListByBlog setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /**

       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      public ListByBlog setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String startDate;

      /**

       */
      public java.lang.String getStartDate() {
        return startDate;
      }

      public ListByBlog setStartDate(java.lang.String startDate) {
        this.startDate = startDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> status;

      /**

       */
      public java.util.List<java.lang.String> getStatus() {
        return status;
      }

      public ListByBlog setStatus(java.util.List<java.lang.String> status) {
        this.status = status;
        return this;
      }

      @Override
      public ListByBlog set(String parameterName, Object value) {
        return (ListByBlog) super.set(parameterName, value);
      }
    }
    /**
     * Marks a comment as spam by blog id, post id and comment id.
     *
     * Create a request for the method "comments.markAsSpam".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link MarkAsSpam#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param commentId
     * @return the request
     */
    public MarkAsSpam markAsSpam(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) throws java.io.IOException {
      MarkAsSpam result = new MarkAsSpam(blogId, postId, commentId);
      initialize(result);
      return result;
    }

    public class MarkAsSpam extends BloggerRequest<com.google.api.services.blogger.model.Comment> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}/spam";

      /**
       * Marks a comment as spam by blog id, post id and comment id.
       *
       * Create a request for the method "comments.markAsSpam".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link MarkAsSpam#execute()} method to invoke the remote operation. <p>
       * {@link
       * MarkAsSpam#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @param commentId
       * @since 1.13
       */
      protected MarkAsSpam(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Comment.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public MarkAsSpam set$Xgafv(java.lang.String $Xgafv) {
        return (MarkAsSpam) super.set$Xgafv($Xgafv);
      }

      @Override
      public MarkAsSpam setAccessToken(java.lang.String accessToken) {
        return (MarkAsSpam) super.setAccessToken(accessToken);
      }

      @Override
      public MarkAsSpam setAlt(java.lang.String alt) {
        return (MarkAsSpam) super.setAlt(alt);
      }

      @Override
      public MarkAsSpam setCallback(java.lang.String callback) {
        return (MarkAsSpam) super.setCallback(callback);
      }

      @Override
      public MarkAsSpam setFields(java.lang.String fields) {
        return (MarkAsSpam) super.setFields(fields);
      }

      @Override
      public MarkAsSpam setKey(java.lang.String key) {
        return (MarkAsSpam) super.setKey(key);
      }

      @Override
      public MarkAsSpam setOauthToken(java.lang.String oauthToken) {
        return (MarkAsSpam) super.setOauthToken(oauthToken);
      }

      @Override
      public MarkAsSpam setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (MarkAsSpam) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public MarkAsSpam setQuotaUser(java.lang.String quotaUser) {
        return (MarkAsSpam) super.setQuotaUser(quotaUser);
      }

      @Override
      public MarkAsSpam setUploadType(java.lang.String uploadType) {
        return (MarkAsSpam) super.setUploadType(uploadType);
      }

      @Override
      public MarkAsSpam setUploadProtocol(java.lang.String uploadProtocol) {
        return (MarkAsSpam) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public MarkAsSpam setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public MarkAsSpam setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /**

       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      public MarkAsSpam setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public MarkAsSpam set(String parameterName, Object value) {
        return (MarkAsSpam) super.set(parameterName, value);
      }
    }
    /**
     * Removes the content of a comment by blog id, post id and comment id.
     *
     * Create a request for the method "comments.removeContent".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link RemoveContent#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param commentId
     * @return the request
     */
    public RemoveContent removeContent(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) throws java.io.IOException {
      RemoveContent result = new RemoveContent(blogId, postId, commentId);
      initialize(result);
      return result;
    }

    public class RemoveContent extends BloggerRequest<com.google.api.services.blogger.model.Comment> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/comments/{commentId}/removecontent";

      /**
       * Removes the content of a comment by blog id, post id and comment id.
       *
       * Create a request for the method "comments.removeContent".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link RemoveContent#execute()} method to invoke the remote operation. <p>
       * {@link RemoveContent#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param blogId
       * @param postId
       * @param commentId
       * @since 1.13
       */
      protected RemoveContent(java.lang.String blogId, java.lang.String postId, java.lang.String commentId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Comment.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public RemoveContent set$Xgafv(java.lang.String $Xgafv) {
        return (RemoveContent) super.set$Xgafv($Xgafv);
      }

      @Override
      public RemoveContent setAccessToken(java.lang.String accessToken) {
        return (RemoveContent) super.setAccessToken(accessToken);
      }

      @Override
      public RemoveContent setAlt(java.lang.String alt) {
        return (RemoveContent) super.setAlt(alt);
      }

      @Override
      public RemoveContent setCallback(java.lang.String callback) {
        return (RemoveContent) super.setCallback(callback);
      }

      @Override
      public RemoveContent setFields(java.lang.String fields) {
        return (RemoveContent) super.setFields(fields);
      }

      @Override
      public RemoveContent setKey(java.lang.String key) {
        return (RemoveContent) super.setKey(key);
      }

      @Override
      public RemoveContent setOauthToken(java.lang.String oauthToken) {
        return (RemoveContent) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveContent setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveContent) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveContent setQuotaUser(java.lang.String quotaUser) {
        return (RemoveContent) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveContent setUploadType(java.lang.String uploadType) {
        return (RemoveContent) super.setUploadType(uploadType);
      }

      @Override
      public RemoveContent setUploadProtocol(java.lang.String uploadProtocol) {
        return (RemoveContent) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public RemoveContent setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public RemoveContent setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /**

       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      public RemoveContent setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public RemoveContent set(String parameterName, Object value) {
        return (RemoveContent) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the PageViews collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.PageViews.List request = blogger.pageViews().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public PageViews pageViews() {
    return new PageViews();
  }

  /**
   * The "pageViews" collection of methods.
   */
  public class PageViews {

    /**
     * Gets page views by blog id.
     *
     * Create a request for the method "pageViews.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @return the request
     */
    public Get get(java.lang.String blogId) throws java.io.IOException {
      Get result = new Get(blogId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.Pageviews> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pageviews";

      /**
       * Gets page views by blog id.
       *
       * Create a request for the method "pageViews.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @since 1.13
       */
      protected Get(java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Pageviews.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> range;

      /**

       */
      public java.util.List<java.lang.String> getRange() {
        return range;
      }

      public Get setRange(java.util.List<java.lang.String> range) {
        this.range = range;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Pages collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.Pages.List request = blogger.pages().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Pages pages() {
    return new Pages();
  }

  /**
   * The "pages" collection of methods.
   */
  public class Pages {

    /**
     * Deletes a page by blog id and page id.
     *
     * Create a request for the method "pages.delete".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param pageId
     * @return the request
     */
    public Delete delete(java.lang.String blogId, java.lang.String pageId) throws java.io.IOException {
      Delete result = new Delete(blogId, pageId);
      initialize(result);
      return result;
    }

    public class Delete extends BloggerRequest<Void> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";

      /**
       * Deletes a page by blog id and page id.
       *
       * Create a request for the method "pages.delete".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param pageId
       * @since 1.13
       */
      protected Delete(java.lang.String blogId, java.lang.String pageId) {
        super(Blogger.this, "DELETE", REST_PATH, null, Void.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.pageId = com.google.api.client.util.Preconditions.checkNotNull(pageId, "Required parameter pageId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Delete setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageId;

      /**

       */
      public java.lang.String getPageId() {
        return pageId;
      }

      public Delete setPageId(java.lang.String pageId) {
        this.pageId = pageId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a page by blog id and page id.
     *
     * Create a request for the method "pages.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param pageId
     * @return the request
     */
    public Get get(java.lang.String blogId, java.lang.String pageId) throws java.io.IOException {
      Get result = new Get(blogId, pageId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.Page> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";

      /**
       * Gets a page by blog id and page id.
       *
       * Create a request for the method "pages.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param pageId
       * @since 1.13
       */
      protected Get(java.lang.String blogId, java.lang.String pageId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Page.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.pageId = com.google.api.client.util.Preconditions.checkNotNull(pageId, "Required parameter pageId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageId;

      /**

       */
      public java.lang.String getPageId() {
        return pageId;
      }

      public Get setPageId(java.lang.String pageId) {
        this.pageId = pageId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public Get setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a page.
     *
     * Create a request for the method "pages.insert".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param content the {@link com.google.api.services.blogger.model.Page}
     * @return the request
     */
    public Insert insert(java.lang.String blogId, com.google.api.services.blogger.model.Page content) throws java.io.IOException {
      Insert result = new Insert(blogId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BloggerRequest<com.google.api.services.blogger.model.Page> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages";

      /**
       * Inserts a page.
       *
       * Create a request for the method "pages.insert".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param content the {@link com.google.api.services.blogger.model.Page}
       * @since 1.13
       */
      protected Insert(java.lang.String blogId, com.google.api.services.blogger.model.Page content) {
        super(Blogger.this, "POST", REST_PATH, content, com.google.api.services.blogger.model.Page.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Insert setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean isDraft;

      /**

       */
      public java.lang.Boolean getIsDraft() {
        return isDraft;
      }

      public Insert setIsDraft(java.lang.Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists pages.
     *
     * Create a request for the method "pages.list".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @return the request
     */
    public List list(java.lang.String blogId) throws java.io.IOException {
      List result = new List(blogId);
      initialize(result);
      return result;
    }

    public class List extends BloggerRequest<com.google.api.services.blogger.model.PageList> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages";

      /**
       * Lists pages.
       *
       * Create a request for the method "pages.list".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @since 1.13
       */
      protected List(java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.PageList.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public List setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBodies;

      /**

       */
      public java.lang.Boolean getFetchBodies() {
        return fetchBodies;
      }

      public List setFetchBodies(java.lang.Boolean fetchBodies) {
        this.fetchBodies = fetchBodies;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**

       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /**

       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> status;

      /**

       */
      public java.util.List<java.lang.String> getStatus() {
        return status;
      }

      public List setStatus(java.util.List<java.lang.String> status) {
        this.status = status;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public List setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches a page.
     *
     * Create a request for the method "pages.patch".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param pageId
     * @param content the {@link com.google.api.services.blogger.model.Page}
     * @return the request
     */
    public Patch patch(java.lang.String blogId, java.lang.String pageId, com.google.api.services.blogger.model.Page content) throws java.io.IOException {
      Patch result = new Patch(blogId, pageId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BloggerRequest<com.google.api.services.blogger.model.Page> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";

      /**
       * Patches a page.
       *
       * Create a request for the method "pages.patch".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param pageId
       * @param content the {@link com.google.api.services.blogger.model.Page}
       * @since 1.13
       */
      protected Patch(java.lang.String blogId, java.lang.String pageId, com.google.api.services.blogger.model.Page content) {
        super(Blogger.this, "PATCH", REST_PATH, content, com.google.api.services.blogger.model.Page.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.pageId = com.google.api.client.util.Preconditions.checkNotNull(pageId, "Required parameter pageId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Patch setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageId;

      /**

       */
      public java.lang.String getPageId() {
        return pageId;
      }

      public Patch setPageId(java.lang.String pageId) {
        this.pageId = pageId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean publish;

      /**

       */
      public java.lang.Boolean getPublish() {
        return publish;
      }

      public Patch setPublish(java.lang.Boolean publish) {
        this.publish = publish;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean revert;

      /**

       */
      public java.lang.Boolean getRevert() {
        return revert;
      }

      public Patch setRevert(java.lang.Boolean revert) {
        this.revert = revert;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Publishes a page.
     *
     * Create a request for the method "pages.publish".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Publish#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param pageId
     * @return the request
     */
    public Publish publish(java.lang.String blogId, java.lang.String pageId) throws java.io.IOException {
      Publish result = new Publish(blogId, pageId);
      initialize(result);
      return result;
    }

    public class Publish extends BloggerRequest<com.google.api.services.blogger.model.Page> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}/publish";

      /**
       * Publishes a page.
       *
       * Create a request for the method "pages.publish".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Publish#execute()} method to invoke the remote operation. <p>
       * {@link
       * Publish#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param pageId
       * @since 1.13
       */
      protected Publish(java.lang.String blogId, java.lang.String pageId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Page.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.pageId = com.google.api.client.util.Preconditions.checkNotNull(pageId, "Required parameter pageId must be specified.");
      }

      @Override
      public Publish set$Xgafv(java.lang.String $Xgafv) {
        return (Publish) super.set$Xgafv($Xgafv);
      }

      @Override
      public Publish setAccessToken(java.lang.String accessToken) {
        return (Publish) super.setAccessToken(accessToken);
      }

      @Override
      public Publish setAlt(java.lang.String alt) {
        return (Publish) super.setAlt(alt);
      }

      @Override
      public Publish setCallback(java.lang.String callback) {
        return (Publish) super.setCallback(callback);
      }

      @Override
      public Publish setFields(java.lang.String fields) {
        return (Publish) super.setFields(fields);
      }

      @Override
      public Publish setKey(java.lang.String key) {
        return (Publish) super.setKey(key);
      }

      @Override
      public Publish setOauthToken(java.lang.String oauthToken) {
        return (Publish) super.setOauthToken(oauthToken);
      }

      @Override
      public Publish setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Publish) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Publish setQuotaUser(java.lang.String quotaUser) {
        return (Publish) super.setQuotaUser(quotaUser);
      }

      @Override
      public Publish setUploadType(java.lang.String uploadType) {
        return (Publish) super.setUploadType(uploadType);
      }

      @Override
      public Publish setUploadProtocol(java.lang.String uploadProtocol) {
        return (Publish) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Publish setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageId;

      /**

       */
      public java.lang.String getPageId() {
        return pageId;
      }

      public Publish setPageId(java.lang.String pageId) {
        this.pageId = pageId;
        return this;
      }

      @Override
      public Publish set(String parameterName, Object value) {
        return (Publish) super.set(parameterName, value);
      }
    }
    /**
     * Reverts a published or scheduled page to draft state.
     *
     * Create a request for the method "pages.revert".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Revert#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param pageId
     * @return the request
     */
    public Revert revert(java.lang.String blogId, java.lang.String pageId) throws java.io.IOException {
      Revert result = new Revert(blogId, pageId);
      initialize(result);
      return result;
    }

    public class Revert extends BloggerRequest<com.google.api.services.blogger.model.Page> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}/revert";

      /**
       * Reverts a published or scheduled page to draft state.
       *
       * Create a request for the method "pages.revert".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Revert#execute()} method to invoke the remote operation. <p> {@link
       * Revert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param pageId
       * @since 1.13
       */
      protected Revert(java.lang.String blogId, java.lang.String pageId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Page.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.pageId = com.google.api.client.util.Preconditions.checkNotNull(pageId, "Required parameter pageId must be specified.");
      }

      @Override
      public Revert set$Xgafv(java.lang.String $Xgafv) {
        return (Revert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Revert setAccessToken(java.lang.String accessToken) {
        return (Revert) super.setAccessToken(accessToken);
      }

      @Override
      public Revert setAlt(java.lang.String alt) {
        return (Revert) super.setAlt(alt);
      }

      @Override
      public Revert setCallback(java.lang.String callback) {
        return (Revert) super.setCallback(callback);
      }

      @Override
      public Revert setFields(java.lang.String fields) {
        return (Revert) super.setFields(fields);
      }

      @Override
      public Revert setKey(java.lang.String key) {
        return (Revert) super.setKey(key);
      }

      @Override
      public Revert setOauthToken(java.lang.String oauthToken) {
        return (Revert) super.setOauthToken(oauthToken);
      }

      @Override
      public Revert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Revert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Revert setQuotaUser(java.lang.String quotaUser) {
        return (Revert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Revert setUploadType(java.lang.String uploadType) {
        return (Revert) super.setUploadType(uploadType);
      }

      @Override
      public Revert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Revert) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Revert setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageId;

      /**

       */
      public java.lang.String getPageId() {
        return pageId;
      }

      public Revert setPageId(java.lang.String pageId) {
        this.pageId = pageId;
        return this;
      }

      @Override
      public Revert set(String parameterName, Object value) {
        return (Revert) super.set(parameterName, value);
      }
    }
    /**
     * Updates a page by blog id and page id.
     *
     * Create a request for the method "pages.update".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param pageId
     * @param content the {@link com.google.api.services.blogger.model.Page}
     * @return the request
     */
    public Update update(java.lang.String blogId, java.lang.String pageId, com.google.api.services.blogger.model.Page content) throws java.io.IOException {
      Update result = new Update(blogId, pageId, content);
      initialize(result);
      return result;
    }

    public class Update extends BloggerRequest<com.google.api.services.blogger.model.Page> {

      private static final String REST_PATH = "v3/blogs/{blogId}/pages/{pageId}";

      /**
       * Updates a page by blog id and page id.
       *
       * Create a request for the method "pages.update".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param pageId
       * @param content the {@link com.google.api.services.blogger.model.Page}
       * @since 1.13
       */
      protected Update(java.lang.String blogId, java.lang.String pageId, com.google.api.services.blogger.model.Page content) {
        super(Blogger.this, "PUT", REST_PATH, content, com.google.api.services.blogger.model.Page.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.pageId = com.google.api.client.util.Preconditions.checkNotNull(pageId, "Required parameter pageId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Update setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageId;

      /**

       */
      public java.lang.String getPageId() {
        return pageId;
      }

      public Update setPageId(java.lang.String pageId) {
        this.pageId = pageId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean publish;

      /**

       */
      public java.lang.Boolean getPublish() {
        return publish;
      }

      public Update setPublish(java.lang.Boolean publish) {
        this.publish = publish;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean revert;

      /**

       */
      public java.lang.Boolean getRevert() {
        return revert;
      }

      public Update setRevert(java.lang.Boolean revert) {
        this.revert = revert;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the PostUserInfos collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.PostUserInfos.List request = blogger.postUserInfos().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public PostUserInfos postUserInfos() {
    return new PostUserInfos();
  }

  /**
   * The "postUserInfos" collection of methods.
   */
  public class PostUserInfos {

    /**
     * Gets one post and user info pair, by post_id and user_id.
     *
     * Create a request for the method "postUserInfos.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param userId
     * @param blogId
     * @param postId
     * @return the request
     */
    public Get get(java.lang.String userId, java.lang.String blogId, java.lang.String postId) throws java.io.IOException {
      Get result = new Get(userId, blogId, postId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.PostUserInfo> {

      private static final String REST_PATH = "v3/users/{userId}/blogs/{blogId}/posts/{postId}";

      /**
       * Gets one post and user info pair, by post_id and user_id.
       *
       * Create a request for the method "postUserInfos.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId
       * @param blogId
       * @param postId
       * @since 1.13
       */
      protected Get(java.lang.String userId, java.lang.String blogId, java.lang.String postId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.PostUserInfo.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String userId;

      /**

       */
      public java.lang.String getUserId() {
        return userId;
      }

      public Get setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Get setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxComments;

      /**

       */
      public java.lang.Long getMaxComments() {
        return maxComments;
      }

      public Get setMaxComments(java.lang.Long maxComments) {
        this.maxComments = maxComments;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists post and user info pairs.
     *
     * Create a request for the method "postUserInfos.list".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param userId
     * @param blogId
     * @return the request
     */
    public List list(java.lang.String userId, java.lang.String blogId) throws java.io.IOException {
      List result = new List(userId, blogId);
      initialize(result);
      return result;
    }

    public class List extends BloggerRequest<com.google.api.services.blogger.model.PostUserInfosList> {

      private static final String REST_PATH = "v3/users/{userId}/blogs/{blogId}/posts";

      /**
       * Lists post and user info pairs.
       *
       * Create a request for the method "postUserInfos.list".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId
       * @param blogId
       * @since 1.13
       */
      protected List(java.lang.String userId, java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.PostUserInfosList.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String userId;

      /**

       */
      public java.lang.String getUserId() {
        return userId;
      }

      public List setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public List setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String endDate;

      /**

       */
      public java.lang.String getEndDate() {
        return endDate;
      }

      public List setEndDate(java.lang.String endDate) {
        this.endDate = endDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBodies;

      /**
     [ default: false]
     [

       */
      public java.lang.Boolean getFetchBodies() {
        return fetchBodies;
      }

      public List setFetchBodies(java.lang.Boolean fetchBodies) {
        this.fetchBodies = fetchBodies;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBodies() {
        if (fetchBodies == null || fetchBodies == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return fetchBodies;
      }

      @com.google.api.client.util.Key
      private java.lang.String labels;

      /**

       */
      public java.lang.String getLabels() {
        return labels;
      }

      public List setLabels(java.lang.String labels) {
        this.labels = labels;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**

       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /**
     [ default: PUBLISHED]
     [

       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /**

       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String startDate;

      /**

       */
      public java.lang.String getStartDate() {
        return startDate;
      }

      public List setStartDate(java.lang.String startDate) {
        this.startDate = startDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> status;

      /**

       */
      public java.util.List<java.lang.String> getStatus() {
        return status;
      }

      public List setStatus(java.util.List<java.lang.String> status) {
        this.status = status;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public List setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Posts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.Posts.List request = blogger.posts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Posts posts() {
    return new Posts();
  }

  /**
   * The "posts" collection of methods.
   */
  public class Posts {

    /**
     * Deletes a post by blog id and post id.
     *
     * Create a request for the method "posts.delete".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @return the request
     */
    public Delete delete(java.lang.String blogId, java.lang.String postId) throws java.io.IOException {
      Delete result = new Delete(blogId, postId);
      initialize(result);
      return result;
    }

    public class Delete extends BloggerRequest<Void> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";

      /**
       * Deletes a post by blog id and post id.
       *
       * Create a request for the method "posts.delete".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @since 1.13
       */
      protected Delete(java.lang.String blogId, java.lang.String postId) {
        super(Blogger.this, "DELETE", REST_PATH, null, Void.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Delete setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Delete setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a post by blog id and post id
     *
     * Create a request for the method "posts.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @return the request
     */
    public Get get(java.lang.String blogId, java.lang.String postId) throws java.io.IOException {
      Get result = new Get(blogId, postId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";

      /**
       * Gets a post by blog id and post id
       *
       * Create a request for the method "posts.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @since 1.13
       */
      protected Get(java.lang.String blogId, java.lang.String postId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Get setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Get setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBody;

      /**
     [ default: true]
     [

       */
      public java.lang.Boolean getFetchBody() {
        return fetchBody;
      }

      public Get setFetchBody(java.lang.Boolean fetchBody) {
        this.fetchBody = fetchBody;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBody() {
        if (fetchBody == null || fetchBody == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return fetchBody;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchImages;

      /**

       */
      public java.lang.Boolean getFetchImages() {
        return fetchImages;
      }

      public Get setFetchImages(java.lang.Boolean fetchImages) {
        this.fetchImages = fetchImages;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxComments;

      /**

       */
      public java.lang.Long getMaxComments() {
        return maxComments;
      }

      public Get setMaxComments(java.lang.Long maxComments) {
        this.maxComments = maxComments;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public Get setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets a post by path.
     *
     * Create a request for the method "posts.getByPath".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link GetByPath#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param path
     * @return the request
     */
    public GetByPath getByPath(java.lang.String blogId, java.lang.String path) throws java.io.IOException {
      GetByPath result = new GetByPath(blogId, path);
      initialize(result);
      return result;
    }

    public class GetByPath extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/bypath";

      /**
       * Gets a post by path.
       *
       * Create a request for the method "posts.getByPath".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link GetByPath#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetByPath#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param path
       * @since 1.13
       */
      protected GetByPath(java.lang.String blogId, java.lang.String path) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.path = com.google.api.client.util.Preconditions.checkNotNull(path, "Required parameter path must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetByPath set$Xgafv(java.lang.String $Xgafv) {
        return (GetByPath) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetByPath setAccessToken(java.lang.String accessToken) {
        return (GetByPath) super.setAccessToken(accessToken);
      }

      @Override
      public GetByPath setAlt(java.lang.String alt) {
        return (GetByPath) super.setAlt(alt);
      }

      @Override
      public GetByPath setCallback(java.lang.String callback) {
        return (GetByPath) super.setCallback(callback);
      }

      @Override
      public GetByPath setFields(java.lang.String fields) {
        return (GetByPath) super.setFields(fields);
      }

      @Override
      public GetByPath setKey(java.lang.String key) {
        return (GetByPath) super.setKey(key);
      }

      @Override
      public GetByPath setOauthToken(java.lang.String oauthToken) {
        return (GetByPath) super.setOauthToken(oauthToken);
      }

      @Override
      public GetByPath setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetByPath) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetByPath setQuotaUser(java.lang.String quotaUser) {
        return (GetByPath) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetByPath setUploadType(java.lang.String uploadType) {
        return (GetByPath) super.setUploadType(uploadType);
      }

      @Override
      public GetByPath setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetByPath) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public GetByPath setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String path;

      /**

       */
      public java.lang.String getPath() {
        return path;
      }

      public GetByPath setPath(java.lang.String path) {
        this.path = path;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxComments;

      /**

       */
      public java.lang.Long getMaxComments() {
        return maxComments;
      }

      public GetByPath setMaxComments(java.lang.Long maxComments) {
        this.maxComments = maxComments;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public GetByPath setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public GetByPath set(String parameterName, Object value) {
        return (GetByPath) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a post.
     *
     * Create a request for the method "posts.insert".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param content the {@link com.google.api.services.blogger.model.Post}
     * @return the request
     */
    public Insert insert(java.lang.String blogId, com.google.api.services.blogger.model.Post content) throws java.io.IOException {
      Insert result = new Insert(blogId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts";

      /**
       * Inserts a post.
       *
       * Create a request for the method "posts.insert".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param content the {@link com.google.api.services.blogger.model.Post}
       * @since 1.13
       */
      protected Insert(java.lang.String blogId, com.google.api.services.blogger.model.Post content) {
        super(Blogger.this, "POST", REST_PATH, content, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Insert setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBody;

      /**
     [ default: true]
     [

       */
      public java.lang.Boolean getFetchBody() {
        return fetchBody;
      }

      public Insert setFetchBody(java.lang.Boolean fetchBody) {
        this.fetchBody = fetchBody;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBody() {
        if (fetchBody == null || fetchBody == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return fetchBody;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchImages;

      /**

       */
      public java.lang.Boolean getFetchImages() {
        return fetchImages;
      }

      public Insert setFetchImages(java.lang.Boolean fetchImages) {
        this.fetchImages = fetchImages;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean isDraft;

      /**

       */
      public java.lang.Boolean getIsDraft() {
        return isDraft;
      }

      public Insert setIsDraft(java.lang.Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists posts.
     *
     * Create a request for the method "posts.list".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @return the request
     */
    public List list(java.lang.String blogId) throws java.io.IOException {
      List result = new List(blogId);
      initialize(result);
      return result;
    }

    public class List extends BloggerRequest<com.google.api.services.blogger.model.PostList> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts";

      /**
       * Lists posts.
       *
       * Create a request for the method "posts.list".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @since 1.13
       */
      protected List(java.lang.String blogId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.PostList.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public List setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String endDate;

      /**

       */
      public java.lang.String getEndDate() {
        return endDate;
      }

      public List setEndDate(java.lang.String endDate) {
        this.endDate = endDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBodies;

      /**
     [ default: true]
     [

       */
      public java.lang.Boolean getFetchBodies() {
        return fetchBodies;
      }

      public List setFetchBodies(java.lang.Boolean fetchBodies) {
        this.fetchBodies = fetchBodies;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBodies() {
        if (fetchBodies == null || fetchBodies == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return fetchBodies;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchImages;

      /**

       */
      public java.lang.Boolean getFetchImages() {
        return fetchImages;
      }

      public List setFetchImages(java.lang.Boolean fetchImages) {
        this.fetchImages = fetchImages;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String labels;

      /**

       */
      public java.lang.String getLabels() {
        return labels;
      }

      public List setLabels(java.lang.String labels) {
        this.labels = labels;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**

       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /**
     [ default: PUBLISHED]
     [

       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /**

       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String startDate;

      /**

       */
      public java.lang.String getStartDate() {
        return startDate;
      }

      public List setStartDate(java.lang.String startDate) {
        this.startDate = startDate;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> status;

      /**

       */
      public java.util.List<java.lang.String> getStatus() {
        return status;
      }

      public List setStatus(java.util.List<java.lang.String> status) {
        this.status = status;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String view;

      /**

       */
      public java.lang.String getView() {
        return view;
      }

      public List setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches a post.
     *
     * Create a request for the method "posts.patch".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param content the {@link com.google.api.services.blogger.model.Post}
     * @return the request
     */
    public Patch patch(java.lang.String blogId, java.lang.String postId, com.google.api.services.blogger.model.Post content) throws java.io.IOException {
      Patch result = new Patch(blogId, postId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";

      /**
       * Patches a post.
       *
       * Create a request for the method "posts.patch".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @param content the {@link com.google.api.services.blogger.model.Post}
       * @since 1.13
       */
      protected Patch(java.lang.String blogId, java.lang.String postId, com.google.api.services.blogger.model.Post content) {
        super(Blogger.this, "PATCH", REST_PATH, content, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Patch setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Patch setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBody;

      /**
     [ default: true]
     [

       */
      public java.lang.Boolean getFetchBody() {
        return fetchBody;
      }

      public Patch setFetchBody(java.lang.Boolean fetchBody) {
        this.fetchBody = fetchBody;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBody() {
        if (fetchBody == null || fetchBody == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return fetchBody;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchImages;

      /**

       */
      public java.lang.Boolean getFetchImages() {
        return fetchImages;
      }

      public Patch setFetchImages(java.lang.Boolean fetchImages) {
        this.fetchImages = fetchImages;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxComments;

      /**

       */
      public java.lang.Long getMaxComments() {
        return maxComments;
      }

      public Patch setMaxComments(java.lang.Long maxComments) {
        this.maxComments = maxComments;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean publish;

      /**

       */
      public java.lang.Boolean getPublish() {
        return publish;
      }

      public Patch setPublish(java.lang.Boolean publish) {
        this.publish = publish;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean revert;

      /**

       */
      public java.lang.Boolean getRevert() {
        return revert;
      }

      public Patch setRevert(java.lang.Boolean revert) {
        this.revert = revert;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Publishes a post.
     *
     * Create a request for the method "posts.publish".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Publish#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @return the request
     */
    public Publish publish(java.lang.String blogId, java.lang.String postId) throws java.io.IOException {
      Publish result = new Publish(blogId, postId);
      initialize(result);
      return result;
    }

    public class Publish extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/publish";

      /**
       * Publishes a post.
       *
       * Create a request for the method "posts.publish".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Publish#execute()} method to invoke the remote operation. <p>
       * {@link
       * Publish#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @since 1.13
       */
      protected Publish(java.lang.String blogId, java.lang.String postId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public Publish set$Xgafv(java.lang.String $Xgafv) {
        return (Publish) super.set$Xgafv($Xgafv);
      }

      @Override
      public Publish setAccessToken(java.lang.String accessToken) {
        return (Publish) super.setAccessToken(accessToken);
      }

      @Override
      public Publish setAlt(java.lang.String alt) {
        return (Publish) super.setAlt(alt);
      }

      @Override
      public Publish setCallback(java.lang.String callback) {
        return (Publish) super.setCallback(callback);
      }

      @Override
      public Publish setFields(java.lang.String fields) {
        return (Publish) super.setFields(fields);
      }

      @Override
      public Publish setKey(java.lang.String key) {
        return (Publish) super.setKey(key);
      }

      @Override
      public Publish setOauthToken(java.lang.String oauthToken) {
        return (Publish) super.setOauthToken(oauthToken);
      }

      @Override
      public Publish setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Publish) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Publish setQuotaUser(java.lang.String quotaUser) {
        return (Publish) super.setQuotaUser(quotaUser);
      }

      @Override
      public Publish setUploadType(java.lang.String uploadType) {
        return (Publish) super.setUploadType(uploadType);
      }

      @Override
      public Publish setUploadProtocol(java.lang.String uploadProtocol) {
        return (Publish) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Publish setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Publish setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String publishDate;

      /**

       */
      public java.lang.String getPublishDate() {
        return publishDate;
      }

      public Publish setPublishDate(java.lang.String publishDate) {
        this.publishDate = publishDate;
        return this;
      }

      @Override
      public Publish set(String parameterName, Object value) {
        return (Publish) super.set(parameterName, value);
      }
    }
    /**
     * Reverts a published or scheduled post to draft state.
     *
     * Create a request for the method "posts.revert".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Revert#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @return the request
     */
    public Revert revert(java.lang.String blogId, java.lang.String postId) throws java.io.IOException {
      Revert result = new Revert(blogId, postId);
      initialize(result);
      return result;
    }

    public class Revert extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}/revert";

      /**
       * Reverts a published or scheduled post to draft state.
       *
       * Create a request for the method "posts.revert".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Revert#execute()} method to invoke the remote operation. <p> {@link
       * Revert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @since 1.13
       */
      protected Revert(java.lang.String blogId, java.lang.String postId) {
        super(Blogger.this, "POST", REST_PATH, null, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public Revert set$Xgafv(java.lang.String $Xgafv) {
        return (Revert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Revert setAccessToken(java.lang.String accessToken) {
        return (Revert) super.setAccessToken(accessToken);
      }

      @Override
      public Revert setAlt(java.lang.String alt) {
        return (Revert) super.setAlt(alt);
      }

      @Override
      public Revert setCallback(java.lang.String callback) {
        return (Revert) super.setCallback(callback);
      }

      @Override
      public Revert setFields(java.lang.String fields) {
        return (Revert) super.setFields(fields);
      }

      @Override
      public Revert setKey(java.lang.String key) {
        return (Revert) super.setKey(key);
      }

      @Override
      public Revert setOauthToken(java.lang.String oauthToken) {
        return (Revert) super.setOauthToken(oauthToken);
      }

      @Override
      public Revert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Revert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Revert setQuotaUser(java.lang.String quotaUser) {
        return (Revert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Revert setUploadType(java.lang.String uploadType) {
        return (Revert) super.setUploadType(uploadType);
      }

      @Override
      public Revert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Revert) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Revert setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Revert setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @Override
      public Revert set(String parameterName, Object value) {
        return (Revert) super.set(parameterName, value);
      }
    }
    /**
     * Searches for posts matching given query terms in the specified blog.
     *
     * Create a request for the method "posts.search".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param q
     * @return the request
     */
    public Search search(java.lang.String blogId, java.lang.String q) throws java.io.IOException {
      Search result = new Search(blogId, q);
      initialize(result);
      return result;
    }

    public class Search extends BloggerRequest<com.google.api.services.blogger.model.PostList> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/search";

      /**
       * Searches for posts matching given query terms in the specified blog.
       *
       * Create a request for the method "posts.search".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Search#execute()} method to invoke the remote operation. <p> {@link
       * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param q
       * @since 1.13
       */
      protected Search(java.lang.String blogId, java.lang.String q) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.PostList.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.q = com.google.api.client.util.Preconditions.checkNotNull(q, "Required parameter q must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Search set$Xgafv(java.lang.String $Xgafv) {
        return (Search) super.set$Xgafv($Xgafv);
      }

      @Override
      public Search setAccessToken(java.lang.String accessToken) {
        return (Search) super.setAccessToken(accessToken);
      }

      @Override
      public Search setAlt(java.lang.String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setCallback(java.lang.String callback) {
        return (Search) super.setCallback(callback);
      }

      @Override
      public Search setFields(java.lang.String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(java.lang.String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(java.lang.String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(java.lang.String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUploadType(java.lang.String uploadType) {
        return (Search) super.setUploadType(uploadType);
      }

      @Override
      public Search setUploadProtocol(java.lang.String uploadProtocol) {
        return (Search) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Search setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String q;

      /**

       */
      public java.lang.String getQ() {
        return q;
      }

      public Search setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBodies;

      /**
     [ default: true]
     [

       */
      public java.lang.Boolean getFetchBodies() {
        return fetchBodies;
      }

      public Search setFetchBodies(java.lang.Boolean fetchBodies) {
        this.fetchBodies = fetchBodies;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBodies() {
        if (fetchBodies == null || fetchBodies == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return fetchBodies;
      }

      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /**
     [ default: PUBLISHED]
     [

       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      public Search setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      @Override
      public Search set(String parameterName, Object value) {
        return (Search) super.set(parameterName, value);
      }
    }
    /**
     * Updates a post by blog id and post id.
     *
     * Create a request for the method "posts.update".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param blogId
     * @param postId
     * @param content the {@link com.google.api.services.blogger.model.Post}
     * @return the request
     */
    public Update update(java.lang.String blogId, java.lang.String postId, com.google.api.services.blogger.model.Post content) throws java.io.IOException {
      Update result = new Update(blogId, postId, content);
      initialize(result);
      return result;
    }

    public class Update extends BloggerRequest<com.google.api.services.blogger.model.Post> {

      private static final String REST_PATH = "v3/blogs/{blogId}/posts/{postId}";

      /**
       * Updates a post by blog id and post id.
       *
       * Create a request for the method "posts.update".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param blogId
       * @param postId
       * @param content the {@link com.google.api.services.blogger.model.Post}
       * @since 1.13
       */
      protected Update(java.lang.String blogId, java.lang.String postId, com.google.api.services.blogger.model.Post content) {
        super(Blogger.this, "PUT", REST_PATH, content, com.google.api.services.blogger.model.Post.class);
        this.blogId = com.google.api.client.util.Preconditions.checkNotNull(blogId, "Required parameter blogId must be specified.");
        this.postId = com.google.api.client.util.Preconditions.checkNotNull(postId, "Required parameter postId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String blogId;

      /**

       */
      public java.lang.String getBlogId() {
        return blogId;
      }

      public Update setBlogId(java.lang.String blogId) {
        this.blogId = blogId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String postId;

      /**

       */
      public java.lang.String getPostId() {
        return postId;
      }

      public Update setPostId(java.lang.String postId) {
        this.postId = postId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchBody;

      /**
     [ default: true]
     [

       */
      public java.lang.Boolean getFetchBody() {
        return fetchBody;
      }

      public Update setFetchBody(java.lang.Boolean fetchBody) {
        this.fetchBody = fetchBody;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       *
       * </p>
       */
      public boolean isFetchBody() {
        if (fetchBody == null || fetchBody == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return fetchBody;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean fetchImages;

      /**

       */
      public java.lang.Boolean getFetchImages() {
        return fetchImages;
      }

      public Update setFetchImages(java.lang.Boolean fetchImages) {
        this.fetchImages = fetchImages;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Long maxComments;

      /**

       */
      public java.lang.Long getMaxComments() {
        return maxComments;
      }

      public Update setMaxComments(java.lang.Long maxComments) {
        this.maxComments = maxComments;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean publish;

      /**

       */
      public java.lang.Boolean getPublish() {
        return publish;
      }

      public Update setPublish(java.lang.Boolean publish) {
        this.publish = publish;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.Boolean revert;

      /**

       */
      public java.lang.Boolean getRevert() {
        return revert;
      }

      public Update setRevert(java.lang.Boolean revert) {
        this.revert = revert;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Users collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Blogger blogger = new Blogger(...);}
   *   {@code Blogger.Users.List request = blogger.users().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Users users() {
    return new Users();
  }

  /**
   * The "users" collection of methods.
   */
  public class Users {

    /**
     * Gets one user by user_id.
     *
     * Create a request for the method "users.get".
     *
     * This request holds the parameters needed by the blogger server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param userId
     * @return the request
     */
    public Get get(java.lang.String userId) throws java.io.IOException {
      Get result = new Get(userId);
      initialize(result);
      return result;
    }

    public class Get extends BloggerRequest<com.google.api.services.blogger.model.User> {

      private static final String REST_PATH = "v3/users/{userId}";

      /**
       * Gets one user by user_id.
       *
       * Create a request for the method "users.get".
       *
       * This request holds the parameters needed by the the blogger server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId
       * @since 1.13
       */
      protected Get(java.lang.String userId) {
        super(Blogger.this, "GET", REST_PATH, null, com.google.api.services.blogger.model.User.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @com.google.api.client.util.Key
      private java.lang.String userId;

      /**

       */
      public java.lang.String getUserId() {
        return userId;
      }

      public Get setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Blogger}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Blogger}. */
    @Override
    public Blogger build() {
      return new Blogger(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link BloggerRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setBloggerRequestInitializer(
        BloggerRequestInitializer bloggerRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(bloggerRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
