/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.blogger.model;

/**
 * Model definition for Blog.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Blogger API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Blog extends com.google.api.client.json.GenericJson {

  /**
   * The JSON custom meta-data for the Blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customMetaData;

  /**
   * The description of this blog. This is displayed underneath the title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The identifier for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of this entry. Always blogger#blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The locale this Blog is set to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Locale locale;

  /**
   * The name of this blog. This is displayed as the title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The container of pages in this blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Pages pages;

  /**
   * The container of posts in this blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Posts posts;

  /**
   * RFC 3339 date-time when this blog was published.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String published;

  /**
   * The API REST URL to fetch this resource from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The status of the blog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * RFC 3339 date-time when this blog was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updated;

  /**
   * The URL where this blog is published.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * The JSON custom meta-data for the Blog.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomMetaData() {
    return customMetaData;
  }

  /**
   * The JSON custom meta-data for the Blog.
   * @param customMetaData customMetaData or {@code null} for none
   */
  public Blog setCustomMetaData(java.lang.String customMetaData) {
    this.customMetaData = customMetaData;
    return this;
  }

  /**
   * The description of this blog. This is displayed underneath the title.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this blog. This is displayed underneath the title.
   * @param description description or {@code null} for none
   */
  public Blog setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The identifier for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The identifier for this resource.
   * @param id id or {@code null} for none
   */
  public Blog setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of this entry. Always blogger#blog.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of this entry. Always blogger#blog.
   * @param kind kind or {@code null} for none
   */
  public Blog setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The locale this Blog is set to.
   * @return value or {@code null} for none
   */
  public Locale getLocale() {
    return locale;
  }

  /**
   * The locale this Blog is set to.
   * @param locale locale or {@code null} for none
   */
  public Blog setLocale(Locale locale) {
    this.locale = locale;
    return this;
  }

  /**
   * The name of this blog. This is displayed as the title.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this blog. This is displayed as the title.
   * @param name name or {@code null} for none
   */
  public Blog setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The container of pages in this blog.
   * @return value or {@code null} for none
   */
  public Pages getPages() {
    return pages;
  }

  /**
   * The container of pages in this blog.
   * @param pages pages or {@code null} for none
   */
  public Blog setPages(Pages pages) {
    this.pages = pages;
    return this;
  }

  /**
   * The container of posts in this blog.
   * @return value or {@code null} for none
   */
  public Posts getPosts() {
    return posts;
  }

  /**
   * The container of posts in this blog.
   * @param posts posts or {@code null} for none
   */
  public Blog setPosts(Posts posts) {
    this.posts = posts;
    return this;
  }

  /**
   * RFC 3339 date-time when this blog was published.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublished() {
    return published;
  }

  /**
   * RFC 3339 date-time when this blog was published.
   * @param published published or {@code null} for none
   */
  public Blog setPublished(java.lang.String published) {
    this.published = published;
    return this;
  }

  /**
   * The API REST URL to fetch this resource from.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The API REST URL to fetch this resource from.
   * @param selfLink selfLink or {@code null} for none
   */
  public Blog setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The status of the blog.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the blog.
   * @param status status or {@code null} for none
   */
  public Blog setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * RFC 3339 date-time when this blog was last updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdated() {
    return updated;
  }

  /**
   * RFC 3339 date-time when this blog was last updated.
   * @param updated updated or {@code null} for none
   */
  public Blog setUpdated(java.lang.String updated) {
    this.updated = updated;
    return this;
  }

  /**
   * The URL where this blog is published.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * The URL where this blog is published.
   * @param url url or {@code null} for none
   */
  public Blog setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public Blog set(String fieldName, Object value) {
    return (Blog) super.set(fieldName, value);
  }

  @Override
  public Blog clone() {
    return (Blog) super.clone();
  }

  /**
   * The locale this Blog is set to.
   */
  public static final class Locale extends com.google.api.client.json.GenericJson {

    /**
     * The country this blog's locale is set to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String country;

    /**
     * The language this blog is authored in.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String language;

    /**
     * The language variant this blog is authored in.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String variant;

    /**
     * The country this blog's locale is set to.
     * @return value or {@code null} for none
     */
    public java.lang.String getCountry() {
      return country;
    }

    /**
     * The country this blog's locale is set to.
     * @param country country or {@code null} for none
     */
    public Locale setCountry(java.lang.String country) {
      this.country = country;
      return this;
    }

    /**
     * The language this blog is authored in.
     * @return value or {@code null} for none
     */
    public java.lang.String getLanguage() {
      return language;
    }

    /**
     * The language this blog is authored in.
     * @param language language or {@code null} for none
     */
    public Locale setLanguage(java.lang.String language) {
      this.language = language;
      return this;
    }

    /**
     * The language variant this blog is authored in.
     * @return value or {@code null} for none
     */
    public java.lang.String getVariant() {
      return variant;
    }

    /**
     * The language variant this blog is authored in.
     * @param variant variant or {@code null} for none
     */
    public Locale setVariant(java.lang.String variant) {
      this.variant = variant;
      return this;
    }

    @Override
    public Locale set(String fieldName, Object value) {
      return (Locale) super.set(fieldName, value);
    }

    @Override
    public Locale clone() {
      return (Locale) super.clone();
    }

  }

  /**
   * The container of pages in this blog.
   */
  public static final class Pages extends com.google.api.client.json.GenericJson {

    /**
     * The URL of the container for pages in this blog.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String selfLink;

    /**
     * The count of pages in this blog.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer totalItems;

    /**
     * The URL of the container for pages in this blog.
     * @return value or {@code null} for none
     */
    public java.lang.String getSelfLink() {
      return selfLink;
    }

    /**
     * The URL of the container for pages in this blog.
     * @param selfLink selfLink or {@code null} for none
     */
    public Pages setSelfLink(java.lang.String selfLink) {
      this.selfLink = selfLink;
      return this;
    }

    /**
     * The count of pages in this blog.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getTotalItems() {
      return totalItems;
    }

    /**
     * The count of pages in this blog.
     * @param totalItems totalItems or {@code null} for none
     */
    public Pages setTotalItems(java.lang.Integer totalItems) {
      this.totalItems = totalItems;
      return this;
    }

    @Override
    public Pages set(String fieldName, Object value) {
      return (Pages) super.set(fieldName, value);
    }

    @Override
    public Pages clone() {
      return (Pages) super.clone();
    }

  }

  /**
   * The container of posts in this blog.
   */
  public static final class Posts extends com.google.api.client.json.GenericJson {

    /**
     * The List of Posts for this Blog.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Post> items;

    /**
     * The URL of the container for posts in this blog.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String selfLink;

    /**
     * The count of posts in this blog.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer totalItems;

    /**
     * The List of Posts for this Blog.
     * @return value or {@code null} for none
     */
    public java.util.List<Post> getItems() {
      return items;
    }

    /**
     * The List of Posts for this Blog.
     * @param items items or {@code null} for none
     */
    public Posts setItems(java.util.List<Post> items) {
      this.items = items;
      return this;
    }

    /**
     * The URL of the container for posts in this blog.
     * @return value or {@code null} for none
     */
    public java.lang.String getSelfLink() {
      return selfLink;
    }

    /**
     * The URL of the container for posts in this blog.
     * @param selfLink selfLink or {@code null} for none
     */
    public Posts setSelfLink(java.lang.String selfLink) {
      this.selfLink = selfLink;
      return this;
    }

    /**
     * The count of posts in this blog.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getTotalItems() {
      return totalItems;
    }

    /**
     * The count of posts in this blog.
     * @param totalItems totalItems or {@code null} for none
     */
    public Posts setTotalItems(java.lang.Integer totalItems) {
      this.totalItems = totalItems;
      return this;
    }

    @Override
    public Posts set(String fieldName, Object value) {
      return (Posts) super.set(fieldName, value);
    }

    @Override
    public Posts clone() {
      return (Posts) super.clone();
    }

  }

}
